/**
  * @Description: 专项工程功能下的添加表单，添加字段，这是处理字段需要用的数据以及方法
  * @Date: 2024年2月26日
 */

export const addApproveUsers = {
    data() {
        return {
            approveUsers: {
                glzxsh: [], // 管理中心确认人
                glzxzr: [], // 管理中心主任
                fgssh: [], // 分公司主管部门
                fgszg: [], // 分公司主管审核人
                yhzb: [], // 养护总部审核人
                yhzbzg: [], // 养护总部主管审核人
            },
        }
    },
    created() {

    },
    methods: {
        changeRoadUpadateUsers(roadName) {
            this.getApproveUsers('glzxsh', roadName)
            this.getApproveUsers('glzxzr', roadName)
            this.getApproveUsers('fgszg', roadName)
            // this.getApproveUsers('yhzb', roadName)
            this.getApproveUsers('fgssh', roadName)
            this.getApproveUsers('yhzbzg', roadName)
        },
        reset() {
            this.approveUsers = {
                glzxsh: [], // 管理中心确认人
                glzxzr: [], // 管理中心主任
                fgssh: [], // 分公司主管部门
                fgszg: [], // 分公司主管审核人
                yhzb: [], // 养护总部审核人
                yhzbzg: [], // 养护总部主管审核人
            },
                this.form.managementApproveId = ''
            this.form.managementApproveAccount = ""
            this.form.managementApproveName = ""

            this.form.managementDirectorApproveId = ''
            this.form.managementDirectorApproveAccount = ""
            this.form.managementDirectorApproveName = ""

            this.form.operationDirectorId = ''
            this.form.operationDirectorAccount = ""
            this.form.operationDirectorName = ""

            this.form.headquartersId = ''
            this.form.headquartersAccount = ""
            this.form.headquartersName = ""

            this.form.headquartersDirectorId = ''
            this.form.headquartersDirectorAccount = ""
            this.form.headquartersDirectorName = ""

            this.form.operationId = ''
            this.form.operationAccount = ''
            this.form.operationName = ''
        },
        // 根据code获取审核人数据
        getApproveUsers(code, roadName) {
            console.log(roadName, "roadName")
            this.$http
                .get(
                    '${yhxt}/bizRectificationCommon/v1/users/getApproveUsers?code=' + code + '&roadName=' + roadName
                )
                .then((res) => {
                    this.approveUsers[code] = res.data
                })
        },
        // 管理中心确认人
        handleManagementApprove(id) {
            this.approveUsers.glzxsh.forEach((item) => {
                if (item.id === id) {
                    this.form.managementApproveAccount = item.account
                    this.form.managementApproveName = item.fullname
                }
            })
        },
        // 管理中心主任审核人
        handleManagementDirectorApprove(id) {
            this.approveUsers.glzxzr.forEach((item) => {
                if (item.id === id) {
                    this.form.managementDirectorApproveAccount = item.account
                    this.form.managementDirectorApproveName = item.fullname
                }
            })
        },
        // 分公司主管审核人
        handleOperationDirector(id) {
            this.approveUsers.fgszg.forEach((item) => {
                if (item.id === id) {
                    this.form.operationDirectorAccount = item.account
                    this.form.operationDirectorName = item.fullname
                }
            })
        },
        // 护总部审核人
        handleHeadquarters(id) {
            this.approveUsers.yhzb.forEach((item) => {
                if (item.id === id) {
                    this.form.headquartersAccount = item.account
                    this.form.headquartersName = item.fullname
                }
            })
        },
        // 养护总部主管审核人
        handleHeadquartersDirector(id) {
            this.approveUsers.yhzbzg.forEach((item) => {
                if (item.id === id) {
                    this.form.headquartersDirectorAccount = item.account
                    this.form.headquartersDirectorName = item.fullname
                }
            })
        },
        // 分公司主管部门
        handleOperationId(id) {
            this.approveUsers.fgssh.forEach((item) => {
                if (item.id === id) {
                    this.form.operationAccount = item.account
                    this.form.operationName = item.fullname
                }
            })
        },
    },
}
