import req from "@/request.js";

const yhxt = window.context.yhxt;

export default {
    addApply(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApply/v1/", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    editApply(data) {
        return new Promise((resolve, reject) => {
            req.put(yhxt + "/bizCloudApply/v1/", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    getApply(id) {
        return new Promise((resolve, reject) => {
            req.get(yhxt + "/bizCloudApply/v1/getInfo/" + id).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    deleteApply(ids) {
        return new Promise((resolve, reject) => {
            req.remove(yhxt + "/bizCloudApply/v1/?ids=" + ids).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    downloadApply(id) {
        return new Promise((resolve, reject) => {
            req.downloadGet(yhxt + "/bizCloudApply/v1/export/" + id).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    queryCloudApplyUse(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApplyUseDetailed/v1/query", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    saveCloudApplyUse(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApplyUseDetailed/v1/save/list", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    getCloudUseage() {
        return new Promise((resolve, reject) => {
            req.get(yhxt + "/bizCloudApplyUseDetailed/v1/latest").then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    saveApply(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApply/v1/save", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    queryCloudApplyDetail(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApplyDetail/v1/query", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    addApplyDetail(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApplyDetail/v1/save", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    editApplyDetail(data) {
        return new Promise((resolve, reject) => {
            req.put(yhxt + "/bizCloudApplyDetail/v1/update", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    getApplyDetail(id) {
        return new Promise((resolve, reject) => {
            req.get(yhxt + "/bizCloudApplyDetail/v1/list/" + id).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    deleteApplyDetail(ids) {
        return new Promise((resolve, reject) => {
            req.remove(yhxt + "/bizCloudApplyDetail/v1/?ids=" + ids).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    applyApproval(type, data) {
        // type -- start 发起 agree 同意 reject 驳回 complete 完成
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApplyApprovalRecord/v1/" + type, data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    // 查询待审核、待执行申请
    queryApplyApproval(data) {
        return new Promise((resolve, reject) => {
            req.post(yhxt + "/bizCloudApply/v1/query/todo", data).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },
    deleteDetailPorts(id) {
        return new Promise((resolve, reject) => {
            req.remove(yhxt + "/bizCloudApplyDetailPort/v1/" + id).then(
                response => {
                    resolve(response.data ? response.data : {});
                },
                error => {
                    reject(error);
                }
            );
        });
    },

}
