/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.util.FileUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptUtil {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String DEFAULT_PASSWORD = "Djk@%&opN!$$*";

    public static String md5Hex(String inStr) throws Exception {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(inStr.getBytes());
            return EncryptUtil.parseByte2HexStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String encryptMd5(String inStr) throws Exception {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(inStr.getBytes());
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String encryptFileMd5(String fileName) throws Exception {
        byte[] bytes = FileUtil.readByte(fileName);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(bytes);
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static synchronized String encryptSha256(String inputStr) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(inputStr.getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encrypt(String content) throws Exception {
        return EncryptUtil.encrypt(content, DEFAULT_PASSWORD);
    }

    public static String encrypt(String content, String password) throws Exception {
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        byte[] byteContent = content.getBytes("utf-8");
        cipher.init(1, EncryptUtil.getSecretKey(password));
        byte[] result = cipher.doFinal(byteContent);
        return Base64.encodeBase64String((byte[])result);
    }

    public static String decrypt(String content) throws Exception {
        return EncryptUtil.decrypt(content, DEFAULT_PASSWORD);
    }

    public static String decrypt(String content, String password) throws Exception {
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        cipher.init(2, EncryptUtil.getSecretKey(password));
        byte[] result = cipher.doFinal(Base64.decodeBase64((String)content));
        return new String(result, "utf-8");
    }

    private static SecretKeySpec getSecretKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator kg = null;
        kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password.getBytes());
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

