/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.conf;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.constants.TenantConstant;
import com.artfess.base.filter.ClobDataResultSetFilter;
import com.artfess.base.filter.FormDataResultSetFilter;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.id.MybatisPlusIdGenerator;
import com.artfess.base.interceptor.DataPermissionInterceptor;
import com.artfess.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.artfess.base.interceptor.ResultSetInterceptor;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfig {
    @Autowired
    MultiTenantHandler myTenantHandler;
    @Autowired
    SaaSConfig saaSConfig;

    @Bean
    public Interceptor getInterceptor() {
        return new DataPermissionInterceptor();
    }

    @Bean
    public Interceptor getResultSetInterceptor() {
        ResultSetInterceptor resultSetInterceptor = new ResultSetInterceptor();
        FormDataResultSetFilter formDataResultSetFilter = new FormDataResultSetFilter();
        ClobDataResultSetFilter clobDataResultSetFilter = new ClobDataResultSetFilter();
        resultSetInterceptor.addFilters(formDataResultSetFilter);
        resultSetInterceptor.addFilters(clobDataResultSetFilter);
        return resultSetInterceptor;
    }

    @Bean
    public IdentifierGenerator identifierGenerator() {
        return new MybatisPlusIdGenerator();
    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        ArrayList<TenantSqlParser> sqlParserList = new ArrayList<TenantSqlParser>();
        if (this.saaSConfig.isEnable()) {
            this.myTenantHandler.setTenantId(this.saaSConfig.getTenantId());
            List<String> ignoreTables = this.saaSConfig.getIgnoreTables();
            ignoreTables.addAll(TenantConstant.IGNORE_TABLES);
            this.myTenantHandler.setIgnoreTableNames(ignoreTables);
            TenantSqlParser tenantSqlParser = new TenantSqlParser();
            tenantSqlParser.setTenantHandler((TenantHandler)this.myTenantHandler);
            sqlParserList.add(tenantSqlParser);
        }
        paginationInterceptor.setSqlParserList(sqlParserList);
        return paginationInterceptor;
    }

    @Bean
    public MasterSlaveAutoRoutingPlugin masterSlaveAutoRoutingPlugin() {
        return new MasterSlaveAutoRoutingPlugin();
    }

    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.put("Oracle", "oracle");
        properties.put("MySQL", "mysql");
        properties.put("H2", "h2");
        properties.put("SQLServer", "sqlserver");
        properties.put("PostgreSQL", "pg");
        properties.put("DM DBMS", "oracle");
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }
}

