/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.portal.model.PortalNewsTree;
import com.artfess.portal.persistence.manager.PortalNewsNoticeManager;
import com.artfess.portal.persistence.manager.PortalNewsTreeManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portalNewsTree/v1/"})
public class PortalNewsTreeController
extends BaseController<PortalNewsTreeManager, PortalNewsTree> {
    @Resource
    PortalNewsNoticeManager portalNewsNoticeManager;

    @PostMapping(value={"/createEntity"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> createEntity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody PortalNewsTree t) throws Exception {
        if (StringUtil.isEmpty((String)t.getId())) {
            t.setId(UniqueIdUtil.getSuid());
            t.setIntervalTime(BigDecimal.valueOf(3000L));
            String parentId = t.getParentId();
            PortalNewsTree portalNewsTree = (PortalNewsTree)((PortalNewsTreeManager)this.baseService).get((Serializable)((Object)parentId));
            t.setPath(portalNewsTree.getPath() + t.getId() + ".");
            ((PortalNewsTreeManager)this.baseService).create((Model)t);
        } else {
            ((PortalNewsTreeManager)this.baseService).updateEntity(t);
        }
        return new CommonResult();
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u6811\u5f62\u83dc\u5355")
    public List<PortalNewsTree> getTree() throws Exception {
        List list = ((PortalNewsTreeManager)this.baseService).getAll();
        list = BeanUtils.listToTree((List)list);
        return list;
    }

    @GetMapping(value={"/issue"})
    @ApiOperation(value="\u628a\u7b2c\u4e09\u7ea7\u83dc\u5355\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee")
    public CommonResult<String> issue(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        return ((PortalNewsTreeManager)this.baseService).issue(id);
    }

    @GetMapping(value={"/mobileIssue"})
    @ApiOperation(value="\u628a\u7b2c\u4e09\u7ea7\u83dc\u5355\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee")
    public CommonResult<String> mobileIssue(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        return ((PortalNewsTreeManager)this.baseService).mobileIssue(id);
    }

    @RequestMapping(value={"mobileRemove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u53d1\u5e03", httpMethod="DELETE", notes="\u53d6\u6d88\u53d1\u5e03")
    public CommonResult<String> mobileRemove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        return ((PortalNewsTreeManager)this.baseService).mobileRemove(id);
    }

    @PostMapping(value={"exportTree"})
    @ApiOperation(value="\u5bfc\u51fa\u5206\u7c7b", httpMethod="POST", notes="\u5bfc\u51fa\u5206\u7c7b")
    public void exportTree(HttpServletResponse response, HttpServletRequest request, @RequestBody PortalNewsTree portalNewsTree, @RequestParam String exportType) throws Exception {
        BigDecimal rank = portalNewsTree.getRank();
        PageBean pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        if (BeanUtils.isNotEmpty((Object)rank)) {
            QueryFilter queryFilter;
            String json = "";
            HashMap<String, List> exportMap = new HashMap<String, List>();
            if (rank.intValue() == 1) {
                queryFilter = QueryFilter.build();
                queryFilter.addFilter("PATH_", (Object)portalNewsTree.getPath().split("\\.")[0], QueryOP.RIGHT_LIKE, FieldRelation.AND);
                queryFilter.addFilter("ID_", (Object)portalNewsTree.getId(), QueryOP.NOT_EQUAL, FieldRelation.AND);
                queryFilter.setPageBean(pageBean);
                PageList query = ((PortalNewsTreeManager)this.baseService).query(queryFilter);
                exportMap.put("trees", query.getRows());
                if ("1".equals(exportType)) {
                    json = JsonUtil.toJson(exportMap);
                } else if ("2".equals(exportType)) {
                    QueryFilter noticeFilter = QueryFilter.build();
                    noticeFilter.addFilter("CLASSIFY_PATH_", (Object)portalNewsTree.getPath().split("\\.")[0], QueryOP.RIGHT_LIKE, FieldRelation.AND);
                    noticeFilter.setPageBean(pageBean);
                    PageList notices = this.portalNewsNoticeManager.query(noticeFilter);
                    exportMap.put("notices", notices.getRows());
                    json = JsonUtil.toJson(exportMap);
                }
            } else if (rank.intValue() == 2) {
                queryFilter = QueryFilter.build();
                queryFilter.addFilter("PATH_", (Object)(portalNewsTree.getPath().split("\\.")[0] + "." + portalNewsTree.getPath().split("\\.")[1]), QueryOP.RIGHT_LIKE, FieldRelation.AND);
                queryFilter.addFilter("PARENT_ID_", (Object)portalNewsTree.getId(), QueryOP.EQUAL, FieldRelation.AND);
                queryFilter.setPageBean(pageBean);
                PageList query = ((PortalNewsTreeManager)this.baseService).query(queryFilter);
                exportMap.put("trees", query.getRows());
                if ("1".equals(exportType)) {
                    json = JsonUtil.toJson(exportMap);
                } else if ("2".equals(exportType)) {
                    QueryFilter noticeFilter = QueryFilter.build();
                    noticeFilter.addFilter("CLASSIFY_PATH_", (Object)(portalNewsTree.getPath().split("\\.")[0] + "." + portalNewsTree.getPath().split("\\.")[1]), QueryOP.RIGHT_LIKE, FieldRelation.AND);
                    noticeFilter.setPageBean(pageBean);
                    PageList notices = this.portalNewsNoticeManager.query(noticeFilter);
                    exportMap.put("notices", notices.getRows());
                    json = JsonUtil.toJson(exportMap);
                }
            } else {
                throw new BaseException("\u4e0d\u652f\u6301\u8be5\u5206\u7c7b\u7684\u5bfc\u51fa");
            }
            if (StringUtil.isNotEmpty((String)json)) {
                String fileName = "portalTree" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
                HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"portalTree.json", (String)fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"importTree"})
    @ApiOperation(value="\u5bfc\u5165\u5206\u7c7b", httpMethod="POST", notes="\u5bfc\u5165\u5206\u7c7b")
    public CommonResult<String> importTree(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam String classifyId) throws Exception {
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            ((PortalNewsTreeManager)this.baseService).importFile(uzPath, classifyId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }
}

