/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.task.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.uc.util.ContextUtil;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.specialcheck.vo.SiteTaskVo;
import com.artfess.yhxt.task.dao.TaskWaitHandleDao;
import com.artfess.yhxt.task.manager.TaskAlreadyHandleHistoryManager;
import com.artfess.yhxt.task.manager.TaskWaitHandleManager;
import com.artfess.yhxt.task.model.TaskAlreadyHandleHistory;
import com.artfess.yhxt.task.model.TaskWaitHandle;
import com.artfess.yhxt.task.vo.TaskWaitHandleVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TaskWaitHandleManagerImpl
extends BaseManagerImpl<TaskWaitHandleDao, TaskWaitHandle>
implements TaskWaitHandleManager {
    @Resource
    private IdGenerator idGenerator;
    @Resource
    private BaseContext baseContext;
    @Resource
    private IUserService iUserService;
    @Resource
    private TaskAlreadyHandleHistoryManager taskAlreadyHandleHistoryManager;

    @Override
    public void saveTask(SiteInspection siteInspection, String bizType) {
        String bizId = siteInspection.getId();
        String sendUserId = this.baseContext.getCurrentUserId();
        String sendUserAccout = this.baseContext.getCurrentUserAccout();
        String sendUserName = this.baseContext.getCurrentUserName();
        LocalDateTime sendTime = LocalDateTime.now();
        String sendDeptId = this.baseContext.getCurrentDeptId();
        String sendDeptName = this.baseContext.getCurrentDeptName();
        List taskWaitHandles = ((TaskWaitHandleDao)this.baseMapper).selectList((Wrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId));
        String itemId = null;
        if (taskWaitHandles.size() == 0) {
            itemId = this.idGenerator.getSuid();
        }
        String itemTitle = sendUserName + "[" + LocalDate.now() + "]\u521b\u5efa\u5de1\u68c0\u4efb\u52a1";
        String rummagerIds = siteInspection.getRummagerId();
        List<String> ids = Arrays.asList(rummagerIds.split(","));
        for (String rummagerId : ids) {
            TaskWaitHandle taskWaitHandle = new TaskWaitHandle();
            taskWaitHandle.setBizId(bizId);
            taskWaitHandle.setBizType(bizType);
            if (itemId != null) {
                taskWaitHandle.setItemId(itemId);
            }
            taskWaitHandle.setItemTitle(itemTitle);
            taskWaitHandle.setItemSource(2);
            taskWaitHandle.setItemType(1);
            IUser iUser = this.iUserService.getUserById(rummagerId);
            String account = iUser.getAccount();
            String userId = iUser.getUserId();
            String fullname = iUser.getFullname();
            taskWaitHandle.setReceiveDeptId(ContextUtil.getCurrentDeptId((String)rummagerId));
            taskWaitHandle.setReceiveDeptName(ContextUtil.getCurrentDeptName((String)rummagerId));
            if (sendDeptId == null) {
                taskWaitHandle.setSendDeptName(siteInspection.getCompanyName());
                taskWaitHandle.setSendDeptId(siteInspection.getCompanyId());
                taskWaitHandle.setSendDate(sendTime);
                taskWaitHandle.setSendUserId(siteInspection.getCreateBy());
                taskWaitHandle.setSendUserName(siteInspection.getCreateName());
                taskWaitHandle.setItemTitle(itemTitle);
            } else {
                taskWaitHandle.setSendDeptName(sendDeptName);
                taskWaitHandle.setSendDeptId(sendDeptId);
                taskWaitHandle.setSendDate(sendTime);
                taskWaitHandle.setSendLoginName(sendUserAccout);
                taskWaitHandle.setSendUserId(sendUserId);
                taskWaitHandle.setSendUserName(sendUserName);
                taskWaitHandle.setItemTitle(itemTitle);
            }
            taskWaitHandle.setModeType(2);
            taskWaitHandle.setPriority(0);
            taskWaitHandle.setReceiveUserName(fullname);
            taskWaitHandle.setReceiveLoginName(account);
            taskWaitHandle.setReceiveUserId(rummagerId);
            taskWaitHandle.setWorkflowId("cjxjrw");
            taskWaitHandle.setWorkflowName("\u65e5\u5e38\u5de1\u68c0\u4efb\u52a1");
            taskWaitHandle.setWorkflowInstance(itemId);
            taskWaitHandle.setWorkflowInstanceName(itemTitle);
            taskWaitHandle.setActivitiesId("1");
            this.create((Model)taskWaitHandle);
            TaskAlreadyHandleHistory taskAlreadyHandleHistory = TaskWaitHandle.getTaskAlreadyHandleHistory(taskWaitHandle);
            taskAlreadyHandleHistory.setProcessingStatus("1");
            this.taskAlreadyHandleHistoryManager.create((Model)taskAlreadyHandleHistory);
        }
    }

    @Override
    public PageList<TaskWaitHandleVo> queryTaskWaitHandle(QueryFilter<TaskWaitHandle> queryFilter) {
        String userId = this.baseContext.getCurrentUserId();
        String userAccout = this.baseContext.getCurrentUserAccout();
        String userName = this.baseContext.getCurrentUserName();
        LocalDateTime time = LocalDateTime.now();
        String deptId = this.baseContext.getCurrentDeptId();
        String deptName = this.baseContext.getCurrentDeptName();
        String sendDeptName = this.baseContext.getCurrentDeptName();
        queryFilter.addFilter("RECEIVE_USER_ID", (Object)userId, QueryOP.EQUAL);
        IPage<TaskWaitHandleVo> result = ((TaskWaitHandleDao)this.baseMapper).queryTaskWaitHandleVo((IPage<TaskWaitHandle>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TaskWaitHandle>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void updateTask(SiteTaskVo siteTaskVo) {
        TaskAlreadyHandleHistory taskAlreadyHandleHistory;
        String bizId = siteTaskVo.getSiteId();
        String status = siteTaskVo.getStatus();
        String itemId = siteTaskVo.getItemId();
        String userId = this.baseContext.getCurrentUserId();
        String userAccout = this.baseContext.getCurrentUserAccout();
        String userName = this.baseContext.getCurrentUserName();
        LocalDate time = LocalDate.now();
        String deptId = this.baseContext.getCurrentDeptId();
        String deptName = this.baseContext.getCurrentDeptName();
        QueryWrapper handleQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)handleQueryWrapper.eq((Object)"BIZ_ID", (Object)bizId)).eq((Object)"ITEM_ID", (Object)itemId)).eq((Object)"RECEIVE_USER_ID", (Object)userId);
        TaskWaitHandle taskWaitHandle = (TaskWaitHandle)((Object)this.getOne((Wrapper)handleQueryWrapper));
        String activitiesId = taskWaitHandle.getActivitiesId();
        taskWaitHandle.setActivitiesId(status);
        String itemTitle = null;
        if (status.equals("6")) {
            itemTitle = userName + "[" + time + "]\u62d2\u7edd\u5de1\u68c0\u4efb\u52a1";
        }
        if (status.equals("2")) {
            itemTitle = userName + "[" + time + "]\u63a5\u53d7\u5de1\u68c0\u4efb\u52a1";
        }
        if (status.equals("3")) {
            itemTitle = userName + "[" + time + "]\u5b8c\u6210\u5de1\u68c0\u4efb\u52a1";
        }
        if (status.equals("4")) {
            itemTitle = userName + "[" + time + "]\u786e\u8ba4\u65e0\u75c5\u5bb3";
        }
        if (status.equals("5")) {
            itemTitle = userName + "[" + time + "]\u586b\u5199\u75c5\u5bb3";
        }
        if (status.equals("6")) {
            taskWaitHandle.setReceiveUserId(taskWaitHandle.getSendUserId());
            taskWaitHandle.setReceiveUserName(taskWaitHandle.getSendUserName());
            taskWaitHandle.setReceiveLoginName(taskWaitHandle.getSendLoginName());
            taskWaitHandle.setReceiveDeptName(taskWaitHandle.getReceiveDeptName());
            taskWaitHandle.setReceiveDeptId(taskWaitHandle.getSendDeptId());
            taskAlreadyHandleHistory = TaskWaitHandle.getTaskAlreadyHandleHistory(taskWaitHandle);
            taskAlreadyHandleHistory.setTransDate(LocalDateTime.now());
            taskAlreadyHandleHistory.setProcessingStatus(siteTaskVo.getProcessingStatus());
            taskAlreadyHandleHistory.setItemTitle(itemTitle);
            this.taskAlreadyHandleHistoryManager.create((Model)taskAlreadyHandleHistory);
        }
        if (!activitiesId.equals("1")) {
            taskAlreadyHandleHistory = TaskWaitHandle.getTaskAlreadyHandleHistory(taskWaitHandle);
            taskAlreadyHandleHistory.setTransDate(LocalDateTime.now());
            taskAlreadyHandleHistory.setProcessingStatus(siteTaskVo.getProcessingStatus());
            taskAlreadyHandleHistory.setItemTitle(itemTitle);
            this.taskAlreadyHandleHistoryManager.create((Model)taskAlreadyHandleHistory);
        }
        if (status.equals("2")) {
            taskAlreadyHandleHistory = TaskWaitHandle.getTaskAlreadyHandleHistory(taskWaitHandle);
            taskAlreadyHandleHistory.setTransDate(LocalDateTime.now());
            taskAlreadyHandleHistory.setProcessingStatus(siteTaskVo.getProcessingStatus());
            taskAlreadyHandleHistory.setProcessingStatus(siteTaskVo.getProcessingStatus());
            taskAlreadyHandleHistory.setItemTitle(itemTitle);
            this.taskAlreadyHandleHistoryManager.create((Model)taskAlreadyHandleHistory);
        }
        if (taskWaitHandle.getModeType() == 2 & status.equals("2")) {
            String id = taskWaitHandle.getId();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.notIn((Object)"ID", new Object[]{id});
            ((QueryWrapper)queryWrapper.eq((Object)"BIZ_ID", (Object)bizId)).eq((Object)"ITEM_ID", (Object)itemId);
            ((TaskWaitHandleDao)this.baseMapper).delete((Wrapper)queryWrapper);
        }
        taskWaitHandle.setAdvice(siteTaskVo.getAdvice());
        this.update((Model)taskWaitHandle);
        if (status.equals("3")) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"id", (Object)taskWaitHandle.getId());
            wrapper.eq((Object)"ITEM_ID", (Object)taskWaitHandle.getItemId());
            ((TaskWaitHandleDao)this.baseMapper).delete((Wrapper)wrapper);
        }
    }

    @Override
    public void otherSendPeople(SiteTaskVo siteTaskVo) {
        String bizId = siteTaskVo.getSiteId();
        String status = siteTaskVo.getStatus();
        String itemId = siteTaskVo.getItemId();
        String userId = this.baseContext.getCurrentUserId();
        String userAccout = this.baseContext.getCurrentUserAccout();
        String userName = this.baseContext.getCurrentUserName();
        LocalDate time = LocalDate.now();
        String deptId = this.baseContext.getCurrentDeptId();
        String deptName = this.baseContext.getCurrentDeptName();
        IUser iUser = null;
        String account = null;
        String fullname = null;
        if (siteTaskVo.getRummagerId() != null) {
            iUser = this.iUserService.getUserById(siteTaskVo.getRummagerId());
            account = iUser.getAccount();
            fullname = iUser.getFullname();
        }
        QueryWrapper handleQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)handleQueryWrapper.eq((Object)"BIZ_ID", (Object)bizId)).eq((Object)"ITEM_ID", (Object)itemId)).eq((Object)"RECEIVE_USER_ID", (Object)userId);
        TaskWaitHandle taskWaitHandle = (TaskWaitHandle)((Object)this.getOne((Wrapper)handleQueryWrapper));
        TaskAlreadyHandleHistory taskAlreadyHandleHistory = TaskWaitHandle.getTaskAlreadyHandleHistory(taskWaitHandle);
        taskAlreadyHandleHistory.setTransDate(LocalDateTime.now());
        this.taskAlreadyHandleHistoryManager.create((Model)taskAlreadyHandleHistory);
        taskWaitHandle.setSendDeptName(deptName);
        taskWaitHandle.setSendDeptId(deptId);
        taskWaitHandle.setSendLoginName(userAccout);
        taskWaitHandle.setSendUserId(userId);
        taskWaitHandle.setSendUserName(userName);
        taskWaitHandle.setReceiveUserName(fullname);
        taskWaitHandle.setReceiveLoginName(account);
        String rummagerId = siteTaskVo.getRummagerId();
        taskWaitHandle.setReceiveUserId(rummagerId);
        taskWaitHandle.setReceiveDeptId(ContextUtil.getCurrentDeptId((String)rummagerId));
        taskWaitHandle.setReceiveDeptName(ContextUtil.getCurrentDeptName((String)rummagerId));
        String itemTitle = null;
        if (status.equals("6")) {
            itemTitle = userName + "[" + LocalDate.now() + "]\u53e6\u6d3e\u7ed9" + fullname;
            taskWaitHandle.setSendDeptName(deptName);
            taskWaitHandle.setSendDeptId(deptId);
            taskWaitHandle.setSendLoginName(userAccout);
            taskWaitHandle.setSendUserId(userId);
            taskWaitHandle.setSendUserName(userName);
            taskWaitHandle.setItemTitle(itemTitle);
            taskWaitHandle.setReceiveUserName(fullname);
            taskWaitHandle.setReceiveLoginName(account);
            taskWaitHandle.setReceiveUserId(siteTaskVo.getRummagerId());
        }
        taskWaitHandle.setAdvice(siteTaskVo.getAdvice());
        taskWaitHandle.setItemTitle(itemTitle);
        taskWaitHandle.setActivitiesId("1");
        this.update((Model)taskWaitHandle);
    }
}

