/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BridgeInformationDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.BizMaintenanceWorkAreaManager;
import com.artfess.yhxt.basedata.manager.BizRoadsideFacilitiesManager;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.MigrantBuildersInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizRoadsideFacilities;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.vo.BridgeCheckVo;
import com.artfess.yhxt.basedata.vo.BridgeRegularVo;
import com.artfess.yhxt.check.regular.dao.BridgeOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.BridgeRegularCheckDao;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.vo.Org4BridgeVO;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BridgeInformationManagerImpl
extends BaseManagerImpl<BridgeInformationDao, BridgeInformation>
implements BridgeInformationManager {
    @Resource
    private BridgeOftenCheckDao checkDao;
    @Resource
    private BridgeRegularCheckDao bridgeRegularCheckDao;
    @Resource
    BaseContext baseContext;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    OrgManager orgManager;
    @Resource
    WorkbenchDao workbenchDao;
    @Resource
    MigrantBuildersInformationManager migrantBuildersInformationManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;
    @Resource
    private BizRoadsideFacilitiesManager bizRoadsideFacilitiesManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private BizVehicleManager bizVehicleManager;
    @Resource
    private BizMaintenanceWorkAreaManager bizMaintenanceWorkAreaManager;
    @Resource
    private BizCulvertInformationManager bizCulvertInformationManager;

    @Override
    public List<Org4bridgeInfoVO> getBridgeInfoCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4bridgeInfoVO> lists = new ArrayList<Org4bridgeInfoVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BridgeInformationManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4bridgeInfoVO fvo = new Org4bridgeInfoVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BridgeInformationManagerImpl.getChild4Bridge(lists, orgId);
        return this.setCount4Bridge(lists);
    }

    public static List<Org4bridgeInfoVO> getChild4Bridge(List<Org4bridgeInfoVO> allList, String pCode) {
        ArrayList<Org4bridgeInfoVO> returnList = new ArrayList<Org4bridgeInfoVO>();
        for (Org4bridgeInfoVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BridgeInformationManagerImpl.getChild4Bridge(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    public List<Org4bridgeInfoVO> setCount4Bridge(List<Org4bridgeInfoVO> list) {
        Iterator<Org4bridgeInfoVO> it = list.iterator();
        while (it.hasNext()) {
            Org4bridgeInfoVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountBridge(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount4Bridge(orgVO.getChirldren());
        }
        return list;
    }

    public Org4bridgeInfoVO newCountBridge(List<String> ids, Org4bridgeInfoVO orgVO) {
        QueryWrapper bridgeWrapper = new QueryWrapper();
        bridgeWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        bridgeWrapper.eq((Object)"IS_DELE_", (Object)0);
        List bridges = this.list((Wrapper)bridgeWrapper);
        List biggestList = bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(), "1")).collect(Collectors.toList());
        List biggerList = bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(), "2")).collect(Collectors.toList());
        List bigList = bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(), "3")).collect(Collectors.toList());
        List smallList = bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(), "4")).collect(Collectors.toList());
        String biggest = String.format("%.2f", biggestList.stream().mapToDouble(BridgeInformation::getLength).sum()) + "/" + biggestList.size();
        String bigger = String.format("%.2f", biggerList.stream().mapToDouble(BridgeInformation::getLength).sum()) + "/" + biggerList.size();
        String big = String.format("%.2f", bigList.stream().mapToDouble(BridgeInformation::getLength).sum()) + "/" + bigList.size();
        String small = String.format("%.2f", smallList.stream().mapToDouble(BridgeInformation::getLength).sum()) + "/" + smallList.size();
        String all = String.format("%.2f", bridges.stream().mapToDouble(BridgeInformation::getLength).sum()) + "/" + bridges.size();
        orgVO.setBig(big);
        orgVO.setBigger(bigger);
        orgVO.setBiggest(biggest);
        orgVO.setSmall(small);
        orgVO.setAll(all);
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    @Override
    public List<Org4BridgeVO> getBridgeCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4BridgeVO> lists = new ArrayList<Org4BridgeVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BridgeInformationManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4BridgeVO fvo = new Org4BridgeVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BridgeInformationManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4BridgeVO> setCount(List<Org4BridgeVO> list) {
        Iterator<Org4BridgeVO> it = list.iterator();
        while (it.hasNext()) {
            Org4BridgeVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4BridgeVO newCountWorkOrder(List<String> ids, Org4BridgeVO orgVO) {
        orgVO.setRoadCount(ids.size());
        Calendar calendar = Calendar.getInstance();
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        List list = this.bizRoadsideFacilitiesManager.list((Wrapper)orderQueryWrapper);
        QueryWrapper bridgeWrapper = new QueryWrapper();
        bridgeWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        bridgeWrapper.eq((Object)"IS_DELE_", (Object)0);
        List bridges = this.list((Wrapper)bridgeWrapper);
        QueryWrapper tunnelWrapper = new QueryWrapper();
        tunnelWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        tunnelWrapper.eq((Object)"IS_DELE_", (Object)0);
        List tunnels = this.tunnelInformationManager.list((Wrapper)tunnelWrapper);
        QueryWrapper culvertWrapper = new QueryWrapper();
        culvertWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        culvertWrapper.eq((Object)"IS_DELE_", (Object)0);
        List culverts = this.bizCulvertInformationManager.list((Wrapper)culvertWrapper);
        QueryWrapper carWrapper = new QueryWrapper();
        carWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        carWrapper.eq((Object)"IS_DELE_", (Object)0);
        List cars = this.bizVehicleManager.list((Wrapper)carWrapper);
        String companyId = orgVO.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", companyId);
        Map childrenIds = this.orgManager.getChildrenIds(map);
        Set companyIds = (Set)childrenIds.get("id");
        QueryWrapper migrantBuildersInformationQueryWrapper = new QueryWrapper();
        migrantBuildersInformationQueryWrapper.in((Object)"COMPANY_ID_", (Collection)companyIds);
        List humanList = this.migrantBuildersInformationManager.list((Wrapper)migrantBuildersInformationQueryWrapper);
        QueryWrapper workWrapper = new QueryWrapper();
        workWrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        List works = this.bizMaintenanceWorkAreaManager.list((Wrapper)workWrapper);
        if (list.size() > 0) {
            orgVO.setTollGateCount(list.stream().filter(facilities -> Objects.equals(facilities.getType(), "3")).collect(Collectors.toList()).size());
            orgVO.setServiceCount(list.stream().filter(facilities -> Objects.equals(facilities.getType(), "4")).collect(Collectors.toList()).size());
            orgVO.setInterworkingCount(list.stream().filter(facilities -> Objects.equals(facilities.getType(), "1")).collect(Collectors.toList()).size() + list.stream().filter(facilities -> Objects.equals(facilities.getType(), "2")).collect(Collectors.toList()).size());
            orgVO.setBridgeCount(bridges.size());
            orgVO.setCulvertCount(culverts.size());
            orgVO.setTunnelCount(tunnels.size());
            orgVO.setCarCount(cars.size());
            orgVO.setWorkCount(works.size());
            orgVO.setHumanNum(humanList.size());
            if ("4".equals(orgVO.getGrade())) {
                orgVO.setRoadSegmentId(((BizRoadsideFacilities)((Object)list.get(0))).getRoadSegmentId());
            }
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BridgeInformationManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4BridgeVO> getChild(List<Org4BridgeVO> allList, String pCode) {
        ArrayList<Org4BridgeVO> returnList = new ArrayList<Org4BridgeVO>();
        for (Org4BridgeVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BridgeInformationManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    private List<String> getOrgIds(String currentOrgId) {
        List orgList = this.orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }

    @Override
    public PageList<BridgeCheckVo> queryBridge(QueryFilter<BridgeInformation> queryFilter) throws Exception {
        String baseContextCurrentOrgId;
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)(baseContextCurrentOrgId = this.baseContext.getCurrentOrgId()))) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<BridgeCheckVo> result = ((BridgeInformationDao)this.baseMapper).getBridgeInformation((IPage<BridgeInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BridgeInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (BridgeCheckVo record : records) {
            Date checkDate;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            queryWrapper.eq((Object)"BRIGE_ID_", (Object)record.getId());
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List bridgeOftenChecks = this.checkDao.selectList((Wrapper)queryWrapper);
            if (bridgeOftenChecks != null && bridgeOftenChecks.size() > 0) {
                record.setEvaluateValue(((BridgeOftenCheck)((Object)bridgeOftenChecks.get(0))).getEvaluateValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public BridgeInformation getBridgeById(String id) {
        BridgeInformation bridgeInformation = (BridgeInformation)((Object)((BridgeInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        ArrayList<Accessory> accessoriesFrontView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesLateralView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesTwoDimensionalView = new ArrayList<Accessory>();
        if (accessories != null && accessories.size() > 0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("frontView".equalsIgnoreCase(group)) {
                    accessoriesFrontView.add((Accessory)((Object)s));
                }
                if ("lateralView".equalsIgnoreCase(group)) {
                    accessoriesLateralView.add((Accessory)((Object)s));
                }
                if ("twoDimensionalPlan".equalsIgnoreCase(group)) {
                    accessoriesTwoDimensionalView.add((Accessory)((Object)s));
                }
            });
        }
        bridgeInformation.setAccessoriesFrontView(accessoriesFrontView);
        bridgeInformation.setAccessoriesLateralView(accessoriesLateralView);
        bridgeInformation.setAccessoriesTwoDimensionalView(accessoriesTwoDimensionalView);
        return bridgeInformation;
    }

    @Override
    public BridgeInformation getBridgeByCode(String code, Integer direction) {
        List bridgeInformations;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapper.eq((Object)"NUMBER_", (Object)code);
        if (null != direction) {
            queryWrapper.eq((Object)"DIRECTION_", (Object)direction);
        }
        if (null != (bridgeInformations = ((BridgeInformationDao)this.baseMapper).selectList((Wrapper)queryWrapper)) && bridgeInformations.size() > 0) {
            return (BridgeInformation)((Object)bridgeInformations.get(0));
        }
        return null;
    }

    @Override
    public void checkNumber(BridgeInformation bridgeInformation) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)bridgeInformation.getId())) {
            queryWrapper.notIn((Object)"id_", new Object[]{bridgeInformation.getId()});
        }
        queryWrapper.eq((Object)"NUMBER_", (Object)bridgeInformation.getNumber());
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = ((BridgeInformationDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("\u8be5\u6865\u6881\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
    }

    @Override
    public Integer getSn() {
        HashMap<String, String> map = new HashMap<String, String>();
        IUser user = ContextUtil.getCurrentUser();
        if (ObjectUtils.isNotEmpty((Object)user)) {
            map.put("tenant_id_", user.getTenantId());
        }
        return this.getNextSequence(map);
    }

    @Override
    public PageList<BridgeInformation> queryBridgeInformation(QueryFilter<BridgeInformation> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<BridgeInformation> result = ((BridgeInformationDao)this.baseMapper).queryBridgeInformation((IPage<BridgeInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BridgeInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BridgeRegularVo> queryBridgeRegularCheckVo(QueryFilter<BridgeInformation> queryFilter) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<BridgeRegularVo> result = ((BridgeInformationDao)this.baseMapper).queryBridgeRegularCheckVo((IPage<BridgeInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BridgeInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (BridgeRegularVo record : records) {
            Date checkDate;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            queryWrapper.eq((Object)"BRIGE_ID_", (Object)record.getId());
            queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
            List bridgeRegularChecks = this.bridgeRegularCheckDao.selectList((Wrapper)queryWrapper);
            if (bridgeRegularChecks != null && bridgeRegularChecks.size() > 0) {
                record.setOverallRatingValue(((BridgeRegularCheck)((Object)bridgeRegularChecks.get(0))).getOverallRatingValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public void saveBridge(BridgeInformation bizBridgeInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.save((Object)bizBridgeInformation);
        List<Accessory> accessoriesFrontView = bizBridgeInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = bizBridgeInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = bizBridgeInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public void updateBridge(BridgeInformation bizBridgeInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.update((Model)bizBridgeInformation);
        this.accessoryManager.delAccessoryBySourceId(bizBridgeInformation.getId());
        List<Accessory> accessoriesFrontView = bizBridgeInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = bizBridgeInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = bizBridgeInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }
}

