/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.DataPermission;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.params.role.RoleVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.OrgUtil;
import com.artfess.uc.util.UpdateMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/role/v1/"})
@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class RoleController
extends BaseController<RoleManager, Role> {
    @Resource
    RoleManager roleService;
    @Autowired
    UserManager userService;
    @Autowired
    UserRoleManager userRoleService;

    @RequestMapping(value={"roles/getRolePage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @DataPermission
    public PageList<Role> getRolePage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        PageList list = this.roleService.query(filter);
        return list;
    }

    @RequestMapping(value={"roles/getAll"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u89d2\u8272", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u89d2\u8272")
    public List<Role> getAll() throws Exception {
        return this.roleService.getAll();
    }

    @RequestMapping(value={"role/addRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272", httpMethod="POST", notes="\u6dfb\u52a0\u89d2\u8272")
    public CommonResult<String> addRole(@ApiParam(name="role", value="\u89d2\u8272\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody RoleVo role) throws Exception {
        CommonResult<String> rtn = this.roleService.addRole(role);
        return rtn;
    }

    @RequestMapping(value={"role/addRoleFromExterUni"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf", httpMethod="POST", notes="\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf")
    public CommonResult<String> addRoleFromExterUni(@ApiParam(name="role", value="\u89d2\u8272\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody Role role) throws Exception {
        CommonResult<String> rtn = this.roleService.addRoleFromExterUni(role);
        return rtn;
    }

    @RequestMapping(value={"role/deleteRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u5220\u9664\u89d2\u8272", httpMethod="POST", notes="\u6839\u636e\u89d2\u7f16\u7801\u8bc6\u5220\u9664\u89d2\u8272")
    @DataPermission
    public CommonResult<String> deleteRole(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.deleteRole(codes);
    }

    @RequestMapping(value={"role/deleteRoleByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272id\u5220\u9664\u89d2\u8272", httpMethod="DELETE", notes="\u6839\u636e\u89d2\u8272id\u5220\u9664\u89d2\u8272")
    @DataPermission
    public CommonResult<String> deleteRoleByIds(@ApiParam(name="ids", value="\u89d2\u8272id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        return this.roleService.deleteRoleByIds(ids);
    }

    @RequestMapping(value={"role/updateRole"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272", httpMethod="PUT", notes="\u66f4\u65b0\u89d2\u8272")
    @UpdateMethod(type=RoleVo.class)
    @DataPermission
    public CommonResult<String> updateRole(@ApiParam(name="role", value="\u89d2\u8272\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody RoleVo role) throws Exception {
        return this.roleService.updateRole(role);
    }

    @RequestMapping(value={"role/getRole"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u83b7\u53d6\u89d2\u8272\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u89d2\u8272\u4fe1\u606f")
    public CommonResult<Role> getRole(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            return new CommonResult(false, "\u89d2\u8272\u7f16\u7801\u5fc5\u586b\uff01", null);
        }
        Role r = this.roleService.getByAlias(code);
        if (BeanUtils.isEmpty((Object)r)) {
            r = (Role)this.roleService.get((Serializable)((Object)code));
        }
        if (BeanUtils.isEmpty((Object)r)) {
            return new CommonResult(false, "\u6839\u636e\u8f93\u5165\u7684\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272", null);
        }
        return new CommonResult(true, "", (Object)r);
    }

    @RequestMapping(value={"roleUser/saveUserRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09", httpMethod="POST", notes="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09")
    public CommonResult<String> saveUserRole(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String accounts) throws Exception {
        return this.roleService.saveUserRole(code, accounts);
    }

    @RequestMapping(value={"roleUser/saveUserRoles"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09", httpMethod="POST", notes="\u5206\u914d\u7528\u6237\uff08\u6309\u7528\u6237\uff09")
    public CommonResult<String> saveUserRoles(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String codes, @ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account) throws Exception {
        return this.roleService.saveUserRoles(codes, account);
    }

    @RequestMapping(value={"roleUser/addUserRoleByOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237\uff08\u6309\u7ec4\u7ec7\uff09", httpMethod="POST", notes="\u5206\u914d\u7528\u6237\uff08\u6309\u7ec4\u7ec7\uff09")
    public CommonResult<String> addUserRoleByOrg(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String orgCodes) throws Exception {
        return this.roleService.addUserRoleByOrg(code, orgCodes);
    }

    @RequestMapping(value={"roleUser/deleteUserRole"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u79fb\u9664\u7528\u6237", httpMethod="DELETE", notes="\u89d2\u8272\u79fb\u9664\u7528\u6237")
    public CommonResult<String> deleteUserRole(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestParam String accounts) throws Exception {
        return this.roleService.removeUserRole(code, accounts);
    }

    @RequestMapping(value={"role/getRolesByUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u89d2\u8272\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u89d2\u8272\u5217\u8868")
    public List<Role> getRolesByUser(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account) throws Exception {
        return this.roleService.getRolesByUser(account);
    }

    @RequestMapping(value={"role/getUsersByRoleCode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\uff08\u591a\u4e2a\uff09\u4e2d\u7684\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\uff08\u591a\u4e2a\uff09\u4e2d\u7684\u7528\u6237")
    public List<UserVo> getUsersByRoleCode(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.getUsersByRoleCode(codes);
    }

    @RequestMapping(value={"role/deleteRolePhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u89d2\u8272\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u89d2\u8272\u6570\u636e")
    public CommonResult<Integer> deleteRolePhysical() throws Exception {
        Integer num = this.roleService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"role/deleteUserRolePhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e")
    public CommonResult<Integer> deleteUserRolePhysical() throws Exception {
        Integer num = this.userRoleService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"role/forbiddenRoles"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7981\u7528\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="PUT", notes="\u7981\u7528\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> forbiddenRoles(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.forbiddenRoles(codes);
    }

    @RequestMapping(value={"role/activateRoles"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6fc0\u6d3b\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="PUT", notes="\u6fc0\u6d3b\u89d2\u8272\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> activateRoles(@ApiParam(name="codes", value="\u89d2\u8272\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00", required=true) @RequestBody String codes) throws Exception {
        return this.roleService.activateRoles(codes);
    }

    @RequestMapping(value={"roles/getRoleByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<Role> getRoleByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        return this.roleService.getRoleByTime(btime, etime);
    }

    @RequestMapping(value={"role/getRoleUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7528\u6237\uff08\u5206\u9875\uff09", httpMethod="POST", notes="\u83b7\u53d6\u89d2\u8272\u7528\u6237\uff08\u5206\u9875\uff09", hidden=false)
    public PageList<User> getRoleUsers(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter, @ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        filter.addFilter("r.CODE_", (Object)code, QueryOP.EQUAL, FieldRelation.AND, "group_code");
        Page list = (Page)this.userService.getRoleUserQuery(filter);
        return new PageList((IPage)list);
    }

    @RequestMapping(value={"role/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.roleService.isCodeExist(code);
    }

    @RequestMapping(value={"roles/getNotCodeAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u522b\u540d\u83b7\u53d6\u9664\u8fd9\u4e2a\u89d2\u8272\u4e4b\u5916\u7684\u6240\u6709\u89d2\u8272", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u89d2\u8272")
    public List<Role> getNotCodeAll(@ApiParam(name="code", value="\u89d2\u8272\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.roleService.getOrgRoleListNotCode(code);
    }

    @RequestMapping(value={"roles/import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u5bfc\u5165", httpMethod="POST", notes="\u89d2\u8272\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file) throws Exception {
        this.roleService.importData(file);
        return new CommonResult(true, "\u89d2\u8272\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"roles/export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89d2\u8272\u5bfc\u51fa", httpMethod="GET", notes="\u89d2\u8272\u5bfc\u51fa")
    public void export(HttpServletResponse response, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("id", (Object)ids.split(","), QueryOP.IN);
        PageList roles = this.roleService.query(filter);
        ArrayList<Map> list = new ArrayList<Map>();
        if (BeanUtils.isNotEmpty((Object)roles.getRows())) {
            for (Role role : roles.getRows()) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)role)));
            }
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("name", "\u89d2\u8272\u540d\u79f0");
        exportMap.put("code", "\u89d2\u8272\u7f16\u7801");
        exportMap.put("roleType", "\u89d2\u8272\u7c7b\u578b");
        exportMap.put("enabled", "\u72b6\u6001");
        exportMap.put("description", "\u63cf\u8ff0");
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u89d2\u8272\u5217\u8868", (int)22, exportMap, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u89d2\u8272\u5bfc\u51fa", (HttpServletResponse)response);
    }
}

