/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.check.detail.dao.TunnelRegularCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.TunnelRegularCheckDetailManager;
import com.artfess.yhxt.check.detail.model.TunnelRegularCheckDetail;
import com.artfess.yhxt.check.regular.dao.TunnelRegularCheckDao;
import com.artfess.yhxt.check.regular.manager.TunnelRegularCheckManager;
import com.artfess.yhxt.check.regular.model.TunnelRegularCheck;
import com.artfess.yhxt.check.regular.vo.TunnelRegularCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TunnelRegularCheckManagerImpl
extends BaseManagerImpl<TunnelRegularCheckDao, TunnelRegularCheck>
implements TunnelRegularCheckManager {
    @Resource
    private TunnelRegularCheckDetailDao tunnelRegularCheckDetailDao;
    @Resource
    private TunnelRegularCheckDetailManager tunnelRegularCheckDetailManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<TunnelRegularCheck> queryTunnelRegularCheck(QueryFilter<TunnelRegularCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<TunnelRegularCheck> result = ((TunnelRegularCheckDao)this.baseMapper).queryTunnelRegularCheck((IPage<TunnelRegularCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<TunnelRegularCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveTunnelRegularCheck(TunnelRegularCheckVo vo) {
        TunnelRegularCheck tunnelRegularCheck = vo.getTunnelRegularCheck();
        tunnelRegularCheck.setIsDele("0");
        this.saveOrUpdate((Object)tunnelRegularCheck);
        List<TunnelRegularCheckDetail> list = vo.getTunnelRegularCheckDetails();
        if (list.size() > 0) {
            for (TunnelRegularCheckDetail tunnelRegularCheckDetail : list) {
                tunnelRegularCheckDetail.setTunnelRegularCheckId(tunnelRegularCheck.getId());
                tunnelRegularCheckDetail.setId(null);
                this.tunnelRegularCheckDetailManager.create((Model)tunnelRegularCheckDetail);
            }
        }
        List<Accessory> accessoryList = vo.getAccessories();
        String id = tunnelRegularCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateTunnelRegularCheck(TunnelRegularCheckVo vo) {
        TunnelRegularCheck tunnelRegularCheck = vo.getTunnelRegularCheck();
        this.update((Model)tunnelRegularCheck);
        List<TunnelRegularCheckDetail> tunnelRegularCheckDetails = vo.getTunnelRegularCheckDetails();
        if (tunnelRegularCheckDetails.size() > 0) {
            for (TunnelRegularCheckDetail tunnelRegularCheckDetail : tunnelRegularCheckDetails) {
                tunnelRegularCheckDetail.setTunnelRegularCheckId(tunnelRegularCheck.getId());
                this.tunnelRegularCheckDetailManager.saveOrUpdate((Object)tunnelRegularCheckDetail);
            }
        }
        List<Accessory> accessoryList = vo.getAccessories();
        String id = tunnelRegularCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public TunnelRegularCheckVo getTunnelRegularCheckById(String id) {
        TunnelRegularCheckVo tunnelRegularCheckVo = new TunnelRegularCheckVo();
        TunnelRegularCheck tunnelRegularCheck = (TunnelRegularCheck)((Object)this.getById((Serializable)((Object)id)));
        tunnelRegularCheckVo.setTunnelRegularCheck(tunnelRegularCheck);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)tunnelRegularCheck.getId()), (Object)"TUNNEL_REGULAR_CHECK_ID_", (Object)id);
        List tunnelRegularCheckDetails = this.tunnelRegularCheckDetailDao.selectList((Wrapper)queryWrapper);
        tunnelRegularCheckVo.setTunnelRegularCheckDetails(tunnelRegularCheckDetails);
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        tunnelRegularCheckVo.setAccessories(accessories);
        return tunnelRegularCheckVo;
    }

    @Override
    public void importExcelData(MultipartFile file, TunnelRegularCheck parseObject) {
        Assert.notNull((Object)((Object)parseObject), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, TunnelRegularCheckDetail.class, (ImportParams)new ImportParams());
            TunnelRegularCheckVo vo = new TunnelRegularCheckVo();
            vo.setTunnelRegularCheck(parseObject);
            vo.setTunnelRegularCheckDetails(data);
            this.saveTunnelRegularCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteStatistic(TunnelRegularCheck tunnelRegularCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String tunnelId = tunnelRegularCheck.getTunnelId();
        TunnelInformation tunnel = (TunnelInformation)((Object)this.tunnelInformationManager.getById((Serializable)((Object)tunnelId)));
        siteStatistic.setRoadSegmentId(tunnel.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(tunnel.getRoadSegmentName());
        siteStatistic.setCompanyId(tunnelRegularCheck.getCompanyId());
        siteStatistic.setCompanyName(tunnelRegularCheck.getCompanyName());
        siteStatistic.setSiteCode(8);
        siteStatistic.setSiteName("\u96a7\u9053\u5b9a\u671f\u68c0\u67e5");
        LocalDate checkDate = tunnelRegularCheck.getCheckDate();
        String month = checkDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        siteStatistic.setAccDateMonth(month);
        String year = checkDate.format(DateTimeFormatter.ofPattern("yyyy"));
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)tunnel.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)tunnel.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)tunnel.getCompanyId()), (Object)"COMPANY_ID_", (Object)tunnel.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)4);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }
}

