package com.artfess.yhxt.thirdparty.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.thirdparty.vo.TpBridgeCountVo;
import com.artfess.yhxt.thirdparty.vo.TpDeviceCountVo;
import com.artfess.yhxt.thirdparty.vo.TpDeviceTypeCountVo;

import java.util.Map;

/**
 * 第三方传输设备基础信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
public interface BizTpDeviceManager extends BaseManager<BizTpDevice> {



    TpDeviceCountVo getDeviceCount(QueryFilter<BizTpDevice> queryFilter);


    PageList<BizTpDevice> pageVo(QueryFilter<BizTpDevice> queryFilter);

    Map<String, TpDeviceTypeCountVo> getDeviceTypeCount(QueryFilter<BizTpDevice> queryFilter);

    TpDeviceTypeCountVo deviceCountTotal(QueryFilter<BizTpDevice> queryFilter);

}
