package com.artfess.yhxt.statistics.manager;

import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.statistics.vo.*;


import java.util.List;

/**
 * 服务类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-10-26
 */
public interface WorkStatisticManager extends BaseManager<WorkStatistic> {

    /**
     * 养护工单查询
     *
     * @param queryFilter
     * @return
     */
    List<WorkStatistic> getWorkJson(QueryFilter<WorkStatistic> queryFilter);

    //日巡检/夜巡检
    List<SiteStatistic> getSiteJson(QueryFilter<WorkStatistic> queryFilter);

    //经常/定期检查
    List<CheckVo> getCheckJson(QueryFilter<WorkStatistic> queryFilter);

    //养护金额
    List<MoneyVo> getMoneyJson(QueryFilter<WorkStatistic> queryFilter);

    //预算
    List<YearBudgetSum> getYearBudgetJson(QueryFilter<WorkStatistic> queryFilter);

    //病害数量统计
    List<CountDisease> countAmountDisease( QueryFilter queryFilter);

    //病害类型统计
    List<CountTypeDisease> countTypeDisease(QueryFilter queryFilter);

    //病害平均处理天数
    List<CountDayDisease> countDayDisease(QueryFilter queryFilter);

    CountWorkOrder countWorkOrder(QueryFilter<WorkStatistic> queryFilter);

    List<NewCountWorkOrderVo> newCountWorkOrder(QueryFilter<WorkStatistic> queryFilter);
    List<CountWorkOrder> countWorkOrders(QueryFilter<WorkStatistic> queryFilter);
    //经常/定期检查 安装路段
    List<CheckRoadVo>  getCheckRodeJson(QueryFilter<WorkStatistic> queryFilter);

    List<CountSpecialProject> countSpecialProject(QueryFilter<WorkStatistic> queryFilter);

    List<YearBudgetSum> countYearBudgetData(QueryFilter<WorkStatistic> queryFilter);

    //获取查询经常/定期检查信息明细
    List<SiteStatistic> countCheckJsonDetail();

}
