package com.artfess.yhxt.specialcheck.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialcheck.vo.BizMqiCheckDataVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * MQI检查数据表明细表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-13
 */
public interface BizMqiCheckDetailManager extends BaseManager<BizMqiCheckDetail> {

    List<BizMqiCheckDetail> selectListByMqiDataId(String id);

    /**
     * MQI详细信息导入
     * @param mqiId
     * @param file
     * @return
     */
    CommonResult<String> importData(String mqiId, MultipartFile file);

    /**
     * 获取需要导入的mqi详细数据
     * @param file
     * @return
     */
    CommonResult<List<BizMqiCheckDetail>> getimportData(MultipartFile file);

    /**
     * 导出点位信息
     * @param id
     * @return
     */
    void exportMqiDetail(String id, HttpServletResponse response);
}
