package com.artfess.yhxt.open.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.dao.BizCourseDetailsDao;
import com.artfess.yhxt.basedata.manager.BizCourseDetailsManager;
import com.artfess.yhxt.basedata.manager.BizVehicleManager;
import com.artfess.yhxt.basedata.model.BizVehicle;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.open.base.util.JwtCheckUtils;
import com.artfess.yhxt.statistics.manager.WorkStatisticManager;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.statistics.vo.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-26
 */
@RestController
@RequestMapping("/server/")
@Api(tags = "业务数据统计对外接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class WorkStatisticOpenController  {
    @Resource
    WorkStatisticManager workStatisticManager;
    @Resource
    private JwtCheckUtils jwtCheckUtils;
    @Resource
    private WorkOrderInformationManager workOrderInformationManager;
    @Resource
    private BizVehicleManager bizVehicleManager;
    @Resource
    private BizCourseDetailsManager bizCourseDetailsManager;
    @RequestMapping(value = "/countWorkJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询养护工单完成、未完成数量", httpMethod = "POST")
    public CommonResult<List<WorkStatistic>>  countWorkJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter, @RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<WorkStatistic>>(true, "获取养护工单信息成功", this.workStatisticManager.getWorkJson(queryFilter));
        }else {
            return new CommonResult<List<WorkStatistic>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countSiteJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询日/夜巡检信息", httpMethod = "POST")
    public CommonResult<List<SiteStatistic>> countSiteJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter, @RequestParam String token) throws Exception{
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<SiteStatistic>>(true, "获取查询日/夜巡检信息成功", this.workStatisticManager.getSiteJson(queryFilter));
        }else {
            return new CommonResult<List<SiteStatistic>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countCheckJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询经常/定期检查信息", httpMethod = "POST")
    public CommonResult<List<CheckVo>> countCheckJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter, @RequestParam String token) throws Exception{

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CheckVo>>(true, "获取查询经常/定期检查信息成功", this.workStatisticManager.getCheckJson(queryFilter));
        }else {
            return new CommonResult<List<CheckVo>>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "/countCheckJsonDetail", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询经常/定期检查信息明细", httpMethod = "POST")
    public CommonResult<List<SiteStatistic>> countCheckJsonDetail ( @RequestParam String token) throws Exception{

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<SiteStatistic>>(true, "获取查询经常/定期检查信息明细成功", this.workStatisticManager.countCheckJsonDetail());
        }else {
            return new CommonResult<List<SiteStatistic>>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "/countMoneyJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询养护金额总数", httpMethod = "POST")
    public CommonResult<List<MoneyVo>> countMoneyJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter, @RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<MoneyVo>>(true, "获取查询养护金额总数成功", this.workStatisticManager.getMoneyJson(queryFilter));
        }else {
            return new CommonResult<List<MoneyVo>>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "/countYearBudgetJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询预算金额", httpMethod = "POST")
    public CommonResult<List<YearBudgetSum>> countYearBudgetJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter, @RequestParam String token)throws Exception {


        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<YearBudgetSum>>(true, "获取查询预算金额成功", this.workStatisticManager.getYearBudgetJson(queryFilter));
        }else {
            return new CommonResult<List<YearBudgetSum>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countYearBudgetData", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询预算金额明细", httpMethod = "POST")
    public CommonResult<List<YearBudgetSum>> countYearBudgetData(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter,@RequestParam String token)throws Exception {


        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<YearBudgetSum>>(true, "查询预算金额明细", this.workStatisticManager.countYearBudgetData(queryFilter));
        }else {
            return new CommonResult<List<YearBudgetSum>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countAmountDisease", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "病害数量统计", httpMethod = "POST")
    public CommonResult<List<CountDisease>> countAmountDisease(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter,@RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountDisease>>(true, "获取病害数量统计成功", this.workStatisticManager.countAmountDisease(queryFilter));
        }else {
            return new CommonResult<List<CountDisease>>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "/countTypeDisease", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "病害类型统计", httpMethod = "POST")
    public  CommonResult<List<CountTypeDisease>> countTypeDisease(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter,@RequestParam String token)throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountTypeDisease>>(true, "获取病害类型统计成功", this.workStatisticManager.countTypeDisease( queryFilter));
        }else {
            return new CommonResult<List<CountTypeDisease>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countDayDisease", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "病害平均处理天数", httpMethod = "POST")
    public CommonResult<List<CountDayDisease>> countDayDisease(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter,@RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountDayDisease>>(true, "获取病害平均处理天数成功", this.workStatisticManager.countDayDisease(queryFilter));
        }else {
            return new CommonResult<List<CountDayDisease>>(false, "Token失效，请重新获取", null);
        }

    }
    @RequestMapping(value = "/countWorkOrder", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "养护工单执行状况", httpMethod = "POST")
    public CommonResult<List<CountWorkOrder>> countWorkOrder(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter,@RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountWorkOrder>>(true, "获取养护工单执行状况成功", this.workStatisticManager.countWorkOrders( queryFilter));
        }else {
            return new CommonResult<List<CountWorkOrder>>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "/countSpecialProject", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "专项个数", httpMethod = "POST")
    public CommonResult<List<CountSpecialProject>> countSpecialProject(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter,@RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountSpecialProject>>(true, "专项个数", this.workStatisticManager.countSpecialProject( queryFilter));
        }else {
            return new CommonResult<List<CountSpecialProject>>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "/getJsonWorkOrder", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "获取工单详情", httpMethod = "POST")
    public CommonResult<List<WorkOrderInformation>> getJsonWorkOrder( @RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            QueryWrapper<WorkOrderInformation> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("IS_DELE_",0);
            List<WorkOrderInformation> list = this.workOrderInformationManager.list(queryWrapper);
            list.forEach(s->{
                if (bizCourseDetailsManager.getByName(s.getCategoryId())!=null){
                    s.setCategoryName(bizCourseDetailsManager.getByName(s.getCategoryId()));
                }
                if (bizCourseDetailsManager.getByName(s.getDetailsId())!=null){
                s.setDetailsName(bizCourseDetailsManager.getByName(s.getDetailsId()));
                }
            });
            return new CommonResult<List<WorkOrderInformation>>(true, "获取养护工单详情成功",  list);
        }else {
            return new CommonResult<List<WorkOrderInformation>>(false, "Token失效，请重新获取", null);
        }
    }
    @RequestMapping(value = "/getJsonVehicle", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "获取养护车辆详情", httpMethod = "POST")
    public CommonResult<List<BizVehicle>> getJsonVehicle( @RequestParam String token)throws Exception {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            QueryWrapper<BizVehicle> bizVehicleQueryWrapper = new QueryWrapper<>();
            bizVehicleQueryWrapper.eq("IS_DELE_",0);
            List<BizVehicle> list = bizVehicleManager.list(bizVehicleQueryWrapper);
            return new CommonResult<List<BizVehicle>>(true, "获取养护车辆详情成功",  list);
        }else {
            return new CommonResult<List<BizVehicle>>(false, "Token失效，请重新获取", null);
        }
    }

}
