package com.artfess.yhxt.contract.vo;

import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.disease.model.Disease;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhx
 * @create 2021/11/8
 */
@Data
@ApiModel(value = "WorkOrderDisease vo对象", description = "工单信息")
public class WorkOrderDiseaseVo {

    @ApiModelProperty(value = "工单信息实体")
    private WorkOrderInformation workOrderInformation;

    @ApiModelProperty(value = "养护合同")
    private Contract contract;

    @ApiModelProperty(value = "病害信息")
    private List<Disease> diseaseList;

    @ApiModelProperty(value = "合同内工程量清单")
    private List<BillOfQuantities> billOfQuantities;

    @ApiModelProperty(value = "合同外工程量清单")
    private List<BillOfQuantities> billOutOfQuantities;

}
