package com.artfess.yhxt.contract.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.contract.model.ContractItem;
import com.artfess.yhxt.contract.dao.ContractItemDao;
import com.artfess.yhxt.contract.manager.ContractItemManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 合同明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-06
 */
@Service
public class ContractItemManagerImpl extends BaseManagerImpl<ContractItemDao, ContractItem> implements ContractItemManager {

    @Override
    public PageList<ContractItem> queryContractItem(QueryFilter<ContractItem> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<ContractItem> result = baseMapper.queryContractItem(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));

        return new PageList<>(result);
    }
}
