package com.artfess.yhxt.basedata.dao;

import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.vo.CulvertCheckVo;
import com.artfess.yhxt.basedata.vo.CulvertRegularVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.Map;

/**
 * 涵洞信息表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-28
 */
public interface BizCulvertInformationDao extends BaseMapper<BizCulvertInformation> {
    IPage<BizCulvertInformation> getBizCulvertInformation(IPage<BizCulvertInformation> convert2IPage,
                                                          @Param("map") Map<String, Object> params,
                                                          @Param(Constants.WRAPPER) Wrapper<BizCulvertInformation> convert2Wrapper);

    /**
     *
     * @param convert2IPage
     * @param params
     * @param convert2Wrapper
     * @return
     */
    IPage<CulvertCheckVo> queryBizCulvert(IPage<BizCulvertInformation> convert2IPage,
                                          @Param("map") Map<String, Object> params,
                                          @Param(Constants.WRAPPER) Wrapper<BizCulvertInformation> convert2Wrapper);

    IPage<CulvertRegularVo> queryCulvertRegularCheckVo(IPage<BizCulvertInformation> convert2IPage,
                                                       @Param("map") Map<String, Object> params,
                                                       @Param(Constants.WRAPPER) Wrapper<BizCulvertInformation>  convert2Wrapper);
}
