package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 施工日志表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@ApiModel(value="BizConstructionLog对象", description="施工日志表")
@TableName("biz_construction_log")
@Data
public class BizConstructionLog extends BizModel<BizConstructionLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程表name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目开工表id")
    @TableField("STARTUP_ID_")
    private String startupId;

    @ApiModelProperty(value = "天气描述")
    @TableField("WEATHER_DESCRIPTION_")
    private String weatherDescription;

    @ApiModelProperty(value = "本次完成量")
    @TableField("COMPLETE_QUANTITY_")
    private String completeQuantity;

    @ApiModelProperty(value = "方向描述")
    @TableField("DIRECTION_DESCRIPTION_")
    private String directionDescription;

    @ApiModelProperty(value = "交通影响")
    @TableField("TRAFFIC_IMPACT_DESCRIPTION_")
    private String trafficImpactDescription;

    @ApiModelProperty(value = "作业情况")
    @TableField("WORK_DESCRIPTION_")
    private String workDescription;

    @ApiModelProperty(value = "日常小修完成")
    @TableField("NORMAL_COMPLETE_DESCRIPTION_")
    private String normalCompleteDescription;

    @ApiModelProperty(value = "管理情况")
    @TableField("MANAGE_DESCRIPTION_")
    private String manageDescription;

    @ApiModelProperty(value = "注意事项")
    @TableField("ATTENTION_MATTER_")
    private String attentionMatter;

    @ApiModelProperty(value = "管制开始时间")
    @TableField("CONTROL_START_DATE_")
    private LocalDate controlStartDate;

    @ApiModelProperty(value = "管制结束时间")
    @TableField("CONTROL_END_DATE_")
    private LocalDate controlEndDate;

    @ApiModelProperty(value = "填报时间")
    @TableField("REPORT_TIME_")
    private LocalDate reportTime;

    @ApiModelProperty(value = "填报人id")
    @TableField("REPORT_USER_ID_")
    private String reportUserId;

    @ApiModelProperty(value = "填报人name")
    @TableField("REPORT_USER_NAME_")
    private String reportUserName;

    @ApiModelProperty(value = "填报单位")
    @TableField("REPORT_DEPART_")
    private String reportDepart;
    @ApiModelProperty(value = "填报单位ID")
    @TableField("REPORT_DEPART_ID_")
    private String reportDepartId;
    @ApiModelProperty(value = "填报单位IDs")
    @TableField("REPORT_DEPART_IDS_")
    private String reportDepartIds;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getStartupId() {
        return startupId;
    }

    public void setStartupId(String startupId) {
        this.startupId = startupId;
    }

    public String getWeatherDescription() {
        return weatherDescription;
    }

    public void setWeatherDescription(String weatherDescription) {
        this.weatherDescription = weatherDescription;
    }

    public String getCompleteQuantity() {
        return completeQuantity;
    }

    public void setCompleteQuantity(String completeQuantity) {
        this.completeQuantity = completeQuantity;
    }

    public String getDirectionDescription() {
        return directionDescription;
    }

    public void setDirectionDescription(String directionDescription) {
        this.directionDescription = directionDescription;
    }

    public String getTrafficImpactDescription() {
        return trafficImpactDescription;
    }

    public void setTrafficImpactDescription(String trafficImpactDescription) {
        this.trafficImpactDescription = trafficImpactDescription;
    }

    public String getWorkDescription() {
        return workDescription;
    }

    public void setWorkDescription(String workDescription) {
        this.workDescription = workDescription;
    }

    public String getNormalCompleteDescription() {
        return normalCompleteDescription;
    }

    public void setNormalCompleteDescription(String normalCompleteDescription) {
        this.normalCompleteDescription = normalCompleteDescription;
    }

    public String getManageDescription() {
        return manageDescription;
    }

    public void setManageDescription(String manageDescription) {
        this.manageDescription = manageDescription;
    }

    public String getAttentionMatter() {
        return attentionMatter;
    }

    public void setAttentionMatter(String attentionMatter) {
        this.attentionMatter = attentionMatter;
    }

    public LocalDate getControlStartDate() {
        return controlStartDate;
    }

    public void setControlStartDate(LocalDate controlStartDate) {
        this.controlStartDate = controlStartDate;
    }

    public LocalDate getControlEndDate() {
        return controlEndDate;
    }

    public void setControlEndDate(LocalDate controlEndDate) {
        this.controlEndDate = controlEndDate;
    }

    public LocalDate getReportTime() {
        return reportTime;
    }

    public void setReportTime(LocalDate reportTime) {
        this.reportTime = reportTime;
    }

    public String getReportUserId() {
        return reportUserId;
    }

    public void setReportUserId(String reportUserId) {
        this.reportUserId = reportUserId;
    }

    public String getReportUserName() {
        return reportUserName;
    }

    public void setReportUserName(String reportUserName) {
        this.reportUserName = reportUserName;
    }

    public String getReportDepart() {
        return reportDepart;
    }

    public void setReportDepart(String reportDepart) {
        this.reportDepart = reportDepart;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getReportDepartId() {
        return reportDepartId;
    }

    public void setReportDepartId(String reportDepartId) {
        this.reportDepartId = reportDepartId;
    }

    public String getReportDepartIds() {
        return reportDepartIds;
    }

    public void setReportDepartIds(String reportDepartIds) {
        this.reportDepartIds = reportDepartIds;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizConstructionLog{" +
            "id=" + id +
            ", remarks=" + remarks +
            ", projectId=" + projectId +
            ", startupId=" + startupId +
            ", weatherDescription=" + weatherDescription +
            ", completeQuantity=" + completeQuantity +
            ", directionDescription=" + directionDescription +
            ", trafficImpactDescription=" + trafficImpactDescription +
            ", workDescription=" + workDescription +
            ", normalCompleteDescription=" + normalCompleteDescription +
            ", manageDescription=" + manageDescription +
            ", attentionMatter=" + attentionMatter +
            ", controlStartDate=" + controlStartDate +
            ", controlEndDate=" + controlEndDate +
            ", reportTime=" + reportTime +
            ", reportUserId=" + reportUserId +
            ", reportDepart=" + reportDepart +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
