package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizInspectionRecordsOfSupervision;
import com.artfess.yhxt.specialproject.vo.BizInspectionRecordsOfSupervisionVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizInspectionRecordsOfSupervision;
import com.artfess.yhxt.specialproject.manager.BizInspectionRecordsOfSupervisionManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 监理巡查记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@RestController
@RequestMapping("/bizInspectionRecordsOfSupervision/v1/")
@Api(tags = "监理巡查记录管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizInspectionRecordsOfSupervisionController extends BaseController<BizInspectionRecordsOfSupervisionManager, BizInspectionRecordsOfSupervision> {

    @Resource
    private BizInspectionRecordsOfSupervisionManager bizInspectionRecordsOfSupervisionManager;

    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "/saveInspectionRecordsOfSupervision",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改监理巡查记录信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizInspectionRecordsOfSupervision",value = "项目开工申请专项检查对象") @RequestBody BizInspectionRecordsOfSupervision bizInspectionRecordsOfSupervision) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizInspectionRecordsOfSupervision.getId())){
            bizInspectionRecordsOfSupervision.setIsDele("0");
            baseService.create(bizInspectionRecordsOfSupervision);
        }else {
            baseService.update(bizInspectionRecordsOfSupervision);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改监理巡查记录、附件信息",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizInspectionRecordsOfSupervisionVo",value = "项目开工申请专项检查对象") @RequestBody BizInspectionRecordsOfSupervisionVo bizInspectionRecordsOfSupervisionVo) throws Exception {
        String msg = "添加成功";
        BizInspectionRecordsOfSupervision bizInspectionRecordsOfSupervision = bizInspectionRecordsOfSupervisionVo.getBizInspectionRecordsOfSupervision();
        if (StringUtils.isEmpty(bizInspectionRecordsOfSupervision.getId())){
            bizInspectionRecordsOfSupervision.setIsDele("0");
            baseService.saveVo(bizInspectionRecordsOfSupervisionVo);
        }else {
            baseService.updateVo(bizInspectionRecordsOfSupervisionVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询监理巡查记录、附件信息",httpMethod = "GET",notes = "根据ID查询监理巡查记录、附件信息")
    public BizInspectionRecordsOfSupervisionVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }


    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询监理巡查记录信息",httpMethod ="POST")
    public PageList<BizInspectionRecordsOfSupervision> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizInspectionRecordsOfSupervision> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);

        }

        PageList<BizInspectionRecordsOfSupervision> pageList = baseService.queryBizInspectionRecordsOfSupervision(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "getQuery",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询监理巡查记录信息",httpMethod ="POST")
    public PageList<BizInspectionRecordsOfSupervision> getQuery(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizInspectionRecordsOfSupervision> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);

        }

        PageList<BizInspectionRecordsOfSupervision> pageList = baseService.query(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询监理巡查记录信息",httpMethod = "GET",notes = "根据ID查询监理巡查记录信息")
    public BizInspectionRecordsOfSupervision get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizInspectionRecordsOfSupervisionById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除监理巡查记录信息",httpMethod = "DELETE",notes = "批量删除监理巡查记录信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateInspectionRecordsOfSupervision",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除监理巡查记录信息",httpMethod = "DELETE",notes = "逻辑删除监理巡查记录信息")
    public CommonResult<String> updateInspectionRecordsOfSupervision(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizInspectionRecordsOfSupervision> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
    @RequestMapping(value = "updateFlag",method = RequestMethod.POST,produces = {"application/json; chartset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态",httpMethod = "POST",notes = "批量修改启用禁用状态")
    public CommonResult<String> updateFlag(@ApiParam(name = "ids",value = "Id集合，以,隔开")@RequestParam String ids,
                                           @ApiParam(name = "validFlag",value = "有效标志（0：无效 1：有效）")@RequestParam Integer flag) throws Exception{
    bizInspectionRecordsOfSupervisionManager.updateFlag(ids,flag);
    return new CommonResult<>(true,"状态修改成功");
    }
}
