package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.check.detail.dao.SideSlopeOftenCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.SideSlopeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.SideSlopeOftenCheckDetail;
import com.artfess.yhxt.check.regular.dao.SideSlopeOftenCheckDao;
import com.artfess.yhxt.check.regular.manager.SideSlopeOftenCheckManager;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.vo.SideSlopeOftenCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 边坡经常检查表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-05
 */
@Service
public class SideSlopeOftenCheckManagerImpl extends BaseManagerImpl<SideSlopeOftenCheckDao, SideSlopeOftenCheck> implements SideSlopeOftenCheckManager {

    @Resource
    private SideSlopeOftenCheckDetailManager sideSlopeOftenCheckDetailManager;

    @Resource
    private SideSlopeOftenCheckDetailDao sideSlopeOftenCheckDetailDao;
    @Resource
    private SideSlopeInformationManager slopeInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<SideSlopeOftenCheck> querySideSlopeOftenCheck(QueryFilter<SideSlopeOftenCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }

        List<FieldSort> sorter = queryFilter.getSorter();
        if(null == sorter || sorter.isEmpty()){
            sorter.add(new FieldSort("CHECK_DATE_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        IPage<SideSlopeOftenCheck> result = baseMapper.querySideSlopeOftenCheck(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void saveSideSlopeOftenCheck(SideSlopeOftenCheckVo vo) {
        SideSlopeOftenCheck sideSlopeOftenCheck = vo.getSideSlopeOftenCheck();
        sideSlopeOftenCheck.setIsDele("0");
        this.saveOrUpdate(sideSlopeOftenCheck);
        vo.getSideSlopeOftenCheckDetailList().forEach(s -> {
            s.setId(null);
            s.setSideSlopeOftenCheckId(sideSlopeOftenCheck.getId());
            this.sideSlopeOftenCheckDetailManager.saveOrUpdate(s);
        });
        //保存附件信息
        List<Accessory> accessoryList = vo.getAccessories();
        //资源ID
        String id = sideSlopeOftenCheck.getId();
        if (null !=accessoryList && accessoryList.size() > 0) {
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }

    }

    @Override
    public void updateSideSlopeOftenCheck(SideSlopeOftenCheckVo vo) {
        SideSlopeOftenCheck sideSlopeOftenCheck = vo.getSideSlopeOftenCheck();
        this.update(sideSlopeOftenCheck);
        vo.getSideSlopeOftenCheckDetailList().forEach(s -> {
            s.setSideSlopeOftenCheckId(sideSlopeOftenCheck.getId());
            this.sideSlopeOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        //资源ID
        String id = sideSlopeOftenCheck.getId();
        if (null !=accessoryList && accessoryList.size() > 0) {
            //删除原来的附件信息
            this.accessoryManager.delAccessoryBySourceId(id);
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public SideSlopeOftenCheckVo getSideSlopeOftenCheck(String id) {
        SideSlopeOftenCheckVo checkVo = new SideSlopeOftenCheckVo();
        SideSlopeOftenCheck sideSlopeOftenCheck = this.getById(id);
        if (sideSlopeOftenCheck!=null) {
            checkVo.setSideSlopeOftenCheck(sideSlopeOftenCheck);
            QueryWrapper<SideSlopeOftenCheckDetail> queryWrapper = new QueryWrapper<>();
            if (StringUtils.isNotBlank(sideSlopeOftenCheck.getId())) {
                queryWrapper.eq("SIDE_SLOPE_OFTEN_CHECK_ID_", sideSlopeOftenCheck.getId());
                List<SideSlopeOftenCheckDetail> sideSlopeOftenCheckDetailList = this.sideSlopeOftenCheckDetailDao.selectList(queryWrapper);
                checkVo.setSideSlopeOftenCheckDetailList(sideSlopeOftenCheckDetailList);
            }
            List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
            checkVo.setAccessories(accessories);
        }
        return checkVo;
    }
    private void saveSiteStatistic(SideSlopeOftenCheck sideSlopeOftenCheck){
        SiteStatistic siteStatistic = new SiteStatistic();
        String checkId = sideSlopeOftenCheck.getSideSlopeId();
        SideSlopeInformation sideSlopeInformation = slopeInformationManager.getById(checkId);
        siteStatistic.setRoadSegmentId(sideSlopeInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(sideSlopeInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(sideSlopeInformation.getCompanyId());
        siteStatistic.setCompanyName(sideSlopeInformation.getCompanyName());
        siteStatistic.setSiteCode(6);
        siteStatistic.setSiteName("边坡经常检查");
        Date checkDate = sideSlopeOftenCheck.getCheckDate();
        String month = new SimpleDateFormat("yyyy-MM").format(checkDate);
        siteStatistic.setAccDateMonth(month);
        String year = new SimpleDateFormat("yyyy").format(checkDate);
        siteStatistic.setAccDateYear(year);


        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper<SiteStatistic> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotEmpty(month), "ACC_DATE_MONTH_", month);
        queryWrapper.eq(StringUtils.isNotEmpty(year), "ACC_DATE_YEAR_", year);
        queryWrapper.eq(StringUtils.isNotEmpty(sideSlopeInformation.getRoadSegmentId()), "ROAD_SEGMENT_ID_", sideSlopeInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty(sideSlopeInformation.getCompanyId()), "COMPANY_ID_", sideSlopeInformation.getCompanyId());
        queryWrapper.eq("SITE_CODE_", 6);
        queryWrapper.eq("SITE_NAME_", "边坡经常检查");
        List<SiteStatistic> siteStatistics = siteStatisticDao.selectList(queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = siteStatistics.get(0);
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update(siteStatistic, queryWrapper);
        } else {
            siteStatisticDao.insert(siteStatistic);
        }
    }

    @Override
    public void importExcelData(MultipartFile file, SideSlopeOftenCheck parseObject) {

        Assert.notNull(parseObject, "主数据不能为空");

        try (InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<SideSlopeOftenCheckDetail> data = ExcelImportUtil.importExcel(inputStream, SideSlopeOftenCheckDetail.class, new ImportParams());
            SideSlopeOftenCheckVo vo = new SideSlopeOftenCheckVo();
            vo.setSideSlopeOftenCheck(parseObject);
            vo.setSideSlopeOftenCheckDetailList(data);
            saveSideSlopeOftenCheck(vo);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
