package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;

/**
 * 路线实体对象
 *
 * @company 阿特菲斯
 * @author wangping
 * @email
 * @date 2021-07-15 17:49:50
 */
@ApiModel(description="路线实体对象")
@TableName("biz_route")
@JsonInclude
public class Route extends BizModel<Route> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name="id", notes="主键")
    @TableId("id_")
    private String id;

    @ApiModelProperty(value = "编号")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "起点地址")
    @TableField("START_")
    private String start;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private String startPeg;

    @ApiModelProperty(value = "终点地址")
    @TableField("END_")
    private String end;

    @ApiModelProperty(value = "终点桩号")
    @TableField("END_PEG_")
    private String endPeg;

    @ApiModelProperty(value = "所属公司ID")
    @TableField("COMPANY_ID")
    private String companyId;
    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;



    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME")
    private String companyName;

    @ApiModelProperty(value = "技术等级")
    @TableField("TECHNICAL_GRADE_NAME")
    private String technicalGradeName;

    @ApiModelProperty(value = "技术等级编码")
    @TableField("TECHNICAL_GRADE_CODE")
    private String technicalGradeCode;

    @ApiModelProperty(value = "车道数量")
    @TableField("NUMBER_LANES_")
    private Integer numberLanes;

    @ApiModelProperty(value = "里程（千米）")
    @TableField("MILEAGE_")
    private Double mileage;

    @ApiModelProperty(value = "面层类型")
    @TableField("SURFACE_TYPE_NAME")
    private String surfaceTypeName;

    @ApiModelProperty(value = "面层类型代码")
    @TableField("SURFACE_TYPE_CODE")
    private String surfaceTypeCode;

    @ApiModelProperty(value = "路基宽度(米)")
    @TableField("SUBGRADE_WIDTH_")
    private Double subgradeWidth;

    @ApiModelProperty(value = "路面宽度(米)")
    @TableField("PAVEMENT_WIDTH_")
    private Double pavementWidth;

    @ApiModelProperty(value = "面层厚度(厘米)")
    @TableField("SURFACE_THICKNESS_")
    private Double surfaceThickness;

    @ApiModelProperty(value = "设计时速(千米/小时)")
    @TableField("DESIGN_SPEED_")
    private Double designSpeed;

    @ApiModelProperty(value = "省际出入口")
    @TableField("INTER_PROVINCIAL_PORT_")
    private String interProvincialPort;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getCompanyIds() {
        return companyIds;
    }

    public void setCompanyIds(String companyIds) {
        this.companyIds = companyIds;
    }
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getStartPeg() {
        return startPeg;
    }

    public void setStartPeg(String startPeg) {
        this.startPeg = startPeg;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getEndPeg() {
        return endPeg;
    }

    public void setEndPeg(String endPeg) {
        this.endPeg = endPeg;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getTechnicalGradeName() {
        return technicalGradeName;
    }

    public void setTechnicalGradeName(String technicalGradeName) {
        this.technicalGradeName = technicalGradeName;
    }

    public String getTechnicalGradeCode() {
        return technicalGradeCode;
    }

    public void setTechnicalGradeCode(String technicalGradeCode) {
        this.technicalGradeCode = technicalGradeCode;
    }

    public Integer getNumberLanes() {
        return numberLanes;
    }

    public void setNumberLanes(Integer numberLanes) {
        this.numberLanes = numberLanes;
    }

    public String getSurfaceTypeName() {
        return surfaceTypeName;
    }

    public void setSurfaceTypeName(String surfaceTypeName) {
        this.surfaceTypeName = surfaceTypeName;
    }

    public String getSurfaceTypeCode() {
        return surfaceTypeCode;
    }

    public void setSurfaceTypeCode(String surfaceTypeCode) {
        this.surfaceTypeCode = surfaceTypeCode;
    }

    public Double getSubgradeWidth() {
        return subgradeWidth;
    }

    public void setSubgradeWidth(Double subgradeWidth) {
        this.subgradeWidth = subgradeWidth;
    }

    public Double getPavementWidth() {
        return pavementWidth;
    }

    public void setPavementWidth(Double pavementWidth) {
        this.pavementWidth = pavementWidth;
    }

    public Double getSurfaceThickness() {
        return surfaceThickness;
    }

    public void setSurfaceThickness(Double surfaceThickness) {
        this.surfaceThickness = surfaceThickness;
    }

    public Double getDesignSpeed() {
        return designSpeed;
    }

    public void setDesignSpeed(Double designSpeed) {
        this.designSpeed = designSpeed;
    }

    public String getInterProvincialPort() {
        return interProvincialPort;
    }

    public void setInterProvincialPort(String interProvincialPort) {
        this.interProvincialPort = interProvincialPort;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Double getMileage() {
        return mileage;
    }

    public void setMileage(Double mileage) {
        this.mileage = mileage;
    }


    @Override
    public String toString() {
        return "Route{" +
                "id='" + id + '\'' +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", start='" + start + '\'' +
                ", startPeg='" + startPeg + '\'' +
                ", end='" + end + '\'' +
                ", endPeg='" + endPeg + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyIds='" + companyIds + '\'' +
                ", companyName='" + companyName + '\'' +
                ", technicalGradeName='" + technicalGradeName + '\'' +
                ", technicalGradeCode='" + technicalGradeCode + '\'' +
                ", numberLanes=" + numberLanes +
                ", mileage=" + mileage +
                ", surfaceTypeName='" + surfaceTypeName + '\'' +
                ", surfaceTypeCode='" + surfaceTypeCode + '\'' +
                ", subgradeWidth=" + subgradeWidth +
                ", pavementWidth=" + pavementWidth +
                ", surfaceThickness=" + surfaceThickness +
                ", designSpeed=" + designSpeed +
                ", interProvincialPort='" + interProvincialPort + '\'' +
                ", sn=" + sn +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
