package com.artfess.yhxt.basedata.model;

import java.math.BigDecimal;
import java.util.List;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 桥梁信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-29
 */
@ApiModel(value="BizBridgeInformation对象", description="桥梁信息表")
@TableName("BIZ_BRIDGE_INFORMATION")
@Data
@JsonInclude
public class BridgeInformation extends BizModel<BridgeInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "编号")
    @TableField("NUMBER_")
    private String number;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "类型 1:特大桥 2:大桥 3:中桥 4:小桥")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "养护等级 1:一级 2:二级 3:三级")
    @TableField("GRADE_")
    private String grade;

    @ApiModelProperty(value = "分类 1:主线桥 2:大桥 3:上跨车行天桥 4:上跨人行天桥 5:渡槽 6:匝道桥 7:立交桥")
    @TableField("CATEGORY_")
    private String category;

    @ApiModelProperty(value = "中心桩号")
    @TableField("CENT_PEG_")
    private Float centPeg;

    @ApiModelProperty(value = "方向 1:上行方向 2:下行方向 3:上下双向 4:匝道")
    @TableField("DIRECTION_")
    private String direction;

    @ApiModelProperty(value = "下穿通道名")
    @TableField("UNDERCHANNELS_NAME_")
    private String underchannelsName;

    @ApiModelProperty(value = "下穿通道桩号")
    @TableField("UNDERCHANNELS_PEG_")
    private String underchannelsPeg;

    @ApiModelProperty(value = "设计荷载")
    @TableField("DESIGNLOAD_")
    private String designload;

    @ApiModelProperty(value = "通过荷载")
    @TableField("PASSESLOAD_")
    private String passesload;

    @ApiModelProperty(value = "倾斜斜坡")
    @TableField("INCLINEDSLOPE_")
    private String inclinedslope;

    @ApiModelProperty(value = "表面安装 1:沥青混凝土 2:防水混泥土")
    @TableField("SURFACEINSTALL_")
    private String surfaceinstall;

    @ApiModelProperty(value = "管养单位_ID")
    @TableField("OFFICE_ID_")
    private String officeId;

    @ApiModelProperty(value = "管养单位名称")
    @TableField("OFFICE_NAME_")
    private String officeName;

    @ApiModelProperty(value = "建设完成日期")
    @TableField("FINISH_DAY_")
    private String finishDay;

    @ApiModelProperty(value = "主桥主跨")
    @TableField("MAIN_SPAN_")
    private String mainSpan;

    @ApiModelProperty(value = "主桥边跨")
    @TableField("SIDE_SPAN_")
    private String sideSpan;

    @ApiModelProperty(value = "垂直坡度")
    @TableField("VERTICAL_SLOPE_")
    private String verticalSlope;

    @ApiModelProperty(value = "跨越地物类别")
    @TableField("SPAN_OBJECT_TYPE_")
    private String spanObjectType;

    @ApiModelProperty(value = "跨越地物名称")
    @TableField("SPAN_OBJECT_NAME_")
    private String spanObjectName;

    @ApiModelProperty(value = "设计单位")
    @TableField("DESIGN_UNIT_")
    private String designUnit;

    @ApiModelProperty(value = "监视单位")
    @TableField("WATCH_UNIT_")
    private String watchUnit;

    @ApiModelProperty(value = "施工单位")
    @TableField("CONSTRUCT_UNIT_")
    private String constructUnit;

    @ApiModelProperty(value = "前引线长度")
    @TableField("FRONT_LEAD_LENGTH_")
    private Float frontLeadLength;

    @ApiModelProperty(value = "后引线长度")
    @TableField("AFTER_LEAD_LENGTH_")
    private Float afterLeadLength;

    @ApiModelProperty(value = "上部结构类型1：T型梁 2:箱型梁 3:空心板梁 4:悬索桥 5:连续钢构 6:拱桥 7:组合式梁 8:简支梁" +
            "9:连续梁 10:T型梁+连续钢构 11:双索面钢混组合斜拉桥 12:钢箱梁 13:斜拉桥 14:石拱桥 15:T型组合式梁 16:I型梁" +
            "17:斜腿钢构 18:变截面钢筋砼连续梁 19:双圆弧钢筋砼拱 20:钢筋混凝土连续箱梁 21:钢筋混凝土单弧拱 22:预应力砼宽幅式箱型梁" +
            "23:异行板梁 24:分岔坦拱 25:单塔斜拉桥 26:人字形刚架桥 27:变截面简支曲梁 28:钢箱挂梁 29:双向等截面混凝土箱梁" +
            "30:系杆肋拱 31:肋拱 32:拉杆系拱 33:悬臂梁 34:先简支后连续预应力T梁 35:板梁 36:挂篮悬浇 37:连续T梁 38:预应力混凝土空心板梁" +
            "39:预应力混凝土简支T型梁 40:预应力混凝土简支空心板梁 40:T型梁+钢混叠合梁 42:先简支后结构连续空心板 43:预应力T梁" +
            "44:预应力箱梁 45:预制T梁/现浇箱梁 46:简支梁T 47:其他")
    @TableField("SHAPE_TYPE_")
    private String shapeType;

    @ApiModelProperty(value = "单孔最大梁片数")
    @TableField("SPAN_COUNT_")
    private Float spanCount;

    @ApiModelProperty(value = "索数")
    @TableField("CORD_COUNT_")
    private Float cordCount;

    @ApiModelProperty(value = "填卡人")
    @TableField("CARD_PER_")
    private String cardPer;

    @ApiModelProperty(value = "填卡日期")
    @TableField("CARD_DAY_")
    private String cardDay;

    @ApiModelProperty(value = "x_")
    @TableField("X_")
    private String x;

    @ApiModelProperty(value = "y_")
    @TableField("Y_")
    private String y;

    @ApiModelProperty(value = "设计图纸")
    @TableField("DESIGN_DRAWING_")
    private String designDrawing;

    @ApiModelProperty(value = "设计文件")
    @TableField("DESIGN_FILE_")
    private String designFile;

    @ApiModelProperty(value = "施工文件")
    @TableField("CONSTRUCTION_FILE_")
    private String constructionFile;

    @ApiModelProperty(value = "完成文件")
    @TableField("COMPLETE_FILE_")
    private String completeFile;

    @ApiModelProperty(value = "检查文件")
    @TableField("CHECK_FILE_")
    private String checkFile;

    @ApiModelProperty(value = "管理员文件")
    @TableField("ADMIN_FILE_")
    private String adminFile;

    @ApiModelProperty(value = "定期检查报告")
    @TableField("REGULAR_CHECK_REPORT_")
    private String regularCheckReport;

    @ApiModelProperty(value = "专项检查报告")
    @TableField("SPECIAL_CHECK_REPORT_")
    private String specialCheckReport;

    @ApiModelProperty(value = "历史主文件")
    @TableField("HISTORY_MAIN_FILE_")
    private String historyMainFile;

    @ApiModelProperty(value = "文件编号")
    @TableField("FILE_NUMBER_")
    private String fileNumber;

    @ApiModelProperty(value = "文件地址")
    @TableField("FILE_PLACE_")
    private String filePlace;

    @ApiModelProperty(value = "创建日期")
    @TableField("CREATE_DAY_")
    private String createDay;

    @ApiModelProperty(value = "长度")
    @TableField("LENGTH_")
    private Float length;

    @ApiModelProperty(value = "甲板宽度")
    @TableField("DECK_WIDTH_")
    private Float deckWidth;

    @ApiModelProperty(value = "引线")
    @TableField("LEAD_LINE_")
    private String leadLine;

    @ApiModelProperty(value = "跨径组合")
    @TableField("SPAN_COMBO_")
    private String spanCombo;

    @ApiModelProperty(value = "孔编号")
    @TableField("HOLE_NO_")
    private String holeNo;

    @ApiModelProperty(value = "孔编号型号")
    @TableField("HOLE_NO_SHAPE_")
    private String holeNoShape;

    @ApiModelProperty(value = "孔号跨径")
    @TableField("HOLE_NO_SPAN_")
    private String holeNoSpan;

    @ApiModelProperty(value = "孔编号材料")
    @TableField("HOLE_NO_MATERIAL_")
    private String holeNoMaterial;

    @ApiModelProperty(value = "主桥孔数")
    @TableField(" HOLE_COUNT_")
    private Integer  holeCount;

    @ApiModelProperty(value = "墩台号")
    @TableField("PIER_NO_")
    private String pierNo;

    @ApiModelProperty(value = "墩台号形式")
    @TableField("PIER_NO_SHAPE_")
    private String pierNoShape;

    @ApiModelProperty(value = "墩台号材料")
    @TableField("PIER_NO_MATERIAL_")
    private String pierNoMaterial;

    @ApiModelProperty(value = "墩台号基础形式")
    @TableField("PIER_NO_BASE_SHAPE_")
    private String pierNoBaseShape;

    @ApiModelProperty(value = "墩台防撞设施类型")
    @TableField("PIER_ENTRENCH_TYPE_")
    private String pierEntrenchType;

    @ApiModelProperty(value = "间隙类型 1:型钢伸缩缝 2:纯橡胶式伸缩 3:模数式伸缩缝 4:型钢+模数支承式 5:简易伸缩缝" +
            "6:梳齿板式伸缩缝 7:型钢缝+梳齿板 8:仿毛勒式伸缩缝 9:D型伸缩缝 10:80型/160型 11:无伸缩缝 12:其他 ")
    @TableField("GAP_TYPE_")
    private String gapType;

    @ApiModelProperty(value = "支座类型 1:橡胶支座(板式、盆式) 2:组合式支座(盆式、摆柱式) 3:其他支座")
    @TableField("SEAT_TYPE_")
    private String seatType;

    @ApiModelProperty(value = "地震强度")
    @TableField("EARTHQUAKE_DEGREE_")
    private String earthquakeDegree;

    @ApiModelProperty(value = "护坡")
    @TableField("PROTECT_SLOPE_")
    private String protectSlope;

    @ApiModelProperty(value = "保护体")
    @TableField("PROTECT_BODY_")
    private String protectBody;

    @ApiModelProperty(value = "调治构造")
    @TableField("STRUCTURE_")
    private String structure;

    @ApiModelProperty(value = "日常水位")
    @TableField("NATURE_WATER_LEVEL_")
    private String natureWaterLevel;

    @ApiModelProperty(value = "设计水位")
    @TableField("DESIGN_WATER_LEVEL_")
    private String designWaterLevel;

    @ApiModelProperty(value = "历史水位")
    @TableField("HISTORY_WATER_LEVEL_")
    private String historyWaterLevel;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "分类值")
    @TableField("CATEGORY_VALUE_")
    private String categoryValue;

    @ApiModelProperty(value = "中心桩号值")
    @TableField("CENT_PEG_K_")
    private String centPegK;

    @ApiModelProperty(value = "间隙类型值")
    @TableField("GAP_TYPE_VALUE_")
    private String gapTypeValue;

    @ApiModelProperty(value = "支座类型值")
    @TableField("SEAT_TYPE_VALUE_")
    private String seatTypeValue;

    @ApiModelProperty(value = "方向值")
    @TableField("DIRECTION_VALUE_")
    private String directionValue;

    @ApiModelProperty(value = "表面安装值")
    @TableField("SURFACEINSTALL_VALUE_")
    private String surfaceinstallValue;

    @ApiModelProperty(value = "形状值")
    @TableField("SHAPE_TYPE_VALUE_")
    private String shapeTypeValue;

    @ApiModelProperty(value = "桥上净高(m)")
    @TableField(" TOP_HEIGHT_")
    private String  topHeight;

    @ApiModelProperty(value = "桥下净高(m)")
    @TableField("UNDER_HEIGHT_")
    private String underHeight;

    @ApiModelProperty(value = "引道总宽")
    @TableField("LEAD_WIDTH_")
    private String leadWidth;

    @ApiModelProperty(value = "引导路面宽")
    @TableField("LEAD_RODA_WIDTH_")
    private String leadRodaWidth;

    @ApiModelProperty(value = "抗震等级")
    @TableField("ANTI_KNOCK_GRADE_")
    private String antiKnockGrade;

    @ApiModelProperty(value = "跨越地物类型")
    @TableField("ACROSS_TERRAIN_TYPE_")
    private String acrossTerrainType;

    @ApiModelProperty(value = "跨越地物名称")
    @TableField("ACROSS_TERRAIN_NAME_")
    private String acrossTerrainName;

    @ApiModelProperty(value = "通航等级 1:一级 2:二级3:三级4:四级5:五级6:六级7:七级 9:不通航")
    @TableField("OPEN_TRAFFIC_")
    private String openTraffic;

    @ApiModelProperty(value = "评定等级1:一类 2:二类 3:三类 4:四类 5:五类 9:未评定 ")
    @TableField("EVALUATE_GRADE_")
    private String evaluateGrade;

    @ApiModelProperty(value = "是否互通立交 1.是  2.否")
    @TableField("INTERCHANGE_")
    private Integer interchange;

    @ApiModelProperty(value = "车行道宽")
    @TableField("LANE_WIDTH_")
    private String laneWidth;

    @ApiModelProperty(value = "桥面标高(m)")
    @TableField("SURFACE_HIGHT_")
    private String surfaceHight;

    @ApiModelProperty(value = "横坐标")
    @TableField("LNG")
    private Double lng;
    @ApiModelProperty(value = "纵坐标")
    @TableField("LAT")
    private Double lat;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_K_")
    private String startPegK;

    @ApiModelProperty(value = "止点桩号")
    @TableField("END_PEG_K_")
    private String endPegK;

    @ApiModelProperty(value = "桥形 1：梁式桥 2：悬索桥 3:板拱桥 4:肋拱桥 5:箱形拱桥 6:双曲拱桥 7:刚架拱桥 8:桁架拱桥9:钢-混凝土组合拱桥10：斜拉桥")
    @TableField("BRI_SHAPE_")
    private Integer briShape;

    @ApiModelProperty(value = "桥形值")
    @TableField("BRI_SHAPE_VALUE_")
    private String briShapeValue;

    //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
    @ApiModelProperty(value = "正面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesFrontView;
    @ApiModelProperty(value = "侧面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesLateralView;
    @ApiModelProperty(value = "二维平面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesTwoDimensionalView;

//    @ApiModelProperty(value = "路段实体")
//    @TableField(exist = false )
//    private Road road;



}
