package com.artfess.yhxt.basedata.manager;

import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.TunnelCheckVo;
import com.artfess.yhxt.basedata.vo.TunnelRegularVo;
import com.artfess.yhxt.statistics.vo.Org4tunnelVO;

import java.text.ParseException;
import java.util.List;

/**
 * 隧道信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-28
 */
public interface TunnelInformationManager extends BaseManager<TunnelInformation> {

    //隧道经常检查
    PageList<TunnelCheckVo>  queryTunnel(QueryFilter<TunnelInformation> queryFilter) throws Exception;

    /**
     * 根据ID查隧道信息
     * @param id
     * @return
     */
    TunnelInformation getTunnelById(String id);
    /**
     * 检查编码
     * @param tunnelInformation
     */
    public void checkNumber(TunnelInformation tunnelInformation);

    /**
     * 获取下一排序号
     * @return
     */
    public Integer getSn();

    PageList<TunnelInformation> queryTunnelInformation(QueryFilter<TunnelInformation> queryFilter);
    //隧道经常检查
    PageList<TunnelRegularVo> queryTunnelRegular(QueryFilter<TunnelInformation> queryFilter) throws Exception;

    //保存隧道信息
    void saveTunnel(TunnelInformation tunnelInformation);
    //修改隧道信息
    void updateTunnel(TunnelInformation tunnelInformation);

    List<Org4tunnelVO> getTunnelCount();
}
