package com.artfess.yhxt.basedata.manager;

import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.BridgeCheckVo;
import com.artfess.yhxt.basedata.vo.BridgeRegularVo;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.yhxt.check.regular.vo.BridgeRegularCheckVo;
import com.artfess.yhxt.statistics.vo.Org4BridgeVO;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.artfess.yhxt.statistics.vo.Org4RoadVO;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;

/**
 * 桥梁信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 向贞好
 * @since 2021-07-27
 */
public interface BridgeInformationManager extends BaseManager<BridgeInformation> {

    /**
     *  桥梁经常检查
     * @param queryFilter
     * @return
     */
    PageList<BridgeCheckVo> queryBridge(QueryFilter<BridgeInformation> queryFilter) throws Exception;

    BridgeInformation getBridgeById(String id);

    BridgeInformation getBridgeByCode(String code,Integer direction);

    /**
     * 检查编码是否重复
     * @param bridgeInformation
     */
     void checkNumber(BridgeInformation bridgeInformation);

    /**
     * 获取下一排序号
     * @return
     */
     public Integer getSn();

    /**
     * 分页查询
     * @param queryFilter
     * @return
     */
    PageList<BridgeInformation> queryBridgeInformation(QueryFilter<BridgeInformation> queryFilter);


    PageList<BridgeRegularVo> queryBridgeRegularCheckVo(QueryFilter<BridgeInformation> queryFilter) throws Exception;

    //保存桥梁信息
    void saveBridge(BridgeInformation bizBridgeInformation);

    //修改桥梁信息
    void updateBridge(BridgeInformation bizBridgeInformation);

    List<Org4BridgeVO> getBridgeCount();

    List<Org4bridgeInfoVO> getBridgeInfoCount();


}
