package com.artfess.yhxt.thirdparty.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.thirdparty.model.BizTpBridge;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.model.BizTpWarningEvents;
import com.artfess.yhxt.thirdparty.dao.BizTpWarningEventsDao;
import com.artfess.yhxt.thirdparty.manager.BizTpWarningEventsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.thirdparty.vo.WarningEventsVountVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 第三方传输预警事件 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@Service
public class BizTpWarningEventsManagerImpl extends BaseManagerImpl<BizTpWarningEventsDao, BizTpWarningEvents> implements BizTpWarningEventsManager {
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    BaseContext baseContext;

    @Override
    public WarningEventsVountVo warningCountTotal(QueryFilter<BizTpWarningEvents> queryFilter) {

        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }

        WarningEventsVountVo countTotal = baseMapper.warningCountTotal(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));

        return countTotal;
    }

    @Override
    public PageList<BizTpWarningEvents> pageList(QueryFilter<BizTpWarningEvents> queryFilter) {

        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }

        IPage<BizTpWarningEvents> result = baseMapper.queryPage(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));


        return new PageList(result);
    }
}
