package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目交工申请表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-18
 */
@ApiModel(value="ProjectOverApplyFor对象", description="项目交工申请表")
@TableName("BIZ_PROJECT_OVER_APPLY_FOR")
@Data
public class ProjectOverApplyFor extends BizModel<ProjectOverApplyFor> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "工程属性")
    @TableField("PROJECT_NATURE_")
    private String projectNature;

    @ApiModelProperty(value = "工程类型")
    @TableField("PROJECT_CATEGORY_")
    private String projectCategory;

    @ApiModelProperty(value = "计划交工时间")
    @TableField("EXPECTED_COMPLETE_TIME_")
    private LocalDate expectedCompleteTime;

    @ApiModelProperty(value = "实际交工时间")
    @TableField("ACTUAL_COMPLETE_TIME_")
    private LocalDate actualCompleteTime;

    @ApiModelProperty(value = "滞后/提前原因")
    @TableField("STARTUP_DESCRIPTION_")
    private String startupDescription;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "申请时间")
    @TableField("STARTUP_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate startupTime;

    @ApiModelProperty(value = "申请人id")
    @TableField("APPLY_USER_ID_")
    private String applyUserId;

    @ApiModelProperty(value = "申请人姓名")
    @TableField("APPLY_USER_NAME_")
    private String applyUserName;

    @ApiModelProperty(value = "申请人单位ID")
    @TableField("APPLY_USER_ORG_ID_")
    private String applyUserOrgId;

    @ApiModelProperty(value = "申请人单位")
    @TableField("APPLY_USER_ORG_")
    private String applyUserOrg;

    @ApiModelProperty(value = "业主审核人ID")
    @TableField("OWNER_USER_ID_")
    private String ownerUserId;

    @ApiModelProperty(value = "业主审核人姓名")
    @TableField("OWNER_USER_NAME_")
    private String ownerUserName;

    @ApiModelProperty(value = "业主审核人所属组织ID")
    @TableField("OWNER_USER_ORG_ID_")
    private String ownerUserOrgId;

    @ApiModelProperty(value = "业主审核人所属组织")
    @TableField("OWNER_USER_ORG_")
    private String ownerUserOrg;

    @ApiModelProperty(value = "业主审核时间")
    @TableField("OWNER_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime ownerTime;

    @ApiModelProperty(value = "业主方审核意见")
    @TableField("OWNER_DESCRIPTION_")
    private String ownerDescription;

    @ApiModelProperty(value = "监理审核人ID")
    @TableField("CONFIRM_USER_ID_")
    private String confirmUserId;

    @ApiModelProperty(value = "监理审核人NAME")
    @TableField("CONFIRM_USER_NAME_")
    private String confirmUserName;

    @ApiModelProperty(value = "监理审核人所属组织ID")
    @TableField("CONFIRM_USER_ORG_ID_")
    private String confirmUserOrgId;

    @ApiModelProperty(value = "监理审核人所属组织")
    @TableField("CONFIRM_USER_ORG_")
    private String confirmUserOrg;

    @ApiModelProperty(value = "监理方审核时间")
    @TableField("CONFIRM_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "监理方审核意见")
    @TableField("CONFIRM_DESCRIPTION_")
    private String confirmDescription;

    @ApiModelProperty(value = "审核状态（0-监理方待审批、1-监理方审核通过、2-监理方审核不通过、3-业主方待审核、4-业主方审核不通过、5-业主方审核通过）")
    @TableField("CONFIRM_STATUS_")
    private Integer confirmStatus;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectNature() {
        return projectNature;
    }

    public void setProjectNature(String projectNature) {
        this.projectNature = projectNature;
    }
    public String getProjectCategory() {
        return projectCategory;
    }

    public void setProjectCategory(String projectCategory) {
        this.projectCategory = projectCategory;
    }
    public LocalDate getExpectedCompleteTime() {
        return expectedCompleteTime;
    }

    public void setExpectedCompleteTime(LocalDate expectedCompleteTime) {
        this.expectedCompleteTime = expectedCompleteTime;
    }
    public LocalDate getActualCompleteTime() {
        return actualCompleteTime;
    }

    public void setActualCompleteTime(LocalDate actualCompleteTime) {
        this.actualCompleteTime = actualCompleteTime;
    }
    public String getStartupDescription() {
        return startupDescription;
    }

    public void setStartupDescription(String startupDescription) {
        this.startupDescription = startupDescription;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public LocalDate getStartupTime() {
        return startupTime;
    }

    public void setStartupTime(LocalDate startupTime) {
        this.startupTime = startupTime;
    }
    public String getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(String applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public String getApplyUserOrgId() {
        return applyUserOrgId;
    }

    public void setApplyUserOrgId(String applyUserOrgId) {
        this.applyUserOrgId = applyUserOrgId;
    }
    public String getApplyUserOrg() {
        return applyUserOrg;
    }

    public void setApplyUserOrg(String applyUserOrg) {
        this.applyUserOrg = applyUserOrg;
    }
    public String getOwnerUserId() {
        return ownerUserId;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }
    public String getOwnerUserName() {
        return ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }
    public String getOwnerUserOrgId() {
        return ownerUserOrgId;
    }

    public void setOwnerUserOrgId(String ownerUserOrgId) {
        this.ownerUserOrgId = ownerUserOrgId;
    }
    public String getOwnerUserOrg() {
        return ownerUserOrg;
    }

    public void setOwnerUserOrg(String ownerUserOrg) {
        this.ownerUserOrg = ownerUserOrg;
    }
    public LocalDateTime getOwnerTime() {
        return ownerTime;
    }

    public void setOwnerTime(LocalDateTime ownerTime) {
        this.ownerTime = ownerTime;
    }
    public String getOwnerDescription() {
        return ownerDescription;
    }

    public void setOwnerDescription(String ownerDescription) {
        this.ownerDescription = ownerDescription;
    }
    public String getConfirmUserId() {
        return confirmUserId;
    }

    public void setConfirmUserId(String confirmUserId) {
        this.confirmUserId = confirmUserId;
    }
    public String getConfirmUserName() {
        return confirmUserName;
    }

    public void setConfirmUserName(String confirmUserName) {
        this.confirmUserName = confirmUserName;
    }
    public String getConfirmUserOrgId() {
        return confirmUserOrgId;
    }

    public void setConfirmUserOrgId(String confirmUserOrgId) {
        this.confirmUserOrgId = confirmUserOrgId;
    }
    public String getConfirmUserOrg() {
        return confirmUserOrg;
    }

    public void setConfirmUserOrg(String confirmUserOrg) {
        this.confirmUserOrg = confirmUserOrg;
    }
    public LocalDateTime getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(LocalDateTime confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getConfirmDescription() {
        return confirmDescription;
    }

    public void setConfirmDescription(String confirmDescription) {
        this.confirmDescription = confirmDescription;
    }
    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProjectOverApplyFor{" +
            "id=" + id +
            ", projectId=" + projectId +
            ", projectName=" + projectName +
            ", projectNature=" + projectNature +
            ", projectCategory=" + projectCategory +
            ", expectedCompleteTime=" + expectedCompleteTime +
            ", actualCompleteTime=" + actualCompleteTime +
            ", startupDescription=" + startupDescription +
            ", remarks=" + remarks +
            ", startupTime=" + startupTime +
            ", applyUserId=" + applyUserId +
            ", applyUserName=" + applyUserName +
            ", applyUserOrgId=" + applyUserOrgId +
            ", applyUserOrg=" + applyUserOrg +
            ", ownerUserId=" + ownerUserId +
            ", ownerUserName=" + ownerUserName +
            ", ownerUserOrgId=" + ownerUserOrgId +
            ", ownerUserOrg=" + ownerUserOrg +
            ", ownerTime=" + ownerTime +
            ", ownerDescription=" + ownerDescription +
            ", confirmUserId=" + confirmUserId +
            ", confirmUserName=" + confirmUserName +
            ", confirmUserOrgId=" + confirmUserOrgId +
            ", confirmUserOrg=" + confirmUserOrg +
            ", confirmTime=" + confirmTime +
            ", confirmDescription=" + confirmDescription +
            ", confirmStatus=" + confirmStatus +

        "}";
    }
}
