package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 工程竣工申请表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@ApiModel(value="BizProjectCompletionApplicationForm对象", description="工程竣工申请表")
public class BizProjectCompletionApplicationForm extends BizModel<BizProjectCompletionApplicationForm> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "竣工申请表id")
    @TableField("COMPLETE_APPLY_ID_")
    private String completeApplyId;

    @ApiModelProperty(value = "开工项目表id")
    @TableField("STARTUP_ID_")
    private String startupId;

    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "完工时间（预估）")
    @TableField("EXPECTED_COMPLETE_TIME_")
    private LocalDate expectedCompleteTime;

    @ApiModelProperty(value = "完工时间（实际）")
    @TableField("ACTUAL_COMPLETE_TIME_")
    private LocalDate actualCompleteTime;

    @ApiModelProperty(value = "是否竣工（1-是、0-否）")
    @TableField("COMPLETE_FLAG_")
    private Integer completeFlag;

    @ApiModelProperty(value = "提出申请次数（默认1）")
    @TableField("REPEAT_COUNT_")
    private Integer repeatCount;

    @ApiModelProperty(value = "审核阶段（0-申请、1-监理、2-业主）")
    @TableField("AUDIT_STEP_")
    private Integer auditStep;

    @ApiModelProperty(value = "审核状态（0-待审核、1-通过、2-不通过）")
    @TableField("AUDIT_STATUS_")
    private Integer auditStatus;

    @ApiModelProperty(value = "工作滞后原因")
    @TableField("DELAY_REASON_")
    private String delayReason;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompleteApplyId() {
        return completeApplyId;
    }

    public void setCompleteApplyId(String completeApplyId) {
        this.completeApplyId = completeApplyId;
    }

    public String getStartupId() {
        return startupId;
    }

    public void setStartupId(String startupId) {
        this.startupId = startupId;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public LocalDate getExpectedCompleteTime() {
        return expectedCompleteTime;
    }

    public void setExpectedCompleteTime(LocalDate expectedCompleteTime) {
        this.expectedCompleteTime = expectedCompleteTime;
    }

    public LocalDate getActualCompleteTime() {
        return actualCompleteTime;
    }

    public void setActualCompleteTime(LocalDate actualCompleteTime) {
        this.actualCompleteTime = actualCompleteTime;
    }

    public Integer getCompleteFlag() {
        return completeFlag;
    }

    public void setCompleteFlag(Integer completeFlag) {
        this.completeFlag = completeFlag;
    }

    public Integer getRepeatCount() {
        return repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Integer getAuditStep() {
        return auditStep;
    }

    public void setAuditStep(Integer auditStep) {
        this.auditStep = auditStep;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getDelayReason() {
        return delayReason;
    }

    public void setDelayReason(String delayReason) {
        this.delayReason = delayReason;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectCompletionApplicationForm{" +
            "id=" + id +
            ", completeApplyId=" + completeApplyId +
            ", startupId=" + startupId +
            ", projectId=" + projectId +
            ", remarks=" + remarks +
            ", expectedCompleteTime=" + expectedCompleteTime +
            ", actualCompleteTime=" + actualCompleteTime +
            ", completeFlag=" + completeFlag +
            ", repeatCount=" + repeatCount +
            ", auditStep=" + auditStep +
            ", auditStatus=" + auditStatus +
            ", delayReason=" + delayReason +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
