package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.manager.BizMigrantWorkersSalaryManager;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersSalary;
import com.artfess.yhxt.specialproject.model.BizMigrantWorkersSalary;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 民工工资发放情况表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-13
 */
@RestController
@RequestMapping("/bizMigrantWorkersSalary/v1/")
@Api(tags = "民工工资发放情况")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMigrantWorkersSalaryController extends BaseController<BizMigrantWorkersSalaryManager, BizMigrantWorkersSalary> {

    @Resource
    private BaseContext baseContext;


    @RequestMapping(value = "/saveMigrantWorkersSalary",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改民工工资发放情况",httpMethod = "POST")
    public CommonResult<String> saveMigrantWorkersSalary(@ApiParam(name = "bizMigrantWorkersSalary",value = "民工工资发放情况对象") @RequestBody BizMigrantWorkersSalary bizMigrantWorkersSalary) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizMigrantWorkersSalary.getId())){
            bizMigrantWorkersSalary.setIsDele("0");
            baseService.create(bizMigrantWorkersSalary);
        }else {
            baseService.update(bizMigrantWorkersSalary);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询民工工资发放情况",httpMethod ="POST")
    public PageList<BizMigrantWorkersSalary> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizMigrantWorkersSalary> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        PageList<BizMigrantWorkersSalary> pageList = baseService.queryBizMigrantWorkersSalary(queryFilter);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){

        }
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询民工工资发放情况信息",httpMethod = "GET",notes = "根据ID查询民工工资发放情况")
    public BizMigrantWorkersSalary get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizMigrantWorkersSalaryById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除民工工资发放情况",httpMethod = "DELETE",notes = "批量删除民工工资发放情况")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateMigrantWorkersSalary",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除民工工资发放情况",httpMethod = "DELETE",notes = "逻辑删除民工工资发放情况")
    public CommonResult<String> updateMigrantWorkersSalary(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizMigrantWorkersSalary> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

}
