package com.artfess.yhxt.contract.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 合同明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-06
 */
@ApiModel(value="ContractItem对象", description="合同明细表")
@TableName("BIZ_CONTRACT_ITEM")
@Data
public class ContractItem extends BaseModel<ContractItem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "序号")
    @TableField("SORT_")
    private Integer sort;

    @ApiModelProperty(value = "科目编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "科目名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "细科目编码")
    @TableField("FINE_SUBJECT_CODE_")
    private String fineSubjectCode;

    @ApiModelProperty(value = "细科目名称")
    @TableField("FINE_SUBJECT_NAME_")
    private String fineSubjectName;

    @ApiModelProperty(value = "子科目编码")
    @TableField("SON_SUBJECT_CODE_")
    private String sonSubjectCode;

    @ApiModelProperty(value = "子科目名称")
    @TableField("SON_SUBJECT_NAME_")
    private String sonSubjectName;

    @ApiModelProperty(value = "单位")
    @TableField("SPEC_")
    private String spec;

    @ApiModelProperty(value = "对应合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "单价（元）")
    @TableField("PRICE_")
    private Double price;


    @ApiModelProperty(value = "单价（元）是否含税")
    @TableField("PRICE_IS_TAX_")
    private Integer priceIsTax;




    @ApiModelProperty(value = "数量")
    @TableField("AMOUNT_")
    private Double amount;

    @ApiModelProperty(value = "金额（元）")
    @TableField("MONTY_")
    private Double monty;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
