package com.artfess.yhxt.basedata.manager;


import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.SideSlopCheckVo;
import com.artfess.yhxt.basedata.vo.SideSlopeRegularVo;
import com.artfess.yhxt.statistics.vo.Org4sideSlopelVO;
import com.artfess.yhxt.statistics.vo.Org4tunnelVO;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.text.ParseException;
import java.util.List;

/**
 * 边坡信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 向贞好
 * @since 2021-07-28
 */
public interface SideSlopeInformationManager extends BaseManager<SideSlopeInformation> {

    //边坡经常检查
    PageList<SideSlopCheckVo> querySideSlope(QueryFilter<SideSlopeInformation> queryFilter) throws Exception;

    /**
     * 根据ID查询边坡信息
     * @param id
     * @return
     */
    SideSlopeInformation getSideSlopeById(String id);

    /**
     * 检查编码
     * @param sideSlopeInformation
     */
    public void checkNumber(SideSlopeInformation sideSlopeInformation);
    /**
     * 获取下一排序号
     * @return
     */
    public Integer getSn();

    PageList<SideSlopeInformation> querySideSlopeInformation(QueryFilter<SideSlopeInformation> queryFilter);
    //定期检查
    PageList<SideSlopeRegularVo> queryRegularSideSlope(QueryFilter<SideSlopeInformation> queryFilter) throws Exception;

    /**
     * 添加边坡
     * @param sideSlopeInformation
     */
    void saveSideSlope(SideSlopeInformation sideSlopeInformation);

    /**
     * 修改边坡
     * @param sideSlopeInformation
     */
    void updateSideSlope(SideSlopeInformation sideSlopeInformation);

    List<Org4sideSlopelVO> getsideSlopelCount();
}
