package com.artfess.yhxt.thirdparty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.time.DateUtil;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.vo.AbnormalCountVo;
import com.artfess.yhxt.thirdparty.vo.TpDeviceTypeCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.thirdparty.model.BizTpBridgeHealth;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeHealthManager;

import java.util.List;

/**
 * 第三方传输桥梁健康信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@RestController
@RequestMapping("/bizTpBridgeHealth/v1/")
@Api(tags = "第三方传输桥梁健康信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizTpBridgeHealthController extends BaseController<BizTpBridgeHealthManager, BizTpBridgeHealth> {


    @RequestMapping(value = "abnormalCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "健康信息统计", httpMethod = "POST", notes = "健康信息统计")
    public AbnormalCountVo abnormalCountVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpBridgeHealth> queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        int j=0;
        int k=0;
        //设置时间查询
        for (QueryField query : querys) {
            if(query.getProperty().equals("modelDateGreat")){
                query.setProperty("ASSESSMENT_DATE_");
                query.setOperation(QueryOP.GREAT_EQUAL);
                String startDay =(String) query.getValue();




                j++;
            }
            if(query.getProperty().equals("modelDateLess")){
                query.setProperty("ASSESSMENT_DATE_");
                query.setOperation(QueryOP.LESS_EQUAL);

                query.setValue(  DateUtil.getNextDay((String) query.getValue())   );
                k++;
            }
        }

        if(j == 0 || k ==0){
            QueryField queryField1 = new QueryField();
            queryField1.setProperty("ASSESSMENT_DATE_");
            queryField1.setOperation(QueryOP.GREAT_EQUAL);
            queryField1.setGroup("main");
            queryField1.setRelation(FieldRelation.AND);
            queryField1.setValue(DateUtil.getStartDayByMonth());

            querys.add(queryField1);

            QueryField queryField2 = new QueryField();
            queryField2.setProperty("ASSESSMENT_DATE_");
            queryField2.setOperation(QueryOP.LESS_EQUAL);
            queryField2.setGroup("main");
            queryField2.setRelation(FieldRelation.AND);
            queryField2.setValue(DateUtil.getLastDayByMonth());
            querys.add(queryField2);

        }


        return baseService.abnormalCountVo(queryFilter);
    }


}
