package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.vo.ProjectAcceptanceVo;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.ProjectAcceptance;
import com.artfess.yhxt.specialproject.manager.ProjectAcceptanceManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-19
 */
@RestController
@RequestMapping("/projectAcceptance/v1/")
@Api(tags = "项目验收信息接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectAcceptanceController extends BaseController<ProjectAcceptanceManager, ProjectAcceptance> {

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "getJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "分页查询项目验收信息", httpMethod = "POST")
    public PageList<ProjectAcceptance> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ProjectAcceptance> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){

        }
        PageList<ProjectAcceptance> pageList = baseService.queryProjectAcceptance(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存项目验收信息", httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "projectAcceptance", value = "项目验收信息对象") @RequestBody ProjectAcceptance projectAcceptance) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(projectAcceptance.getId())){
            projectAcceptance.setIsDele("0");
            projectAcceptance.setUploadUser(baseContext.getCurrentUserName());
            projectAcceptance.setUploadUserCompanyName(baseContext.getCurrentDeptName());
            baseService.create(projectAcceptance);
        }else {
            baseService.update(projectAcceptance);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存项目验收信息、附件", httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "projectAcceptanceVo", value = "项目验收信息对象") @RequestBody ProjectAcceptanceVo projectAcceptanceVo) throws Exception {
        String msg = "添加成功";
        ProjectAcceptance projectAcceptance = projectAcceptanceVo.getProjectAcceptance();
        if (StringUtils.isEmpty(projectAcceptance.getId())){
            projectAcceptance.setIsDele("0");
            projectAcceptance.setUploadUser(baseContext.getCurrentUserName());
            projectAcceptance.setUploadUserCompanyName(baseContext.getCurrentDeptName());
            baseService.saveVo(projectAcceptanceVo);
        }else {
            baseService.updateVo(projectAcceptanceVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }
    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID项目交工申请信息、附件",httpMethod = "GET",notes = "根据ID项目交工申请信息、附件")
    public ProjectAcceptanceVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @RequestMapping(value = "/deleteProjectContractPayment", method = RequestMethod.DELETE, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目验收信息", httpMethod = "DELETE", notes = "逻辑删除项目验收信息")
    public CommonResult<String> deleteProjectContractPayment(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (net.hasor.utils.StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<ProjectAcceptance> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/minioAcceptanceUpload")
    @ApiOperation(value = "验收资料上传接口")
    public BizEngineeringAccessories minioAcceptanceUpload(MultipartFile file,
                                                           @ApiParam(name = "sourceId",value = "资源id",required = true) String sourceId ){
        BizEngineeringAccessories accessories = this.baseService.minioAcceptanceUpload(file, sourceId);
        return accessories;
    }


    @DeleteMapping(value = "/removesAcceptance")
    @ApiOperation(value = "删除验收资料", httpMethod = "DELETE", notes = "删除验收资料")
    public CommonResult<String> minioAcceptanceDel(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String ids) throws Exception {
        baseService.minioAcceptanceDel(Arrays.asList(ids.split(",")));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping("/downloadAcceptanceUpload")
    @ApiOperation(value = "验收资料下载接口", httpMethod = "POST", notes = "验收资料下载接口")
    public void downloadAcceptanceUpload( @ApiParam(name = "ids", value = "附件ID集合以，隔开")
                                        @RequestParam(value = "ids", required = true) String ids,
                                        @ApiParam(name = "type",value = "资料类型",required = true) Integer type,
                                        HttpServletResponse response) throws Exception {
        this.baseService.minIoAcceptanceDownFile(ids,response);

    }
}
