package com.artfess.yhxt.specialcheck.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialcheck.vo.InspectionTaskConfigVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialcheck.model.InspectionTaskConfig;
import com.artfess.yhxt.specialcheck.manager.InspectionTaskConfigManager;

import java.util.Arrays;
import java.util.List;

/**
 * 巡检任务-任务配置表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-26
 */
@RestController
@RequestMapping("/inspectionTaskConfig/v1/")
@Api(tags = "巡检配置管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class InspectionTaskConfigController extends BaseController<InspectionTaskConfigManager, InspectionTaskConfig> {
    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询巡检配置",httpMethod = "POST")
    public PageList<InspectionTaskConfigVo> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<InspectionTaskConfig> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<InspectionTaskConfigVo> pageList = baseService.queryInspectionTaskConfig(queryFilter);
        return  pageList;
    }


    @RequestMapping(value = "/saveInspectionTaskConfigSpecial", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改巡检配置信息", httpMethod = "POST")
    public CommonResult<InspectionTaskConfig> saveInspectionTaskConfig(@ApiParam(name = "inspectionTaskConfig", value = "巡检配置信息对象") @RequestBody InspectionTaskConfig inspectionTaskConfig) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(inspectionTaskConfig.getId())) {
            inspectionTaskConfig.setIsDele("0");
            baseService.create(inspectionTaskConfig);
        } else {
            baseService.update(inspectionTaskConfig);
            msg = "修改成功";
        }
        return new CommonResult<InspectionTaskConfig>(true, msg, inspectionTaskConfig);
    }

    @RequestMapping(value = "/delInspectionTaskConfig", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除巡检配置", httpMethod = "DELETE", notes = "逻辑删除巡检配置")
    public CommonResult<String> delInspectionTaskConfig(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                     @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<InspectionTaskConfig> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询巡检配置",httpMethod = "GET",notes = "根据ID查询巡检配置")
    public InspectionTaskConfigVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
       // return baseService.getById(id);
        return baseService.getVo(id);
    }

    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态", httpMethod = "POST", notes = "批量修改启用禁用状态")
    public CommonResult<String> updateStatus(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                        @RequestParam(value = "ids", required = true) String ids,
                                             @ApiParam(name = "status", value = "状态：启用（0）、禁用（1）", required = true)
                                             @RequestParam(value = "status", required = true) String status) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<InspectionTaskConfig> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("STATUS_",status);
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "修改成功");
    }
}
