package com.artfess.yhxt.push.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.BizRoadsideFacilitiesManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.BizRoadsideFacilities;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.businessdata.dao.CompanyDao;
import com.artfess.yhxt.push.HttpUtil;
import com.artfess.yhxt.push.dao.PushTaskMapper;
import com.artfess.yhxt.push.service.PushTaskService;
import com.artfess.yhxt.push.vo.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author zhx
 * @create 2021/10/18
 */
@Service
public class PushTaskServiceImpl implements PushTaskService {
    @Resource
    private PushTaskMapper pushTaskMapper;
    @Resource
    private BridgeInformationManager bridgeInformationManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private RoadManager roadManager;
    @Resource
    private BizRoadsideFacilitiesManager bizRoadsideFacilitiesManager;
    @Resource
    private CompanyDao companyDao;


    //测试环境
//    private final String host = "http://36.110.47.222:10012";
    //正式环境
    private final String host = "http://183.64.175.153:20002";
    //总公司id用于查询分公司的code
    private final String parentId = "1419863231459102720";

    @Override
    public void JV22BASESTRUCT() throws Exception {

        List<Org> orgList = companyDao.getOrgsByparentId(parentId);


        ArrayList<JV22BASESTRUCTVo> vos = new ArrayList<>();
        for (Org org : orgList) {
            JV22BASESTRUCTVo jv22BASESTRUCTVo = new JV22BASESTRUCTVo();
            jv22BASESTRUCTVo.setOrgCode(org.getCode());
            vos.add(jv22BASESTRUCTVo);
        }
        //桥梁类型统计
        List<Map<String, Object>> pushBrideCountType = this.pushTaskMapper.getPushBrideCountType();
        //隧道类型统计
        List<Map<String, Object>> pushTunnelCountType = this.pushTaskMapper.getPushTunnelCountType();
        //涵洞数量
        List<Map<String, Object>> pushCulverCount = this.pushTaskMapper.getCulvertCount();
        //收费站 服务区数量
        List<Map<String, Object>> roadsideFacilitiesCount = this.pushTaskMapper.getRoadsideFacilities();
        //
        List<Map<String, Object>> roadCount = this.pushTaskMapper.getRoadCount();
        //路段
        for (JV22BASESTRUCTVo vo : vos) {
            for (Map<String, Object> map : pushBrideCountType) {
                if (((String) map.get("orgCode")).equals(vo.getOrgCode())) {
                    //JV22BASESTRUCTVo jv22BASESTRUCTVo = new JV22BASESTRUCTVo();
                    //jv22BASESTRUCTVo.setOrgCode((String) map.get("orgCode"));

                    int type1 = Integer.parseInt(String.valueOf(map.get("type1")));
                    vo.setWbigBridgeNums(type1);
                    int type2 = Integer.parseInt(String.valueOf(map.get("type2")));
                    vo.setBigBridgeNums(type2);
                    int type3 = Integer.parseInt(String.valueOf(map.get("type3")));
                    vo.setMidBridgeNums(type3);
                    int type4 = Integer.parseInt(String.valueOf(map.get("type4")));
                    vo.setSmallBridgeNums(type4);
                    vo.setBigBridgeNums(type1 + type2 + type3 + type4);
                }
            }
        }
        for (JV22BASESTRUCTVo vo : vos) {
            for (Map<String, Object> map : pushTunnelCountType) {
                if (((String) map.get("orgCode")).equals(vo.getOrgCode())) {
                    int type1 = Integer.parseInt(String.valueOf(map.get("type1")));
                    vo.setWlangChunnelNums(type1);
                    int type2 = Integer.parseInt(String.valueOf(map.get("type2")));
                    vo.setLangChunnelNums(type2);
                    int type3 = Integer.parseInt(String.valueOf(map.get("type3")));
                    vo.setMidChunnelNums(type3);
                    int type4 = Integer.parseInt(String.valueOf(map.get("type4")));
                    vo.setShortChunnelNums(type4);
                    vo.setChunnelNums(type1 + type2 + type3 + type4);
                }
            }
        }
        for (JV22BASESTRUCTVo vo : vos) {
            for (Map<String, Object> map : pushCulverCount) {
                if (((String) map.get("orgCode")).equals(vo.getOrgCode())) {
                    Object totalCount = map.get("totalCount");
                    if (ObjectUtils.isNotEmpty(totalCount)) {
                        vo.setTunnelNums(Integer.parseInt(String.valueOf(totalCount)));
                    }
                }
            }
        }
        for (JV22BASESTRUCTVo vo : vos) {
            for (Map<String, Object> map : roadsideFacilitiesCount) {
                if (((String) map.get("orgCode")).equals(vo.getOrgCode())) {
                    vo.setTollStatNums(Integer.parseInt(String.valueOf(map.get("type3"))));
                    vo.setServiceStatNums(Integer.parseInt(String.valueOf(map.get("type4"))));
                }
            }
        }
        for (JV22BASESTRUCTVo vo : vos) {
            for (Map<String, Object> map : roadCount) {
                if (((String) map.get("orgCode")).equals(vo.getOrgCode())) {
                    vo.setRoadSecNums(Integer.parseInt(String.valueOf(map.get("totalCount"))));
                }
            }
        }
        for (JV22BASESTRUCTVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv22BaseStruct" + "?orgCode=" + vo.getOrgCode());
            //JV22BASESTRUCTVo jv22BASESTRUCTVo = (JV22BASESTRUCTVo)getJV22BASESTRUCTVo(json,JV22BASESTRUCTVo.class);
            if (null != json) {
                List<Object> list = getClazz(json, JV22BASESTRUCTVo.class);
                // Object o = list.get(0);
                if (list.size() > 0) {
                    for (Object o : list) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        JV22BASESTRUCTVo jv22BASESTRUCTVo = objectMapper.convertValue(o, JV22BASESTRUCTVo.class);
                        if (jv22BASESTRUCTVo != null && jv22BASESTRUCTVo.getOrgCode().equals(vo.getOrgCode())) {
                            vo.setVideo(jv22BASESTRUCTVo.getVideo());
                            vo.setVms(jv22BASESTRUCTVo.getVms());
                            vo.setRouteEtc(jv22BASESTRUCTVo.getRouteEtc());
                            vo.setRouteNetc(jv22BASESTRUCTVo.getRouteNetc());
                            vo.setId(jv22BASESTRUCTVo.getId());
                            System.out.println(jv22BASESTRUCTVo);
                        }
                    }
                }
            }
        }
        for (JV22BASESTRUCTVo vo : vos) {
            Map<String, Object> map = BeanUtil.beanToMap(vo);
            System.out.println(map);
            HttpUtil.post(host + "/server-cockpitv/cockpitv/jv22BaseStruct", map, null, null, 50000, 50000, null);
        }

    }

    @Override
    public void JV22BASESTRUCTDETAIL() throws Exception {

        ArrayList<JV22BASESTRUCTDETAILVo> vos = new ArrayList<>();
        //所有桥的信息
        List<Map<String, Object>> bridgeInformationList = this.pushTaskMapper.selectBrgList();
        //再查询桥梁长度 length
        //隧道
        List<Map<String, Object>> tunnelInformationList = this.pushTaskMapper.selectTunnelList();
        //隧道长度 length

        //路段 road
        List<Map<String, Object>> roadList = this.pushTaskMapper.selectRoadList();
        //路段长度
        //服务区和收费站
        List<Map<String, Object>> areaAndStatList = this.pushTaskMapper.selectAreaAndStatList();

        //桥梁
        for (Map<String, Object> map : bridgeInformationList) {
            //组织code
            String orgCode = (String) map.get("orgCode");
            //公司ID
            Object companyId = map.get("companyId");
            //桥梁名称
            Object name = map.get("name");
            //桥梁编码
            Object code = map.get("code");
            //桥梁类型
            Object type = map.get("type");
            QueryWrapper<BridgeInformation> bridgeInformationQueryWrapper = new QueryWrapper<>();
            bridgeInformationQueryWrapper.eq("COMPANY_ID_", companyId);
            bridgeInformationQueryWrapper.eq("NUMBER_", code);
            List<BridgeInformation> bridgeList = this.bridgeInformationManager.getBaseMapper().selectList(bridgeInformationQueryWrapper);
            if (bridgeList.size() > 0) {
                BridgeInformation bridgeInformation = bridgeList.get(0);
                JV22BASESTRUCTDETAILVo detailVo = new JV22BASESTRUCTDETAILVo();
                //title
                detailVo.setTitle(bridgeInformation.getName());
                //桥梁编码
                detailVo.setCode(bridgeInformation.getNumber());
                //demo
                detailVo.setDemo(bridgeInformation.getLength() + "m [" + bridgeInformation.getTypeValue() + "]");
                detailVo.setExt(bridgeInformation.getCentPegK());
                detailVo.setOrgCode(orgCode);
                detailVo.setType("brg");
                vos.add(detailVo);
            }
        }


        for (Map<String, Object> map : tunnelInformationList) {
            //组织code
            String orgCode = (String) map.get("orgCode");
            //公司ID
            Object companyId = map.get("companyId");
            //桥梁名称
            Object name = map.get("name");
            //桥梁编码
            Object code = map.get("code");
            //桥梁类型
            Object type = map.get("type");
            QueryWrapper<TunnelInformation> tunnelQueryWrapper = new QueryWrapper<>();
            tunnelQueryWrapper.eq("COMPANY_ID_", companyId);
            tunnelQueryWrapper.eq("NUMBER_", code);
            List<TunnelInformation> tunnelList = tunnelInformationManager.getBaseMapper().selectList(tunnelQueryWrapper);
            if (tunnelList.size() > 0) {
                TunnelInformation tunnelInformation = tunnelList.get(0);
                JV22BASESTRUCTDETAILVo detailVo = new JV22BASESTRUCTDETAILVo();
                //title
                detailVo.setTitle(tunnelInformation.getName());
                //桥梁编码
                detailVo.setCode(tunnelInformation.getNumber());
                //demo
                detailVo.setDemo(tunnelInformation.getLength() + "m [" + tunnelInformation.getTypeValue() + "]");
                detailVo.setExt(tunnelInformation.getCentPegK());
                detailVo.setOrgCode(orgCode);
                detailVo.setType("tunnel");
                vos.add(detailVo);
            }
        }
        for (Map<String, Object> map : roadList) {
            //组织code
            String orgCode = (String) map.get("orgCode");
            //公司ID
            Object companyId = map.get("companyId");
            //路段
            Object name = map.get("name");
            //路段编码
            Object code = map.get("code");
            QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
            roadQueryWrapper.eq("COMPANY_ID", companyId);
            roadQueryWrapper.eq("CODE_", code);
            List<Road> roads = roadManager.getBaseMapper().selectList(roadQueryWrapper);
            if (roads.size() > 0) {
                Road road = roads.get(0);
                JV22BASESTRUCTDETAILVo detailVo = new JV22BASESTRUCTDETAILVo();
                //title
                detailVo.setTitle(road.getName());
                //桥梁编码
                detailVo.setCode(road.getCode());
                //demo
                detailVo.setDemo(road.getLength() + "Km [" + road.getTypeValue() + "]");
                detailVo.setExt("起点桩号:" + road.getStartPegK() + ",指定桩号:" + road.getEndPegK());
                detailVo.setOrgCode(orgCode);
                detailVo.setType("road");
                vos.add(detailVo);
            }
        }
        //服务区 收费站
        for (Map<String, Object> map : areaAndStatList) {
            //组织code
            String orgCode = (String) map.get("orgCode");
            //公司ID
            Object companyId = map.get("companyId");
            //沿线设施名称
            Object name = map.get("name");
            //沿线设施编码
            Object code = map.get("code");
            //沿线设施类型
            Object direction = map.get("direction");
            QueryWrapper<BizRoadsideFacilities> bizRoadsideFacilitiesQueryWrapper = new QueryWrapper<>();
            bizRoadsideFacilitiesQueryWrapper.eq("COMPANY_ID_", companyId);
            bizRoadsideFacilitiesQueryWrapper.eq("NUMBER_", code);
            bizRoadsideFacilitiesQueryWrapper.eq("DIRECTION_", direction);
            List<BizRoadsideFacilities> bizRoadsideFacilities = bizRoadsideFacilitiesManager.getBaseMapper().selectList(bizRoadsideFacilitiesQueryWrapper);
            if (bizRoadsideFacilities.size() > 0) {
                BizRoadsideFacilities roadsideFacilities = bizRoadsideFacilities.get(0);
                JV22BASESTRUCTDETAILVo detailVo = new JV22BASESTRUCTDETAILVo();
                //title
                detailVo.setTitle(roadsideFacilities.getName());
                //桥梁编码
                detailVo.setCode(roadsideFacilities.getNumber());
                //demo 方向
                detailVo.setDemo(roadsideFacilities.getDirectionValue());
                detailVo.setExt(roadsideFacilities.getPegK());
                detailVo.setOrgCode(orgCode);
                if (roadsideFacilities.getType().equals("3")) {
                    detailVo.setType("stat");
                    vos.add(detailVo);
                }
                if (roadsideFacilities.getType().equals("4")) {
                    detailVo.setType("area");
                    vos.add(detailVo);
                }
            }
        }

        System.out.println(vos);

        for (JV22BASESTRUCTDETAILVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv22BaseStructDetail" + "?orgCode=" + vo.getOrgCode() + "&" + "code=" + vo.getCode());
            if (null != json) {
                List<Object> list = getClazz(json, JV22BASESTRUCTDETAILVo.class);
                JV22BASESTRUCTDETAILVo jv22BASESTRUCTDETAILVo = null;
                if (list.size() > 0) {
//                Object o = list.get(0);
                    for (Object o : list) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        jv22BASESTRUCTDETAILVo = objectMapper.convertValue(o, JV22BASESTRUCTDETAILVo.class);

                        if (jv22BASESTRUCTDETAILVo != null && jv22BASESTRUCTDETAILVo.getOrgCode().equals(vo.getOrgCode())) {
//                        jv22BASESTRUCTDETAILVo.setCode(vo.getCode());
//                        jv22BASESTRUCTDETAILVo.setDemo(vo.getDemo());
//                        jv22BASESTRUCTDETAILVo.setExt(vo.getExt());
//                        jv22BASESTRUCTDETAILVo.setOrgCode(vo.getOrgCode());
//                        jv22BASESTRUCTDETAILVo.setTitle(vo.getTitle());
//                        jv22BASESTRUCTDETAILVo.setType(vo.getType());
                            vo.setId(jv22BASESTRUCTDETAILVo.getId());
                            System.out.println(jv22BASESTRUCTDETAILVo);
                        }
                    }
                }
            }
        }
        System.out.println(vos);
        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        System.out.println(json);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv22BaseStructDetail", json, null, null, 50000, 50000, null);

    }

    @Override
    public void jv21Baseinfo() throws Exception {
        //获取所有的子公司
        List<Org> orgList = companyDao.getOrgsByparentId(parentId);
        int size = orgList.size();
        //路段详细信息
        List<Road> roadInformationList = this.pushTaskMapper.selectRoadInformationList();

        //管理路段个数
        int roadCount = roadInformationList.size();

        //路段总数
        Jv21BaseinfoVo vo = new Jv21BaseinfoVo();
        //公司个数
        vo.setGkxm(String.valueOf(size));
        //路段
        vo.setGkld(String.valueOf(roadCount));
        //管理里程  投资经营里程
       /* Float sum = 0F;
        for (Road road : roadInformationList) {
            sum += road.getLength();
        }
        String length = sum.toString();*/
        Integer length = this.pushTaskMapper.RoadCountLength();

        vo.setJygllc(String.valueOf(length));
        vo.setTzjylc(String.valueOf(length));
        String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv21Baseinfo");
        if (null != json) {
            List<Object> list = getClazz(json, Jv21BaseinfoVo.class);
            if (list.size() > 0) {
                Object o = list.get(0);
                ObjectMapper objectMapper = new ObjectMapper();
                Jv21BaseinfoVo jv21BaseinfoVo = objectMapper.convertValue(o, Jv21BaseinfoVo.class);
                //HttpUtil.delete()
                vo.setId(jv21BaseinfoVo.getId());
            }
        }
        Map<String, Object> map = BeanUtil.beanToMap(vo);
        System.out.println(map);
        HttpUtil.post(host + "/server-cockpitv/cockpitv/jv21Baseinfo", map, null, null, 50000, 50000, null);


    }

    @Override
    public void JV24EmployeeNew() throws Exception {

        //获取所有的子公司
        List<Org> orgList = companyDao.getOrgsByparentId(parentId);
        ArrayList<JV24EMPLOYEENEWVo> vos = new ArrayList<>();

        List<Map<String, Object>> userList = this.pushTaskMapper.getUserCount();
        System.out.println(userList);
        for (Map<String, Object> map : userList) {
            JV24EMPLOYEENEWVo vo = new JV24EMPLOYEENEWVo();
            //组织编码
            String orgCode = (String) map.get("orgCode");
            //组织名称
            String orgName = (String) map.get("orgName");
            //公司ID
            String companyId = (String) map.get("companyId");

            vo.setOrgCode(orgCode);
            vo.setOrgName(orgName);
            String personnelType = map.get("personnelType").toString();
            if (personnelType.equals("1")) {
                vo.setPrgName("管理人员");
                vo.setAccval(map.get("personnelTotalNums").toString());
            }
            if (personnelType.equals("2")) {
                vo.setPrgName("巡查巡检人员");
                vo.setAccval(map.get("personnelTotalNums").toString());
            }
            if (personnelType.equals("3")) {
                vo.setPrgName("养护人员");
                vo.setAccval(map.get("personnelTotalNums").toString());
            }
            if (personnelType.equals("4")) {
                vo.setPrgName("施工人员");
                vo.setAccval(map.get("personnelTotalNums").toString());
            }

            vo.setAccDate(new SimpleDateFormat("YYYY-MM").format(new Date()));
            vos.add(vo);
        }

        System.out.println(vos);
        for (JV24EMPLOYEENEWVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv24EmployeeNew" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
            if (null != json) {
                List<Object> list = getClazz(json, JV24EMPLOYEENEWVo.class);
                JV24EMPLOYEENEWVo jv24EMPLOYEENEWVo = null;
                if (list.size() > 0) {
//                    Object o = list.get(0);
                    for (Object o : list) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        jv24EMPLOYEENEWVo = objectMapper.convertValue(o, JV24EMPLOYEENEWVo.class);

                        if (jv24EMPLOYEENEWVo != null && jv24EMPLOYEENEWVo.getOrgCode().equals(vo.getOrgCode()) && jv24EMPLOYEENEWVo.getAccDate().equals(vo.getAccDate())) {
                            vo.setId(jv24EMPLOYEENEWVo.getId());
                            System.out.println(jv24EMPLOYEENEWVo);
                        }
                    }

                }
            }
        }
        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv24EmployeeNew", json, null, null, 50000, 50000, null);
    }

    @Override
    public void JVA22DiseaseProjTotal() throws Exception {
        //获取所有的子公司
        List<Org> orgList = companyDao.getOrgsByparentId(parentId);

        //病害总数
        ArrayList<JvA22DiseaseProjTotalVo> vos = new ArrayList<>();
        for (Org org : orgList) {
            JvA22DiseaseProjTotalVo jvA22DiseaseProjTotalVo = new JvA22DiseaseProjTotalVo();
            jvA22DiseaseProjTotalVo.setOrgCode(org.getCode());
            jvA22DiseaseProjTotalVo.setOrgName(org.getName());
            vos.add(jvA22DiseaseProjTotalVo);

        }
        //查询所有病害
        List<Map<String, Object>> diseaseList = this.pushTaskMapper.selectDiseaseList();
        for (JvA22DiseaseProjTotalVo vo : vos) {
            for (Map<String, Object> map : diseaseList) {

                //组织编码
                String orgCode = (String) map.get("orgCode");
                if (orgCode.equals(vo.getOrgCode())) {
                    //组织名称
                    String orgName = (String) map.get("orgName");
                    //病害数量
                    Number bhNum = (Number) map.get("bhNum");

                    //公司ID
                    String companyId = (String) map.get("companyId");
                    //日期yyyy
                    String accDate = String.valueOf(map.get("accDate"));
                    //养护工单数量
                    Integer workOrderCount = this.pushTaskMapper.selectWorkOrderList(companyId, accDate);
                    //专项工程数量
                    Integer engineeringProjectCount = this.pushTaskMapper.selectProjectContractList(companyId, accDate);
                    Integer gcNum = workOrderCount;
                    vo.setAccDate(accDate);
                    vo.setBhNum(bhNum);
                    vo.setOrgName(orgName);
                    vo.setOrgCode(orgCode);
                    vo.setGcNum(gcNum);
                }
            }

        }

        System.out.println(vos);
        for (JvA22DiseaseProjTotalVo vo : vos) {
            if(null != vo.getOrgCode() && null != vo.getAccDate()){
                String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jvA22DiseaseProjTotal" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
                if (null != json) {
                    List<Object> list = getClazz(json, JvA22DiseaseProjTotalVo.class);
                    JvA22DiseaseProjTotalVo jvA22DiseaseProjTotalVo = null;
                    if (list.size() > 0) {
//                    Object o = list.get(0);
                        for (Object o : list) {
                            ObjectMapper objectMapper = new ObjectMapper();
                            jvA22DiseaseProjTotalVo = objectMapper.convertValue(o, JvA22DiseaseProjTotalVo.class);

                            if (jvA22DiseaseProjTotalVo != null && jvA22DiseaseProjTotalVo.getOrgCode().equals(vo.getOrgCode()) && jvA22DiseaseProjTotalVo.getAccDate().equals(vo.getAccDate())) {
                                vo.setId(jvA22DiseaseProjTotalVo.getId());
                                System.out.println(jvA22DiseaseProjTotalVo);
                            }
                        }

                    }
                }
            }

        }
        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        System.out.println(json);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jvA22DiseaseProjTotal", json, null, null, 50000, 50000, null);
    }

    @Override
    public void JV313DiseaseYear() throws Exception {
        //病害总数
        ArrayList<JV313DiseaseYearVo> vos = new ArrayList<>();
        //查询病害分类
        List<Map<String, Object>> diseaseTypeList = this.pushTaskMapper.selectDiseaseTypeList();
        for (Map<String, Object> map : diseaseTypeList) {
            JV313DiseaseYearVo diseaseYearVo = new JV313DiseaseYearVo();
            //组织编码
            String orgCode = (String) map.get("orgCode");
            //组织名称
            String orgName = (String) map.get("orgName");
            //病害分类名称
            String diseaseName = (String) map.get("diseaseName");
            //分类数量
            Number accNums = (Number) map.get("accNums");
            //年份
            String accDate = String.valueOf(map.get("accDate"));
            diseaseYearVo.setOrgCode(orgCode);
            diseaseYearVo.setOrgName(orgName);
            diseaseYearVo.setDiseaseName(diseaseName);
            diseaseYearVo.setAccNums(accNums);
            diseaseYearVo.setAccDate(accDate);
            vos.add(diseaseYearVo);
        }
        System.out.println(vos);
        for (JV313DiseaseYearVo vo : vos) {
            if(null != vo.getOrgCode() && null != vo.getDiseaseName() && null != vo.getAccDate()){
                String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv313DiseaseYear" + "?orgCode=" + vo.getOrgCode() + "&" + "diseaseName=" + getURLEncoderString(vo.getDiseaseName()) + "&" + "accDate=" + vo.getAccDate());
                if (null != json) {
                    List<Object> list = getClazz(json, JV313DiseaseYearVo.class);
                    JV313DiseaseYearVo jv313DiseaseYearVo = null;
                    if (list.size() > 0) {
//                    Object o = list.get(0);
                        for (Object o : list) {
                            ObjectMapper objectMapper = new ObjectMapper();
                            jv313DiseaseYearVo = objectMapper.convertValue(o, JV313DiseaseYearVo.class);

                            if (jv313DiseaseYearVo != null && jv313DiseaseYearVo.getOrgCode().equals(vo.getOrgCode()) && jv313DiseaseYearVo.getAccDate().equals(vo.getAccDate()) &&
                                    jv313DiseaseYearVo.getDiseaseName().equals(vo.getDiseaseName())) {
                                vo.setId(jv313DiseaseYearVo.getId());
                                System.out.println(jv313DiseaseYearVo);
                            }
                        }
                    }
                }
            }


        }

        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        System.out.println(json);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv313DiseaseYear", json, null, null, 50000, 50000, null);
    }

    @Override
    public void JV313Disease() throws Exception {
        //病害总数
        ArrayList<JV313DiseaseYearVo> vos = new ArrayList<>();
        //查询病害分类
        List<Map<String, Object>> diseaseTypeList = this.pushTaskMapper.selectDiseaseTypeMouthList();
        for (Map<String, Object> map : diseaseTypeList) {
            JV313DiseaseYearVo diseaseYearVo = new JV313DiseaseYearVo();
            //组织编码
            String orgCode = (String) map.get("orgCode");
            //组织名称
            String orgName = (String) map.get("orgName");
            //病害分类名称
            String diseaseName = (String) map.get("diseaseName");
            //分类数量
            Number accNums = (Number) map.get("accNums");
            //年份
            String accDate = String.valueOf(map.get("accDate"));
            diseaseYearVo.setOrgCode(orgCode);
            diseaseYearVo.setOrgName(orgName);
            diseaseYearVo.setDiseaseName(diseaseName);
            diseaseYearVo.setAccNums(accNums);
            diseaseYearVo.setAccDate(accDate);
            vos.add(diseaseYearVo);
        }
        System.out.println(vos);
        for (JV313DiseaseYearVo vo : vos) {
            if(null != vo.getOrgCode() && null != vo.getDiseaseName() && null != vo.getAccDate()){
                String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv313Disease" + "?orgCode=" + vo.getOrgCode() + "&" + "diseaseName=" + getURLEncoderString(vo.getDiseaseName()) + "&" + "accDate=" + vo.getAccDate());
                if (null != json) {
                    List<Object> list = getClazz(json, JV313DiseaseYearVo.class);
                    JV313DiseaseYearVo jv313DiseaseYearVo = null;
                    if (list.size() > 0) {
//                    Object o = list.get(0);
                        for (Object o : list) {
                            ObjectMapper objectMapper = new ObjectMapper();
                            jv313DiseaseYearVo = objectMapper.convertValue(o, JV313DiseaseYearVo.class);

                            if (jv313DiseaseYearVo != null && jv313DiseaseYearVo.getOrgCode().equals(vo.getOrgCode()) && jv313DiseaseYearVo.getAccDate().equals(vo.getAccDate()) &&
                                    jv313DiseaseYearVo.getDiseaseName().equals(vo.getDiseaseName())) {
                                vo.setId(jv313DiseaseYearVo.getId());
                                System.out.println(jv313DiseaseYearVo);
                            }
                        }
                    }
                }
            }
        }
        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        System.out.println(json);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv313Disease", json, null, null, 50000, 50000, null);
    }


    //病害统计数据推送接口
    @Override
    public void diseaseCount() throws Exception {
        //查询所有路段
        List<Road> roadList = this.pushTaskMapper.selectRoadInformationList();
        List<DiseaseCountVo> vos = new ArrayList<>();
        for (Road road : roadList) {
            DiseaseCountVo diseaseCountVo = new DiseaseCountVo();
            diseaseCountVo.setName(road.getName());
            diseaseCountVo.setCode(road.getCode());
            //查询病害统计
            List<Map<String, Object>> diseaseCount = this.pushTaskMapper.diseaseCount();

            for (Map<String, Object> map : diseaseCount) {
                if (map.get("code").toString().equals(road.getCode())) {
                    //路段名称
                    String name = map.get("name").toString();
                    //路段code
                    String code = map.get("code").toString();
                    //已完成病害数量 (所有病害) diseaseDoneCount
                    Integer diseaseDoneCount = Integer.valueOf(map.get("diseaseDoneCount").toString());
                    //已维修病害数量 （已经处理了的）
                    Integer diseaseRepairCount = Integer.valueOf(map.get("diseaseRepairCount").toString());
                    //暂存病害数量
                    Integer diseaseExistCount = Integer.valueOf(map.get("diseaseExistCount").toString());


                    diseaseCountVo.setDiseaseDoneCount(diseaseDoneCount);
                    diseaseCountVo.setDiseaseRepairCount(diseaseRepairCount);
                    diseaseCountVo.setDiseaseExistCount(diseaseExistCount);
                    diseaseCountVo.setCode(code);
                    diseaseCountVo.setName(name);
                    Date date = new Date();
                    String format = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    diseaseCountVo.setReport_date(format);
                    vos.add(diseaseCountVo);
                }
            }
        }
        System.out.println("病害统计数据推送接口");
        System.out.println(vos);
        for (DiseaseCountVo vo : vos) {

            String json = JsonUtil.toJsonString(vo);

            HttpUtil.postJson("http://183.64.175.153:28880/user/charge/diseaseCount", json, null, null, 50000, 50000, null);


        }

    }

    @Override
    public void jv312ConstructFinnishYear() throws Exception {

        ArrayList<JV312CONSTRUCTFINNISHYEARVo> vos = new ArrayList<>();
        List<Map<String, Object>> selectWorkeCount = this.pushTaskMapper.selectWorkeCount();

        for (Map<String, Object> map : selectWorkeCount) {
            JV312CONSTRUCTFINNISHYEARVo jv312CONSTRUCTFINNISHYEARVo = new JV312CONSTRUCTFINNISHYEARVo();
            //年份
            Object accDateObject = map.get("accDate");

            if (ObjectUtils.isNotEmpty(accDateObject)) {
                String accDate = accDateObject.toString();
                //组织编码
                String orgCode = (String) map.get("orgCode");
                //组织名称
                String orgName = (String) map.get("orgName");

                //已完成数量
                String finNums = map.get("finNums").toString();
                String companyId = (String) map.get("companyId");
                //查询今年所有工单数量
                Map<String, Object> all = this.pushTaskMapper.selectWorkeYearAllCount(companyId, accDate);
                String totalNums = all.get("totalNums").toString();
                jv312CONSTRUCTFINNISHYEARVo.setOrgCode(orgCode);
                jv312CONSTRUCTFINNISHYEARVo.setOrgName(orgName);
                jv312CONSTRUCTFINNISHYEARVo.setFinNums(finNums);
                jv312CONSTRUCTFINNISHYEARVo.setTotalNums(totalNums);
                jv312CONSTRUCTFINNISHYEARVo.setAccDate(accDate);
                vos.add(jv312CONSTRUCTFINNISHYEARVo);
            }
        }
        for (JV312CONSTRUCTFINNISHYEARVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv312ConstructFinnishYear" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, JV312CONSTRUCTFINNISHYEARVo.class);
            JV312CONSTRUCTFINNISHYEARVo jv312CONSTRUCTFINNISHYEARVo = null;
            if (list.size() > 0) {
//                Object o = list.get(0);
                for (Object o : list) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    jv312CONSTRUCTFINNISHYEARVo = objectMapper.convertValue(o, JV312CONSTRUCTFINNISHYEARVo.class);

                    if (jv312CONSTRUCTFINNISHYEARVo != null && jv312CONSTRUCTFINNISHYEARVo.getOrgCode().equals(vo.getOrgCode()) && jv312CONSTRUCTFINNISHYEARVo.getAccDate().equals(vo.getAccDate())) {
                        vo.setId(jv312CONSTRUCTFINNISHYEARVo.getId());
                    }
                }
            }
        }
        System.out.println(vos);
        if (vos.size() > 0) {
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            System.out.println(json);
            HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv312ConstructFinnishYear", json, null, null, 50000, 50000, null);
        }
    }

    @Override
    public void jv312ConstructFinnish() throws Exception {
        ArrayList<JV312CONSTRUCTFINNISHVo> vos = new ArrayList<>();

        List<Map<String, Object>> selectWorkeMounthCount = this.pushTaskMapper.selectWorkeMonthCount();

        for (Map<String, Object> map : selectWorkeMounthCount) {
            JV312CONSTRUCTFINNISHVo jv312CONSTRUCTFINNISHYEARVo = new JV312CONSTRUCTFINNISHVo();
            //年份
            Object accDateObject = map.get("accDate");

            if (ObjectUtils.isNotEmpty(accDateObject)) {
                String accDate = accDateObject.toString();
                //组织编码
                String orgCode = (String) map.get("orgCode");
                //组织名称
                String orgName = (String) map.get("orgName");

                //已完成数量
                String finNums = map.get("finNums").toString();
                String companyId = (String) map.get("companyId");
                //查询月份所有工单数量
                Map<String, Object> all = this.pushTaskMapper.selectWorkeMonthAllCount(companyId, accDate);
                String totalNums = all.get("totalNums").toString();
                jv312CONSTRUCTFINNISHYEARVo.setOrgCode(orgCode);
                jv312CONSTRUCTFINNISHYEARVo.setOrgName(orgName);
                jv312CONSTRUCTFINNISHYEARVo.setFinNums(finNums);
                jv312CONSTRUCTFINNISHYEARVo.setTotalNums(totalNums);
                jv312CONSTRUCTFINNISHYEARVo.setAccDate(accDate);
                vos.add(jv312CONSTRUCTFINNISHYEARVo);
            }
        }
        for (JV312CONSTRUCTFINNISHVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv312ConstructFinnish" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, JV312CONSTRUCTFINNISHVo.class);
            JV312CONSTRUCTFINNISHVo jv312CONSTRUCTFINNISHVo = null;
            if (list.size() > 0) {
//                Object o = list.get(0);
                for (Object o : list) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    jv312CONSTRUCTFINNISHVo = objectMapper.convertValue(o, JV312CONSTRUCTFINNISHVo.class);

                    if (jv312CONSTRUCTFINNISHVo != null && jv312CONSTRUCTFINNISHVo.getOrgCode().equals(vo.getOrgCode()) && jv312CONSTRUCTFINNISHVo.getAccDate().equals(vo.getAccDate())) {
                        vo.setId(jv312CONSTRUCTFINNISHVo.getId());
                    }
                }
            }
        }
        System.out.println(vos);
        if (vos.size() > 0) {
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            System.out.println(json);
            HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv312ConstructFinnish", json, null, null, 50000, 50000, null);
        }
    }

    @Override
    public void jv314DiseaseRatioYear() throws Exception {
        ArrayList<Jv314DiseaseRatioYearVo> vos = new ArrayList<>();

        //按照年份来查找病害
        List<Map<String, Object>> avgDiseaseYear = this.pushTaskMapper.selectAvgDiseaseYear();
        for (Map<String, Object> map : avgDiseaseYear) {
            Jv314DiseaseRatioYearVo jv314DiseaseRatioYearVo = new Jv314DiseaseRatioYearVo();
            Object orgCode = map.get("orgCode");
            Object orgName = map.get("orgName");
            Object accDate = map.get("accDate");
            Object allDays = map.get("allDays");
            Object diseaseCount = map.get("diseaseCount");
            if(null != allDays && null !=diseaseCount){
                Integer days = Integer.valueOf(allDays.toString());

                Integer count = Integer.valueOf(diseaseCount.toString());
                int avgDays = days / count;
                jv314DiseaseRatioYearVo.setRatio(String.valueOf(avgDays));
            }else {
                jv314DiseaseRatioYearVo.setRatio("0");
            }



            jv314DiseaseRatioYearVo.setOrgCode(orgCode.toString());
            jv314DiseaseRatioYearVo.setOrgName(orgName.toString());
            if(null != accDate){
                jv314DiseaseRatioYearVo.setAccDate(accDate.toString());
            }


            vos.add(jv314DiseaseRatioYearVo);
        }
        for (Jv314DiseaseRatioYearVo vo : vos) {
            if(null != vo.getOrgCode()  && null != vo.getAccDate()){
                String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv314DiseaseRatioYear" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
                List<Object> list = getClazz(json, Jv314DiseaseRatioYearVo.class);
                for (Object o : list) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    Jv314DiseaseRatioYearVo jv314DiseaseRatioYearVo = objectMapper.convertValue(o, Jv314DiseaseRatioYearVo.class);

                    if (jv314DiseaseRatioYearVo != null && jv314DiseaseRatioYearVo.getOrgCode().equals(vo.getOrgCode()) && jv314DiseaseRatioYearVo.getAccDate().equals(vo.getAccDate())) {
                        vo.setId(jv314DiseaseRatioYearVo.getId());
                    }
                }
            }

        }

        System.out.println(vos);
        if (vos.size()>0){
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            HttpUtil.postJson(host +"/server-cockpitv/cockpitv/jv314DiseaseRatioYear",json, null, null, 50000, 50000, null);
        }
    }

    @Override
    public void jv314DiseaseRatio() throws Exception {
        ArrayList<Jv314DiseaseRatioVo> vos = new ArrayList<>();

        //按照年份来查找病害
        List<Map<String, Object>> avgDisease = this.pushTaskMapper.selectAvgDisease();
        for (Map<String, Object> map : avgDisease) {
            Jv314DiseaseRatioVo jv314DiseaseRatioVo = new Jv314DiseaseRatioVo();
            Object orgCode = map.get("orgCode");
            Object orgName = map.get("orgName");
            Object accDate = map.get("accDate");
            Object allDays = map.get("allDays");
            Object diseaseCount = map.get("diseaseCount");

            if(null != allDays && null != diseaseCount){
                Integer days = Integer.valueOf(allDays.toString());
                Integer count = Integer.valueOf(diseaseCount.toString());
                int avgDays = days / count;
                jv314DiseaseRatioVo.setRatio(String.valueOf(avgDays));
            }else {
                jv314DiseaseRatioVo.setRatio(String.valueOf("0"));
            }

            jv314DiseaseRatioVo.setOrgCode(orgCode.toString());
            jv314DiseaseRatioVo.setOrgName(orgName.toString());
            if(null !=accDate){
                jv314DiseaseRatioVo.setAccDate(accDate.toString());
            }


            vos.add(jv314DiseaseRatioVo);
        }


        for (Jv314DiseaseRatioVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv312ConstructFinnish" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, Jv314DiseaseRatioVo.class);
            for (Object o : list) {
                ObjectMapper objectMapper = new ObjectMapper();
                Jv314DiseaseRatioVo jv314DiseaseRatioVo = objectMapper.convertValue(o, Jv314DiseaseRatioVo.class);

                if (jv314DiseaseRatioVo != null && jv314DiseaseRatioVo.getOrgCode().equals(vo.getOrgCode()) && jv314DiseaseRatioVo.getAccDate().equals(vo.getAccDate())) {
                    vo.setId(jv314DiseaseRatioVo.getId());
                }
            }
        }
        if (vos.size()>0) {
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            System.out.println(json);
            HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv314DiseaseRatio", json, null, null, 50000, 50000, null);
        }
    }

    @Override
    public void jv36ProjectProgressYear() throws Exception {
        //年养护金额
        List<Map<String, Object>> projectProgressYear = this.pushTaskMapper.selectProjectProgressYear();
        ArrayList<JV36PROJECTPROGRESSYEARVo> vos = new ArrayList<>();
        for (Map<String, Object> map : projectProgressYear) {
            JV36PROJECTPROGRESSYEARVo jv36PROJECTPROGRESSYEARVo = new JV36PROJECTPROGRESSYEARVo();
            Object orgCode = map.get("orgCode");
            Object orgName = map.get("orgName");
            Object accDate = map.get("accDate");
            Object amount = map.get("amount");
            Object paiedAmount = map.get("paiedAmount");
            jv36PROJECTPROGRESSYEARVo.setOrgCode(orgCode.toString());
            jv36PROJECTPROGRESSYEARVo.setOrgName(orgName.toString());
            jv36PROJECTPROGRESSYEARVo.setAccDate(accDate.toString());
            jv36PROJECTPROGRESSYEARVo.setAmount(amount.toString());
            jv36PROJECTPROGRESSYEARVo.setPaiedAmount(paiedAmount.toString());
            vos.add(jv36PROJECTPROGRESSYEARVo);
        }
        System.out.println(vos);
        for (JV36PROJECTPROGRESSYEARVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv36ProjectProgressYear" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, JV36PROJECTPROGRESSYEARVo.class);
            for (Object o : list) {
                ObjectMapper objectMapper = new ObjectMapper();
                JV36PROJECTPROGRESSYEARVo jv36PROJECTPROGRESSYEARVo = objectMapper.convertValue(o, JV36PROJECTPROGRESSYEARVo.class);

                if (jv36PROJECTPROGRESSYEARVo != null && jv36PROJECTPROGRESSYEARVo.getOrgCode().equals(vo.getOrgCode()) && jv36PROJECTPROGRESSYEARVo.getAccDate().equals(vo.getAccDate())) {
                    vo.setId(jv36PROJECTPROGRESSYEARVo.getId());
                }
            }
        }
        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        System.out.println(json);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv36ProjectProgressYear", json, null, null, 50000, 50000, null);
    }

    @Override
    public void jv36ProjectProgress() throws Exception {
        //月养护金额
        List<Map<String, Object>> projectProgress = this.pushTaskMapper.selectProjectProgress();
        ArrayList<JV36PROJECTPROGRESSVo> vos = new ArrayList<>();
        for (Map<String, Object> map : projectProgress) {
            JV36PROJECTPROGRESSVo jv36PROJECTPROGRESSVo = new JV36PROJECTPROGRESSVo();
            Object orgCode = map.get("orgCode");
            Object orgName = map.get("orgName");
            Object accDate = map.get("accDate");
            Object amount = map.get("amount");
            Object paiedAmount = map.get("paiedAmount");
            jv36PROJECTPROGRESSVo.setOrgCode(orgCode.toString());
            jv36PROJECTPROGRESSVo.setOrgName(orgName.toString());
            jv36PROJECTPROGRESSVo.setAccDate(accDate.toString());
            jv36PROJECTPROGRESSVo.setAmount(amount.toString());
            jv36PROJECTPROGRESSVo.setPaiedAmount(paiedAmount.toString());
            vos.add(jv36PROJECTPROGRESSVo);
        }
        System.out.println(vos);
        for (JV36PROJECTPROGRESSVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv36ProjectProgress" + "?orgCode=" + vo.getOrgCode() + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, JV36PROJECTPROGRESSVo.class);
            for (Object o : list) {
                ObjectMapper objectMapper = new ObjectMapper();
                JV36PROJECTPROGRESSVo jv36PROJECTPROGRESSVo = objectMapper.convertValue(o, JV36PROJECTPROGRESSVo.class);

                if (jv36PROJECTPROGRESSVo != null && jv36PROJECTPROGRESSVo.getOrgCode().equals(vo.getOrgCode()) && jv36PROJECTPROGRESSVo.getAccDate().equals(vo.getAccDate())) {
                    vo.setId(jv36PROJECTPROGRESSVo.getId());
                }
            }
        }
        ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
        String json = JsonUtil.toJson(jsonNodes);
        System.out.println(json);
        HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv36ProjectProgress", json, null, null, 50000, 50000, null);

    }

    @Override
    public void jv35ProjectTypeYear() throws Exception {
        List<Org> orgs = companyDao.getOrgsByparentId(parentId);
        ArrayList<Jv35ProjectTypeYearVo> vos = new ArrayList<>();

        List<Map<String, Object>> jv35ProjectTypeYear = this.pushTaskMapper.selectjv35ProjectTypeYear();
        if (jv35ProjectTypeYear.size() > 0) {
            for (Map<String, Object> map : jv35ProjectTypeYear) {
                for (int i = 1; i < 5; i++) {
                    Jv35ProjectTypeYearVo vo = new Jv35ProjectTypeYearVo();
                    Object orgCode = map.get("orgCode");
                    Object orgName = map.get("orgName");
                    Object accDate = map.get("accDate");
                    Object countNums = map.get("type" + i);
                    vo.setOrgCode(orgCode.toString());
                    vo.setOrgName(orgName.toString());
                    vo.setAccDate(accDate.toString());
                    vo.setCountNums(countNums.toString());
                    if (i==1){
                        vo.setMajorType("派单项目");
                    }
                    if (i==2){
                        vo.setMajorType("包干项目");
                    }
                    if (i==3){
                        vo.setMajorType("抢险");
                    }
                    if (i==4){
                        vo.setMajorType("日常");
                    }
                    vos.add(vo);
                }
            }
        }

        for (Jv35ProjectTypeYearVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv35ProjectTypeYear" + "?orgCode=" + vo.getOrgCode() + "&" + "diseaseName=" + getURLEncoderString(vo.getMajorType()) + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, Jv35ProjectTypeYearVo.class);
            for (Object o : list) {
                ObjectMapper objectMapper = new ObjectMapper();
                Jv35ProjectTypeYearVo jv35ProjectTypeYearVo = objectMapper.convertValue(o, Jv35ProjectTypeYearVo.class);

                if (jv35ProjectTypeYearVo != null && jv35ProjectTypeYearVo.getOrgCode().equals(vo.getOrgCode()) && jv35ProjectTypeYearVo.getAccDate().equals(vo.getAccDate())) {
                    vo.setId(jv35ProjectTypeYearVo.getId());
                }
            }
        }

        if (vos.size()>0){
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            System.out.println(json);
            HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv35ProjectTypeYear", json, null, null, 50000, 50000, null);
        }


    }

    @Override
    public void jv35ProjectType() throws Exception {
        ArrayList<Jv35ProjectTypeVo> vos = new ArrayList<>();

        List<Map<String, Object>> jv35ProjectType = this.pushTaskMapper.selectjv35ProjectType();
        if (jv35ProjectType.size() > 0) {
            for (Map<String, Object> map : jv35ProjectType) {
                for (int i = 1; i < 5; i++) {
                    Jv35ProjectTypeVo vo = new Jv35ProjectTypeVo();
                    Object orgCode = map.get("orgCode");
                    Object orgName = map.get("orgName");
                    Object accDate = map.get("accDate");
                    Object countNums = map.get("type" + i);
                    vo.setOrgCode(orgCode.toString());
                    vo.setOrgName(orgName.toString());
                    vo.setAccDate(accDate.toString());
                    vo.setCountNums(countNums.toString());
                    if (i==1){
                        vo.setMajorType("派单项目");
                    }
                    if (i==2){
                        vo.setMajorType("包干项目");
                    }
                    if (i==3){
                        vo.setMajorType("抢险");
                    }
                    if (i==4){
                        vo.setMajorType("日常");
                    }
                    vos.add(vo);
                }
            }
        }

        for (Jv35ProjectTypeVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jv35ProjectType" + "?orgCode=" + vo.getOrgCode() + "&" + "diseaseName=" + getURLEncoderString(vo.getMajorType()) + "&" + "accDate=" + vo.getAccDate());
            List<Object> list = getClazz(json, Jv35ProjectTypeVo.class);
            for (Object o : list) {
                ObjectMapper objectMapper = new ObjectMapper();
                Jv35ProjectTypeYearVo jv35ProjectTypeYearVo = objectMapper.convertValue(o, Jv35ProjectTypeYearVo.class);

                if (jv35ProjectTypeYearVo != null && jv35ProjectTypeYearVo.getOrgCode().equals(vo.getOrgCode()) && jv35ProjectTypeYearVo.getAccDate().equals(vo.getAccDate())) {
                    vo.setId(jv35ProjectTypeYearVo.getId());
                }
            }
        }

        if (vos.size()>0){
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            System.out.println(json);
            HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jv35ProjectType", json, null, null, 50000, 50000, null);
        }
    }

    @Override
    public void jVA2113MAINTAIN() throws Exception {
        //查询日常养护计费(万元)
        List<Map<String, Object>> conserveMoney = this.pushTaskMapper.selectConserveMoney();
        //专项养护项目计费金额(万元)
        List<Map<String, Object>> specialMoney = this.pushTaskMapper.selectSpecialMoney();
        ArrayList<JVA2113MAINTAINVo> vos = new ArrayList<>();
        for (Map<String, Object> map : conserveMoney) {
            JVA2113MAINTAINVo jva2113MAINTAINVo = new JVA2113MAINTAINVo();
            Object orgCode = map.get("orgCode");
            Object orgName = map.get("orgName");
            Object accYear = map.get("accYear");
            Object totalNums = map.get("conserveMoney");
            jva2113MAINTAINVo.setAccYear(accYear.toString());
            jva2113MAINTAINVo.setOrgCode(orgCode.toString());
            jva2113MAINTAINVo.setOrgName(orgName.toString());
            jva2113MAINTAINVo.setTotalNums(totalNums.toString());
            jva2113MAINTAINVo.setPrgName("日常养护计费");
            vos.add(jva2113MAINTAINVo);
        }
        for (Map<String, Object> map : specialMoney) {
            JVA2113MAINTAINVo jva2113MAINTAINVo = new JVA2113MAINTAINVo();
            Object orgCode = map.get("orgCode");
            Object orgName = map.get("orgName");
            Object accYear = map.get("accYear");
            Object totalNums = map.get("specialMoney");
            jva2113MAINTAINVo.setAccYear(accYear.toString());
            jva2113MAINTAINVo.setOrgCode(orgCode.toString());
            jva2113MAINTAINVo.setOrgName(orgName.toString());
            jva2113MAINTAINVo.setTotalNums(totalNums.toString());
            jva2113MAINTAINVo.setPrgName("专项养护项目计费");
            vos.add(jva2113MAINTAINVo);
        }
        for (JVA2113MAINTAINVo vo : vos) {
            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jvA2113Maintain" + "?orgCode=" + vo.getOrgCode() + "&" + "accYear=" + vo.getAccYear());
            List<Object> list = getClazz(json, JVA2113MAINTAINVo.class);
            for (Object o : list) {
                ObjectMapper objectMapper = new ObjectMapper();
                JVA2113MAINTAINVo jva2113MAINTAINVo = objectMapper.convertValue(o, JVA2113MAINTAINVo.class);

                if (jva2113MAINTAINVo != null && jva2113MAINTAINVo.getOrgCode().equals(vo.getOrgCode()) && jva2113MAINTAINVo.getAccYear().equals(vo.getAccYear()) ) {
                    vo.setId(jva2113MAINTAINVo.getId());
                }
            }
        }

        //目前没有月份
//        for (JVA2113MAINTAINVo vo : vos) {
//            String json = HttpUtil.get(host + "/server-cockpitv/cockpitv/jvA2113Maintain" + "?orgCode=" + vo.getOrgCode() + "&" + "accYear=" + vo.getAccYear() + "&" + "lastMonth=" + vo.getLastMonth());
//            List<Object> list = getClazz(json, JVA2113MAINTAINVo.class);
//            for (Object o : list) {
//                ObjectMapper objectMapper = new ObjectMapper();
//                JVA2113MAINTAINVo jva2113MAINTAINVo = objectMapper.convertValue(o, JVA2113MAINTAINVo.class);
//
//                if (jva2113MAINTAINVo != null && jva2113MAINTAINVo.getOrgCode().equals(vo.getOrgCode()) && jva2113MAINTAINVo.getAccYear().equals(vo.getAccYear()) && jva2113MAINTAINVo.getLastMonth().equals(vo.getLastMonth())) {
//                    vo.setId(jva2113MAINTAINVo.getId());
//                }
//            }
//        }

        if (vos.size()>0){
            ArrayNode jsonNodes = JsonUtil.listToArrayNode(vos);
            String json = JsonUtil.toJson(jsonNodes);
            System.out.println(json);
            HttpUtil.postJson(host + "/server-cockpitv/cockpitv/jvA2113Maintain", json, null, null, 50000, 50000, null);
        }
    }


    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("orgCode", "101");
        map.put("diseaseName", "%E4%BC%B8%E7%BC%A9%E7%BC%9D%20%E6%B7%B7%E5%87%9D%E5%9C%9F%E7%A0%B4%E6%8D%9F");
        map.put("accDate", "2021");
        System.out.println(getURLEncoderString("伸缩缝混凝土破损"));
        String s = HttpUtil.get("http://36.110.47.222:10012/server-cockpitv/cockpitv/jv313DiseaseYear", map);


        System.out.println(s);
    }

    /**
     * json转 object对象
     *
     * @param json
     * @param clazz
     * @return
     * @throws Exception
     */
    public List<Object> getClazz(String json, Class clazz) throws Exception {
        List<Object> list = new ArrayList<>();
        PushQueryVo pushQueryVo = JsonUtil.toBean(json, PushQueryVo.class);
        List<Object> msgContent = pushQueryVo.getMsgContent();
        for (Object o : msgContent) {
            System.out.println(o);
            ObjectMapper objectMapper = new ObjectMapper();
            Object object = objectMapper.convertValue(o, clazz);
            list.add(object);
        }
        return list;
    }


    /**
     * url 中对中文进行转码
     *
     * @param str
     * @return
     */
    public static String getURLEncoderString(String str) {
        String result = "";
        if (null == str) {
            return "";
        }
        try {
            result = java.net.URLEncoder.encode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String URLDecoderString(String str) {
        String result = "";
        if (null == str) {
            return "";
        }
        try {
            result = java.net.URLDecoder.decode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }


}
