package com.artfess.yhxt.check.regular.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;

import com.baomidou.mybatisplus.annotation.TableId;

import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 涵洞经常检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-05
 */
@ApiModel(value="BizCulvertOftenCheck对象", description="涵洞经常检查表")
@TableName("BIZ_CULVERT_OFTEN_CHECK")
public class CulvertOftenCheck extends BizModel<CulvertOftenCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "涵洞id")
    @TableField("CULVERT_ID_")
    private String culvertId;

    @ApiModelProperty(value = "涵洞名称")
    @TableField("CULVERT_NAME_")
    private String culvertName;

    @ApiModelProperty(value = "检查人")
    @TableField("RUMMAGER_")
    private String rummager;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkDate;

    @ApiModelProperty(value = "记录人")
    @TableField("NOTE_TAKER_")
    private String noteTaker;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    @ApiModelProperty(value = "总体评价")
    @TableField("EVALUATE_")
    private String evaluate;

    @ApiModelProperty(value = "总体评价值")
    @TableField("EVALUATE_VALUE_")
    private String evaluateValue;

    @ApiModelProperty(value = "天气值")
    @TableField("WEATHER_VALUE_")
    private String weatherValue;

    @ApiModelProperty(value = "检查明细")
    @TableField("CHECK_DETAIL_JSON_")
    private String checkDetailJson;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getCulvertId() {
        return culvertId;
    }

    public void setCulvertId(String culvertId) {
        this.culvertId = culvertId;
    }
    public String getCulvertName() {
        return culvertName;
    }

    public void setCulvertName(String culvertName) {
        this.culvertName = culvertName;
    }
    public String getRummager() {
        return rummager;
    }

    public void setRummager(String rummager) {
        this.rummager = rummager;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getNoteTaker() {
        return noteTaker;
    }

    public void setNoteTaker(String noteTaker) {
        this.noteTaker = noteTaker;
    }
    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }
    public String getEvaluate() {
        return evaluate;
    }

    public void setEvaluate(String evaluate) {
        this.evaluate = evaluate;
    }
    public String getEvaluateValue() {
        return evaluateValue;
    }

    public void setEvaluateValue(String evaluateValue) {
        this.evaluateValue = evaluateValue;
    }
    public String getWeatherValue() {
        return weatherValue;
    }

    public void setWeatherValue(String weatherValue) {
        this.weatherValue = weatherValue;
    }
    public String getCheckDetailJson() {
        return checkDetailJson;
    }

    public void setCheckDetailJson(String checkDetailJson) {
        this.checkDetailJson = checkDetailJson;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizCulvertOftenCheck{" +
            "id=" + id +
            ", remarks=" + remarks +
            ", culvertId=" + culvertId +
            ", culvertName=" + culvertName +
            ", rummager=" + rummager +
            ", checkDate=" + checkDate +
            ", noteTaker=" + noteTaker +
            ", weather=" + weather +
            ", evaluate=" + evaluate +
            ", evaluateValue=" + evaluateValue +
            ", weatherValue=" + weatherValue +
            ", checkDetailJson=" + checkDetailJson +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
