package com.artfess.yhxt.check.regular.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.vo.BridgeOftenCheckVo;
import com.artfess.yhxt.check.regular.vo.CheckReportVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import org.springframework.web.multipart.MultipartFile;

/**
 * 桥梁经常检查表 服务类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-03
 */
public interface BridgeOftenCheckManager extends BaseManager<BridgeOftenCheck> {

    /**
     * 分页查询
     *
     * @param queryFilter
     * @return
     */
    PageList<BridgeOftenCheck> queryBridgeOftenCheck(QueryFilter<BridgeOftenCheck> queryFilter);

    /**
     * 保存桥梁经常检查和明细
     *
     * @param vo
     */
    void saveBridgeOftenCheck(BridgeOftenCheckVo vo);

    /**
     * 修改桥梁经常检查和明细
     *
     * @param vo
     */
    void updateBridgeOftenCheck(BridgeOftenCheckVo vo);

    /**
     * 根据id查询桥梁经常检查和明细
     *
     * @param id
     * @return
     */
    BridgeOftenCheckVo getBridgeOftenCheckById(String id);

    void importExcelData(MultipartFile file, BridgeOftenCheck main);

    List<CheckReportVO> checkReport(String year,String orgId);
}
