package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 养护车辆管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-05
 */
@ApiModel(value="BizVehicle对象", description="养护车辆管理")
@TableName("biz_vehicle")
@Data
public class BizVehicle extends BizModel<BizVehicle> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "车牌")
    @TableField("CAR_NUMBER_")
    private String carNumber;

    @ApiModelProperty(value = "别名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "车辆品牌")
    @TableField("CAR_BRAND_")
    private String carBrand;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "所属公司NAME")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "所属部门ID")
    @TableField("DEP_ID_")
    private String depId;

    @ApiModelProperty(value = "所属部门NAME")
    @TableField("DEP_NAME_")
    private String depName;

    @ApiModelProperty(value = "车辆型号")
    @TableField("CAR_TYPE_")
    private String carType;

    @ApiModelProperty(value = "燃油类型")
    @TableField("FUEL_TYPE_")
    private String fuelType;

    @ApiModelProperty(value = "车架号")
    @TableField("FRAME_NUMBER_")
    private String frameNumber;

    @ApiModelProperty(value = "发动机编号")
    @TableField("ENGINE_NUMBER_")
    private String engineNumber;

    @ApiModelProperty(value = "车辆油/气耗")
    @TableField("FUEL_CONSUMPTION_")
    private Double fuelConsumption;

    @ApiModelProperty(value = "座位数")
    @TableField("SEATS_NUMBER_")
    private Integer seatsNumber;

    @ApiModelProperty(value = "载重(吨)")
    @TableField("CAR_LOAD_")
    private Double carLoad;

    @ApiModelProperty(value = "颜色")
    @TableField("CAR_COLOUR_")
    private String carColour;

    @ApiModelProperty(value = "购买时间")
    @TableField("BUY_DATE_")
    private LocalDate buyDate;

    @ApiModelProperty(value = "车辆管理员(选择人员)")
    @TableField("CAR_DRIVER_ID_")
    private String carDriverId;

    @ApiModelProperty(value = "车辆管理员NAME")
    @TableField("CAR_DRIVER_NAME_")
    private String carDriverName;

    @ApiModelProperty(value = "行驶证照片URL")
    @TableField("DRIVING_LICENSE__")
    private String drivingLicense;

    @ApiModelProperty(value = "照片侧面照片URL")
    @TableField("CAR_SIDE_PHOTO_URL_")
    private String carSidePhotoUrl;

    @ApiModelProperty(value = "车辆正面照片URL")
    @TableField("CAR_BEFORE_PHOTO_URL_")
    private String carBeforePhotoUrl;

    @ApiModelProperty(value = "照片后面照片URL")
    @TableField("CAR_AFTER_PHOTO_URL_")
    private String carAfterPhotoUrl;

    @ApiModelProperty(value = "网络运营商,下拉框，做成枚举字典，1：移动，2：电信，3：联通，4：其他")
    @TableField("OPERATORS_")
    private String operators;

    @ApiModelProperty(value = "SIM卡号")
    @TableField("SIM_NUMBER_")
    private String simNumber;

    @ApiModelProperty(value = "ICCID")
    @TableField("ICCID_")
    private String iccid;

    @ApiModelProperty(value = "IMSI")
    @TableField("IMSI_")
    private String imsi;

    @ApiModelProperty(value = "APAN")
    @TableField("APAN_")
    private String apan;

    @ApiModelProperty(value = "REMARKS")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "所属")
    @TableField("TYPE_")
    private Integer type;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCarNumber() {
        return carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getCarBrand() {
        return carBrand;
    }

    public void setCarBrand(String carBrand) {
        this.carBrand = carBrand;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getDepId() {
        return depId;
    }

    public void setDepId(String depId) {
        this.depId = depId;
    }
    public String getDepName() {
        return depName;
    }

    public void setDepName(String depName) {
        this.depName = depName;
    }
    public String getCarType() {
        return carType;
    }

    public void setCarType(String carType) {
        this.carType = carType;
    }
    public String getFuelType() {
        return fuelType;
    }

    public void setFuelType(String fuelType) {
        this.fuelType = fuelType;
    }
    public String getFrameNumber() {
        return frameNumber;
    }

    public void setFrameNumber(String frameNumber) {
        this.frameNumber = frameNumber;
    }
    public String getEngineNumber() {
        return engineNumber;
    }

    public void setEngineNumber(String engineNumber) {
        this.engineNumber = engineNumber;
    }
    public Double getFuelConsumption() {
        return fuelConsumption;
    }

    public void setFuelConsumption(Double fuelConsumption) {
        this.fuelConsumption = fuelConsumption;
    }
    public Integer getSeatsNumber() {
        return seatsNumber;
    }

    public void setSeatsNumber(Integer seatsNumber) {
        this.seatsNumber = seatsNumber;
    }
    public Double getCarLoad() {
        return carLoad;
    }

    public void setCarLoad(Double carLoad) {
        this.carLoad = carLoad;
    }
    public String getCarColour() {
        return carColour;
    }

    public void setCarColour(String carColour) {
        this.carColour = carColour;
    }
    public LocalDate getBuyDate() {
        return buyDate;
    }

    public void setBuyDate(LocalDate buyDate) {
        this.buyDate = buyDate;
    }
    public String getCarDriverId() {
        return carDriverId;
    }

    public void setCarDriverId(String carDriverId) {
        this.carDriverId = carDriverId;
    }
    public String getCarDriverName() {
        return carDriverName;
    }

    public void setCarDriverName(String carDriverName) {
        this.carDriverName = carDriverName;
    }
    public String getDrivingLicense() {
        return drivingLicense;
    }

    public void setDrivingLicense(String drivingLicense) {
        this.drivingLicense = drivingLicense;
    }
    public String getCarSidePhotoUrl() {
        return carSidePhotoUrl;
    }

    public void setCarSidePhotoUrl(String carSidePhotoUrl) {
        this.carSidePhotoUrl = carSidePhotoUrl;
    }
    public String getCarBeforePhotoUrl() {
        return carBeforePhotoUrl;
    }

    public void setCarBeforePhotoUrl(String carBeforePhotoUrl) {
        this.carBeforePhotoUrl = carBeforePhotoUrl;
    }
    public String getCarAfterPhotoUrl() {
        return carAfterPhotoUrl;
    }

    public void setCarAfterPhotoUrl(String carAfterPhotoUrl) {
        this.carAfterPhotoUrl = carAfterPhotoUrl;
    }
    public String getOperators() {
        return operators;
    }

    public void setOperators(String operators) {
        this.operators = operators;
    }
    public String getSimNumber() {
        return simNumber;
    }

    public void setSimNumber(String simNumber) {
        this.simNumber = simNumber;
    }
    public String getIccid() {
        return iccid;
    }

    public void setIccid(String iccid) {
        this.iccid = iccid;
    }
    public String getImsi() {
        return imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }
    public String getApan() {
        return apan;
    }

    public void setApan(String apan) {
        this.apan = apan;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getCompanyIds() {
        return companyIds;
    }

    public void setCompanyIds(String companyIds) {
        this.companyIds = companyIds;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }

    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }

    @Override
    public String toString() {
        return "BizVehicle{" +
                "id='" + id + '\'' +
                ", carNumber='" + carNumber + '\'' +
                ", name='" + name + '\'' +
                ", carBrand='" + carBrand + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyIds='" + companyIds + '\'' +
                ", companyName='" + companyName + '\'' +
                ", depId='" + depId + '\'' +
                ", depName='" + depName + '\'' +
                ", carType='" + carType + '\'' +
                ", fuelType='" + fuelType + '\'' +
                ", frameNumber='" + frameNumber + '\'' +
                ", engineNumber='" + engineNumber + '\'' +
                ", fuelConsumption=" + fuelConsumption +
                ", seatsNumber=" + seatsNumber +
                ", carLoad=" + carLoad +
                ", carColour='" + carColour + '\'' +
                ", buyDate=" + buyDate +
                ", carDriverId='" + carDriverId + '\'' +
                ", carDriverName='" + carDriverName + '\'' +
                ", drivingLicense='" + drivingLicense + '\'' +
                ", carSidePhotoUrl='" + carSidePhotoUrl + '\'' +
                ", carBeforePhotoUrl='" + carBeforePhotoUrl + '\'' +
                ", carAfterPhotoUrl='" + carAfterPhotoUrl + '\'' +
                ", operators='" + operators + '\'' +
                ", simNumber='" + simNumber + '\'' +
                ", iccid='" + iccid + '\'' +
                ", imsi='" + imsi + '\'' +
                ", apan='" + apan + '\'' +
                ", remarks='" + remarks + '\'' +
                ", roadSegmentId='" + roadSegmentId + '\'' +
                ", roadSegmentName='" + roadSegmentName + '\'' +
                '}';
    }
}
