/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.contract.controller;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.model.User;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.OrderCashVo;
import com.artfess.yhxt.contract.vo.OrderCheckVO;
import com.artfess.yhxt.contract.vo.OrderItemCountVo;
import com.artfess.yhxt.contract.vo.OrderMoneyVO;
import com.artfess.yhxt.contract.vo.OrderMonthVO;
import com.artfess.yhxt.contract.vo.OrderReportVO;
import com.artfess.yhxt.contract.vo.OrderSpecialCashVo;
import com.artfess.yhxt.contract.vo.OrderWorkFinishVO;
import com.artfess.yhxt.contract.vo.WorkOrderAndBaseIdVo;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.artfess.yhxt.contract.vo.WorkOrderInformationVo;
import com.artfess.yhxt.contract.vo.WorkOrderVo;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.statistics.vo.OrgVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workOrderInformation/v1/"})
@Api(tags={"\u5de5\u5355\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class WorkOrderInformationController
extends BaseController<WorkOrderInformationManager, WorkOrderInformation> {
    @Resource
    BaseContext baseContext;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IFlowManager iFlowService;
    @Resource
    private SysIdentityManager sysIdentityManager;

    @RequestMapping(value={"monthReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5355\u6708\u62a5\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5de5\u5355\u6708\u62a5\u62a5\u8868")
    public List<OrderMonthVO> monthReport(String year, String orgId) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getMonthReport(year, orgId);
    }

    @RequestMapping(value={"orderReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5355\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5de5\u5355\u62a5\u8868")
    public List<OrderReportVO> orderReport(String year, String orgId) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getReport(year, orgId);
    }

    @RequestMapping(value={"workReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65e5\u5e38\u517b\u62a4\u65bd\u5de5\u5b8c\u6210\u60c5\u51b5\u7edf\u8ba1", httpMethod="GET", notes="\u65e5\u5e38\u517b\u62a4\u65bd\u5de5\u5b8c\u6210\u60c5\u51b5\u7edf\u8ba1")
    public List<OrderWorkFinishVO> workReport(String year, String orgId) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkFinishReport(year, orgId);
    }

    @RequestMapping(value={"orderMoneyReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5355\u8ba1\u91cf\u652f\u4ed8\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5de5\u5355\u8ba1\u91cf\u652f\u4ed8\u62a5\u8868")
    public List<OrderMoneyVO> orderMoneyReport(String year, String orgId) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getMoneyReport(year, orgId);
    }

    @RequestMapping(value={"orderCheckReport"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5355\u9a8c\u6536\u62a5\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5de5\u5355\u9a8c\u6536\u62a5\u8868")
    public List<OrderCheckVO> orderCheckReport(String year, String orgId) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getCheckReport(year, orgId);
    }

    @RequestMapping(value={"orderItemCountReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868", httpMethod="POST", notes="\u83b7\u53d6\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868")
    public PageList<OrderItemCountVo> orderItemCountReport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<WorkOrderInformation> queryFilter) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).orderItemCountReport(queryFilter);
    }

    @RequestMapping(value={"orderItemCountReportExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868\u5bfc\u51fa", httpMethod="POST", notes="\u83b7\u53d6\u5de5\u5355\u79d1\u76ee\u7edf\u8ba1\u62a5\u8868\u5bfc\u51fa")
    public void orderItemCountReportExport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<WorkOrderInformation> queryFilter, HttpServletResponse response) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        ((WorkOrderInformationManager)this.baseService).orderItemCountReportExport(queryFilter, response);
    }

    @RequestMapping(value={"orderCashReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5", httpMethod="POST", notes="\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5")
    public PageList<OrderCashVo> orderCashReport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<YearBudget> queryFilter) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getOrderCashReport(queryFilter);
    }

    @PostMapping(value={"export/orderCashReport"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5-\u5bfc\u51fa", httpMethod="POST", notes="\u517b\u62a4\u8d44\u91d1\u6267\u884c\u60c5\u51b5")
    public void exportOrderCashReport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<YearBudget> queryFilter, HttpServletResponse response) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        ((WorkOrderInformationManager)this.baseService).exportOrderCashReport(queryFilter, response);
    }

    @RequestMapping(value={"orderSpecialCashReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868", httpMethod="POST", notes="\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868")
    public PageList<OrderSpecialCashVo> orderSpecialCashReport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizEngineeringProject> queryFilter) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getOrderSpecialCashReport(queryFilter);
    }

    @RequestMapping(value={"export/orderSpecialCashReport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868-\u5bfc\u51fa", httpMethod="POST", notes="\u91cd\u5927\u517b\u62a4\u4e13\u9879\u60c5\u51b5\u7edf\u8ba1\u8868")
    public void exportOrderSpecialCashReport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizEngineeringProject> queryFilter, HttpServletResponse response) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        ((WorkOrderInformationManager)this.baseService).exportOrderSpecialCashReport(queryFilter, response);
    }

    @RequestMapping(value={"/saveworkOrderInformation"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5de5\u5355\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveWorkOrderInformation(@ApiParam(name="workOrderInformation", value="\u9879\u76ee\u5f00\u5de5\u7533\u8bf7\u4e13\u9879\u68c0\u67e5\u5bf9\u8c61") @RequestBody WorkOrderInformation workOrderInformation) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (workOrderInformation.getEndTime() == null) {
            LocalDate demandFinishTime = workOrderInformation.getDemandFinishTime();
            if (demandFinishTime.isBefore(LocalDate.now())) {
                workOrderInformation.setOverdue(1);
            } else {
                workOrderInformation.setOverdue(0);
            }
        }
        if (StringUtils.isEmpty((String)workOrderInformation.getId())) {
            workOrderInformation.setIsDele("0");
            ((WorkOrderInformationManager)this.baseService).create((Model)workOrderInformation);
        } else {
            ((WorkOrderInformationManager)this.baseService).update((Model)workOrderInformation);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5de5\u5355\u4fe1\u606f", httpMethod="POST")
    public PageList<WorkOrderInformation> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<WorkOrderInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList<WorkOrderInformation> pageList = ((WorkOrderInformationManager)this.baseService).queryWorkOrderInformation(queryFilter);
        return pageList;
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5de5\u5355\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5de5\u5355\u4fe1\u606f")
    public WorkOrderInformation get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        System.out.println(this.sysIdentityManager.nextId("yhgd"));
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderInformationById(id);
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5de5\u5355\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5de5\u5355\u4fe1\u606f")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((WorkOrderInformationManager)this.baseService).removeByIds(Arrays.asList(ids));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/updateWorkOrderInformation"}, method={RequestMethod.DELETE}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u5de5\u5355\u4fe1\u606f", httpMethod="DELETE", notes="\u903b\u8f91\u5220\u9664\u5de5\u5355\u4fe1\u606f")
    public CommonResult<String> updateBeginApplyFor(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((String)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((WorkOrderInformationManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/saveVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5de5\u5355\u4fe1\u606fVO", httpMethod="POST")
    public CommonResult<WorkOrderInformationVo> saveVo(@ApiParam(name="vo", value="\u5de5\u5355\u4fe1\u606fVo") @RequestBody WorkOrderInformationVo vo) throws Exception {
        List billOfQuantities = vo.getBillOfQuantities();
        if (null != billOfQuantities && billOfQuantities.size() > 0) {
            billOfQuantities = billOfQuantities.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BillOfQuantities>(Comparator.comparing(o -> o.getContractItemId()))), ArrayList::new));
            vo.setBillOfQuantities(billOfQuantities);
        }
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((String)vo.getWorkOrderInformation().getId())) {
            ((WorkOrderInformationManager)this.baseService).saveVo(vo);
        } else {
            msg = "\u4fee\u6539\u6210\u529f";
            ((WorkOrderInformationManager)this.baseService).updateVo(vo);
        }
        return new CommonResult(true, msg, (Object)vo);
    }

    @GetMapping(value={"getVo/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5de5\u5355\u4fe1\u606fvo", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5de5\u5355\u4fe1\u606fvo")
    public WorkOrderInformationVo getVo(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        WorkOrderInformationVo vo = ((WorkOrderInformationManager)this.baseService).getVo(id);
        return vo;
    }

    @RequestMapping(value={"getWorkOrderVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u517b\u62a4\u5de5\u5355\u72b6\u6001", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7684\u517b\u62a4\u5de5\u5355\u72b6\u6001")
    public PageList<WorkOrderVo> getWorkOrderVo(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderVo(queryFilter);
    }

    @RequestMapping(value={"approve"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6700\u7ec8\u5ba1\u6838", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7684\u517b\u62a4\u5de5\u5355\u72b6\u6001")
    public CommonResult<String> approve(@ApiParam(name="id", value="\u5de5\u5355id", required=true) @RequestParam(value="id", required=true) String id, @ApiParam(name="state", value="\u662f\u5426\u901a\u8fc7 0\u9a73\u56de 1\u901a\u8fc7", required=true) @RequestParam(value="state", required=true) Integer state) {
        ((WorkOrderInformationManager)this.baseService).approve(id, state);
        return new CommonResult(true, "\u64cd\u4f5c\u5b8c\u6210");
    }

    @RequestMapping(value={"getWorkCountVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u517b\u62a4\u5de5\u5355\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7684\u517b\u62a4\u5de5\u5355\u72b6\u6001")
    public List<OrgVO> getWorkCountVo(String startDate, String endDate) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderCount(startDate, endDate);
    }

    @RequestMapping(value={"getWorkOrder"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5f00\u59cb\u3001\u7ed3\u675f\u65f6\u95f4", httpMethod="POST", notes="\u6839\u636e\u5f00\u59cb\u3001\u7ed3\u675f\u65f6\u95f4")
    public PageList<WorkOrderDiseaseVo> getWorkOrder(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61\uff08startTime\u5f00\u59cb\u65f6\u95f4 endTime \u7ed3\u675f\u65f6\u95f4 roadId \u8def\u6bb5id\uff09") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrder(queryFilter);
    }

    @RequestMapping(value={"getDoneInstList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7ecf\u529e\u7684\u6d41\u7a0b\u5b9e\u4f8b", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u7684\u5df2\u529e\u4e8b\u5b9c\uff0c\u53c2\u6570status\u8868\u793a\u6d41\u7a0b\u72b6\u6001\uff0c\u4e0d\u586b\u8868\u793a\u67e5\u8be2\u6240\u6709")
    public PageList<Map<String, Object>> getWorkOrderEnd(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="status", value="\u6d41\u7a0b\u72b6\u6001", allowableValues="running,end,manualend,cancel,back,revoke,revokeToStart", required=false) @RequestParam(required=false) String status, HttpServletResponse response) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getDoneInstList(this.baseContext.getCurrentUserAccout(), queryFilter, status).get();
    }

    @RequestMapping(value={"getTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<Map<String, Object>> getTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            for (QueryField field : queryFilter.getQuerys()) {
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter defFilter = QueryFilter.build();
                    defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                    PageList query = this.bpmDefinitionManager.query(defFilter);
                    ArrayList<String> defKeys = new ArrayList<String>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                    continue;
                }
                fields.add(field);
            }
            queryFilter.setQuerys(fields);
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
        PageList pageList = (PageList)this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), queryFilter).get();
        List rows = pageList.getRows();
        PageList mapPageList = new PageList();
        ArrayList<Map> mapPageListRows = mapPageList.getRows();
        if (null == mapPageListRows) {
            mapPageListRows = new ArrayList<Map>();
        }
        for (DefaultBpmTask row : rows) {
            WorkOrderInformation workOrderInformation;
            String bizKey = ((WorkOrderInformationManager)this.baseService).getBizkey(row.getBpmnInstId());
            if (StringUtils.isEmpty((String)bizKey) || null == (workOrderInformation = (WorkOrderInformation)((Object)((WorkOrderInformationManager)this.baseService).getById((Serializable)((Object)bizKey))))) continue;
            Road road = ((WorkOrderInformationManager)this.baseService).getRoad(workOrderInformation.getRoadSegmentId());
            Map map = BeanUtil.beanToMap((Object)row);
            workOrderInformation.setRoad(road);
            map.put("workOrderInformation", workOrderInformation);
            mapPageListRows.add(map);
        }
        mapPageList.setPageSize(pageList.getPageSize());
        mapPageList.setPage(pageList.getPage());
        mapPageList.setTotal(pageList.getTotal());
        mapPageList.setRows(mapPageListRows);
        return mapPageList;
    }

    @RequestMapping(value={"getWorkOrderVoByBridge"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u6863\u6848-\u517b\u62a4\u5de5\u5355", httpMethod="POST", notes="\u6865\u6881\u6863\u6848-\u517b\u62a4\u5de5\u5355")
    public PageList<WorkOrderVo> getWorkOrderVoByBridge(@ApiParam(required=true, name="workOrderByBridgeVo", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderVoByBridge(workOrderByBridgeVo);
    }

    @RequestMapping(value={"getWorkOrderVoByTunnel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u96a7\u9053\u6863\u6848-\u517b\u62a4\u5de5\u5355", httpMethod="POST", notes="\u6839\u636e\u96a7\u9053ID\u67e5\u8be2\u517b\u62a4\u5de5\u5355\u5217\u8868")
    public PageList<WorkOrderVo> getWorkOrderVoByTunnel(@ApiParam(required=true, name="workOrderByBridgeVo", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderVoByTunnel(workOrderByBridgeVo);
    }

    @RequestMapping(value={"getWorkOrderVoByCulvert"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6db5\u6d1e\u6863\u6848-\u517b\u62a4\u5de5\u5355", httpMethod="POST", notes="\u6839\u636e\u6db5\u6d1eID\u67e5\u8be2\u517b\u62a4\u5de5\u5355\u5217\u8868")
    public PageList<WorkOrderVo> getWorkOrderVoByCulvert(@ApiParam(required=true, name="workOrderByBridgeVo", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderVoByCulvert(workOrderByBridgeVo);
    }

    @RequestMapping(value={"getWorkOrderVoBySideSlope"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fb9\u5761\u6863\u6848-\u517b\u62a4\u5de5\u5355", httpMethod="POST", notes="\u6839\u636e\u8fb9\u5761ID\u67e5\u8be2\u517b\u62a4\u5de5\u5355\u5217\u8868")
    public PageList<WorkOrderVo> getWorkOrderVoBySideSlope(@ApiParam(required=true, name="workOrderByBridgeVo", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getWorkOrderVoBySideSlope(workOrderByBridgeVo);
    }

    @RequestMapping(value={"exportWorkOrder"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u4e2a\u5de5\u5355\u5bfc\u51fa", httpMethod="GET", notes="\u5355\u4e2a\u5de5\u5355\u5bfc\u51fa")
    public void exportWorkOrder(@ApiParam(name="ids", value="\u5de5\u5355id\u7528\u9017\u53f7\u5206\u5272", required=true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        ((WorkOrderInformationManager)this.baseService).exportWorkOrder(ids, response);
    }

    @RequestMapping(value={"exportWorkOrders"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u7167\u65f6\u95f4\u5bfc\u51fa\u5de5\u5355", httpMethod="GET", notes="\u6309\u7167\u65f6\u95f4\u5bfc\u51fa\u5de5\u5355")
    public void exportWorkOrders(@ApiParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4yyyy-MM-dd", required=true) @RequestParam String startTime, @ApiParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4yyyy-MM-dd", required=true) @RequestParam String endTime, @ApiParam(name="contractId", value="\u517b\u62a4\u5408\u540cID", required=true) @RequestParam String contractId, HttpServletResponse response) throws Exception {
        String type = "2";
        ((WorkOrderInformationManager)this.baseService).exportWorkOrders(startTime, endTime, contractId, type, response);
    }

    @RequestMapping(value={"exportWorkOrdersConstruction"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6309\u7167\u65f6\u95f4\u5bfc\u51fa\u5de5\u5355 -\u5df2\u529e\u5de5\u5355\u5bfc\u51fa", httpMethod="GET", notes="\u6309\u7167\u65f6\u95f4\u5bfc\u51fa\u5de5\u5355")
    public void exportWorkOrdersConstruction(@ApiParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4yyyy-MM-dd", required=true) @RequestParam String startTime, @ApiParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4yyyy-MM-dd", required=true) @RequestParam String endTime, @ApiParam(name="contractId", value="\u517b\u62a4\u5408\u540cID", required=true) @RequestParam String contractId, HttpServletResponse response) throws Exception {
        String type = "2";
        ((WorkOrderInformationManager)this.baseService).exportWorkOrdersConstruction(startTime, endTime, contractId, type, response);
    }

    @RequestMapping(value={"getPrincipal"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u627f\u5305\u65b9\u8d1f\u8d23\u4eba\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u627f\u5305\u65b9\u8d1f\u8d23\u4eba\u4fe1\u606f")
    public List<User> getPrincipal(@ApiParam(required=true, name="userId", value="\u627f\u5305\u65b9\u7ecf\u529e\u4ebaID") String userId) throws Exception {
        return ((WorkOrderInformationManager)this.baseService).getPrincipal(userId);
    }

    @RequestMapping(value={"/deleWorkOrderInformation"}, method={RequestMethod.DELETE}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5de5\u5355\u4fe1\u606f", httpMethod="DELETE", notes="\u5220\u9664\u5de5\u5355\u4fe1\u606f")
    public CommonResult<String> deleWorkOrderInformation(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        boolean result;
        if (StringUtils.isNotBlank((String)ids) && !(result = ((WorkOrderInformationManager)this.baseService).deleWorkOrderInformation(ids))) {
            return new CommonResult(false, "\u8be5\u5de5\u5355\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return new CommonResult(true, "\u5220\u9664\u5de5\u5355\u6210\u529f");
    }
}

