/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.dao.BizCourseDetailsDao;
import com.artfess.yhxt.basedata.manager.BizCourseDetailsManager;
import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BizCourseDetailsManagerImpl
extends BaseManagerImpl<BizCourseDetailsDao, BizCourseDetails>
implements BizCourseDetailsManager {
    @Override
    public PageList<BizCourseDetails> queryBizCourseDetails(QueryFilter<BizCourseDetails> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizCourseDetails> result = ((BizCourseDetailsDao)this.baseMapper).getBizCourseDetails((IPage<BizCourseDetails>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCourseDetails>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void updateBizCourseDetails(String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        updateWrapper.set((Object)"is_dele_", (Object)"1");
        ((BizCourseDetailsDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public List<BizCourseDetails> getByParentId(String pCode) {
        ArrayList<BizCourseDetails> bcdList = new ArrayList<BizCourseDetails>();
        List<BizCourseDetails> allList = this.getList();
        return BizCourseDetailsManagerImpl.getChild(allList, pCode, bcdList);
    }

    private List<BizCourseDetails> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        return ((BizCourseDetailsDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    public static List<BizCourseDetails> getChild(List<BizCourseDetails> bizCourseDetailsList, String pCode, List<BizCourseDetails> bcdList) {
        for (BizCourseDetails bizCourseDetails : bizCourseDetailsList) {
            if (!pCode.equals(bizCourseDetails.getPcode())) continue;
            BizCourseDetailsManagerImpl.getChild(bizCourseDetailsList, bizCourseDetails.getId(), bcdList);
            bcdList.add(bizCourseDetails);
        }
        return bcdList;
    }

    @Override
    public void updateByPcode(String pcode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PCODE_", (Object)pcode);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        Integer count = ((BizCourseDetailsDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count == 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"SUBJECT_CODE_", (Object)pcode);
            updateWrapper.set((Object)"HAS_CHILDREN", (Object)"false");
            ((BizCourseDetailsDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        } else {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"SUBJECT_CODE_", (Object)pcode);
            updateWrapper.set((Object)"HAS_CHILDREN", (Object)"true");
            ((BizCourseDetailsDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        }
    }

    @Override
    public void checkCode(BizCourseDetails bizCourseDetails) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)bizCourseDetails.getId())) {
            queryWrapper.notIn((Object)"ID_", new Object[]{bizCourseDetails.getId()});
        }
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bizCourseDetails.getPcode()), (Object)"PCODE_", (Object)bizCourseDetails.getPcode());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)bizCourseDetails.getSubjectCode()), (Object)"SUBJECT_CODE_", (Object)bizCourseDetails.getSubjectCode());
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List details = ((BizCourseDetailsDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (details.size() > 0) {
            throw new RuntimeException("\u7f16\u7801\u91cd\u590d\u8bf7\u91cd\u65b0\u6dfb\u52a0");
        }
    }

    @Override
    public void updateHasChildren(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"ID_", idsList);
            queryWrapper.select(new String[]{"DISTINCT PCODE_"});
            List details = ((BizCourseDetailsDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            for (BizCourseDetails detail : details) {
                this.updateByPcode(detail.getPcode());
            }
        }
    }

    @Override
    public void checkHasChildren(List<String> idsList) {
        for (String id : idsList) {
            BizCourseDetails details = (BizCourseDetails)((Object)this.getById((Serializable)((Object)id)));
            if (details.getHasChildren() == null || !details.getHasChildren().equals("true")) continue;
            throw new RuntimeException("\u8bf7\u5148\u5220\u9664\u5b50\u8282\u70b9");
        }
    }

    @Override
    public String getByName(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SUBJECT_CODE_", (Object)code);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        BizCourseDetails bizCourseDetails = (BizCourseDetails)((Object)((BizCourseDetailsDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (bizCourseDetails != null) {
            return bizCourseDetails.getSubjectName();
        }
        return "";
    }

    @Override
    public List<BizCourseDetails> getByParentIdRoad(String pCode, String roadSegmentId) {
        QueryWrapper bizCourseDetailsQueryWrapper = new QueryWrapper();
        bizCourseDetailsQueryWrapper.eq(StringUtils.isNotEmpty((CharSequence)pCode), (Object)"PCODE_", (Object)pCode);
        bizCourseDetailsQueryWrapper.eq(StringUtils.isEmpty((CharSequence)pCode), (Object)"PCODE_", (Object)"root");
        bizCourseDetailsQueryWrapper.in(StringUtils.isNotEmpty((CharSequence)roadSegmentId), (Object)"ROAD_SEGMENT_ID_", Arrays.asList(roadSegmentId.split(",")));
        List list = this.list((Wrapper)bizCourseDetailsQueryWrapper);
        return list;
    }
}

