/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.check.detail.dao.CulvertRegularCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.CulvertRegularCheckDetailManager;
import com.artfess.yhxt.check.detail.model.CulvertRegularCheckDetail;
import com.artfess.yhxt.check.regular.dao.CulvertRegularCheckDao;
import com.artfess.yhxt.check.regular.manager.CulvertRegularCheckManager;
import com.artfess.yhxt.check.regular.model.CulvertRegularCheck;
import com.artfess.yhxt.check.regular.vo.CulvertRegularCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CulvertRegularCheckManagerImpl
extends BaseManagerImpl<CulvertRegularCheckDao, CulvertRegularCheck>
implements CulvertRegularCheckManager {
    @Resource
    private CulvertRegularCheckDetailDao culvertRegularCheckDetailDao;
    @Resource
    private CulvertRegularCheckDetailManager culvertRegularCheckDetailManager;
    @Resource
    private BizCulvertInformationManager culvertInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public CulvertRegularCheckVo getCulvertRegularCheckById(String id) {
        CulvertRegularCheckVo culvertRegularCheckVo = new CulvertRegularCheckVo();
        CulvertRegularCheck culvertRegularCheck = (CulvertRegularCheck)((Object)this.getById((Serializable)((Object)id)));
        culvertRegularCheckVo.setCulvertRegularCheck(culvertRegularCheck);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)culvertRegularCheck.getId()), (Object)"CULVERT_REGULAR_CHECK_ID_", (Object)id);
        List culvertRegularCheckDetails = this.culvertRegularCheckDetailDao.selectList((Wrapper)queryWrapper);
        culvertRegularCheckVo.setCulvertRegularCheckDetails(culvertRegularCheckDetails);
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        culvertRegularCheckVo.setAccessories(accessories);
        return culvertRegularCheckVo;
    }

    @Override
    public void updateCulvertRegularCheck(CulvertRegularCheckVo vo) {
        CulvertRegularCheck culvertRegularCheck = vo.getCulvertRegularCheck();
        culvertRegularCheck.setIsDele("0");
        this.update((Model)culvertRegularCheck);
        List<CulvertRegularCheckDetail> list = vo.getCulvertRegularCheckDetails();
        for (CulvertRegularCheckDetail culvertRegularCheckDetail : list) {
            culvertRegularCheckDetail.setCulvertRegularCheckId(culvertRegularCheck.getId());
            this.culvertRegularCheckDetailManager.saveOrUpdate((Object)culvertRegularCheckDetail);
        }
        List<Accessory> accessoryList = vo.getAccessories();
        String id = culvertRegularCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public void saveCulvertRegularCheck(CulvertRegularCheckVo vo) {
        CulvertRegularCheck culvertRegularCheck = vo.getCulvertRegularCheck();
        culvertRegularCheck.setIsDele("0");
        this.saveOrUpdate((Object)culvertRegularCheck);
        List<CulvertRegularCheckDetail> list = vo.getCulvertRegularCheckDetails();
        if (list.size() > 0) {
            for (CulvertRegularCheckDetail culvertRegularCheckDetail : list) {
                culvertRegularCheckDetail.setId(null);
                culvertRegularCheckDetail.setCulvertRegularCheckId(culvertRegularCheck.getId());
                this.culvertRegularCheckDetailManager.create((Model)culvertRegularCheckDetail);
            }
        }
        List<Accessory> accessoryList = vo.getAccessories();
        String id = culvertRegularCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public PageList<CulvertRegularCheck> queryCulvertRegularCheck(QueryFilter<CulvertRegularCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<CulvertRegularCheck> result = ((CulvertRegularCheckDao)this.baseMapper).queryCulvertRegularCheck((IPage<CulvertRegularCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<CulvertRegularCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, CulvertRegularCheck parseObject) {
        Assert.notNull((Object)((Object)parseObject), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, CulvertRegularCheckDetail.class, (ImportParams)new ImportParams());
            CulvertRegularCheckVo vo = new CulvertRegularCheckVo();
            vo.setCulvertRegularCheck(parseObject);
            vo.setCulvertRegularCheckDetails(data);
            this.saveCulvertRegularCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteStatistic(CulvertRegularCheck culvertRegularCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String culvertId = culvertRegularCheck.getCulvertId();
        BizCulvertInformation culvertInformation = (BizCulvertInformation)((Object)this.culvertInformationManager.getById((Serializable)((Object)culvertId)));
        siteStatistic.setRoadSegmentId(culvertInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(culvertInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(culvertInformation.getCompanyId());
        siteStatistic.setCompanyName(culvertInformation.getCompanyName());
        siteStatistic.setSiteCode(9);
        siteStatistic.setSiteName("\u6db5\u6d1e\u5b9a\u671f\u68c0\u67e5");
        LocalDate checkDate = culvertRegularCheck.getCheckDate();
        String month = checkDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        siteStatistic.setAccDateMonth(month);
        String year = checkDate.format(DateTimeFormatter.ofPattern("yyyy"));
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)culvertInformation.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)culvertInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)culvertInformation.getCompanyId()), (Object)"COMPANY_ID_", (Object)culvertInformation.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)9);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u6db5\u6d1e\u5b9a\u671f\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }
}

