/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentManager;
import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.yhxt.specialproject.params.ConstructionParamVo;
import com.artfess.yhxt.specialproject.vo.MeasurementPaymentVo;
import com.artfess.yhxt.util.PermissionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.hasor.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/measurement/payment/v1/"})
@Api(tags={"\u8ba1\u91cf\u652f\u4ed8"})
@ApiGroup(group={"group_biz"})
public class MeasurementPaymentController
extends BaseController<MeasurementPaymentManager, MeasurementPayment> {
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value={"/saveVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u9879\u76ee\u5468\u62a5\u6708\u62a5\u3001\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveVo(@ApiParam(name="bizProjectWeeklyMonthlyReportVo", value="\u9879\u76ee\u5468\u62a5\u6708\u62a5\u5bf9\u8c61") @RequestBody MeasurementPaymentVo vo) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        MeasurementPayment measurementPayment = vo.getMeasurementPayment();
        if (StringUtils.isEmpty((String)measurementPayment.getId())) {
            ((MeasurementPaymentManager)this.baseService).saveVo(vo);
        } else {
            ((MeasurementPaymentManager)this.baseService).updateVo(vo);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public MeasurementPaymentVo getVoById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((MeasurementPaymentManager)this.baseService).getVoById(id);
    }

    @DeleteMapping(value={"/removeById/{ids}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> removeById(@ApiParam(name="ids", value="\u5bf9\u5404\u4e3b\u952e\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) {
        boolean result = ((MeasurementPaymentManager)this.baseService).removeVo(ids);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<MeasurementPayment> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<MeasurementPayment> queryFilter) {
        this.permissionUtils.addPermission(queryFilter);
        return ((MeasurementPaymentManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/online/preview/construction"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09\u5728\u7ebf\u9884\u89c8")
    public CommonResult<HashMap> onlinePreviewConstruction(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HashMap map = ((MeasurementPaymentManager)this.baseService).onlinePreviewConstruction(param, response);
        return new CommonResult(true, "", (Object)map);
    }

    @PostMapping(value={"/export/construction"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09\u5bfc\u51fa")
    public void exportConstruction(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = ((MeasurementPaymentManager)this.baseService).exportConstruction(param, response);
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)"\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868", (HttpServletResponse)response);
    }

    @PostMapping(value={"/online/preview/collect"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u6c47\u603b\u7c7b\uff09\u5728\u7ebf\u9884\u89c8")
    public CommonResult<HashMap> onlinePreviewCollect(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HashMap map = ((MeasurementPaymentManager)this.baseService).onlinePreviewCollect(param, response);
        return new CommonResult(true, "", (Object)map);
    }

    @PostMapping(value={"/export/collect"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u6c47\u603b\u7c7b\uff09\u5bfc\u51fa")
    public void exportCollect(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = ((MeasurementPaymentManager)this.baseService).exportCollect(param, response);
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)"\u5de5\u7a0b\u6536\u65b9\u6c47\u603b\u8868", (HttpServletResponse)response);
    }
}

