/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.MigrantBuildersInformationDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.MigrantBuildersInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.impl.BizVehicleManagerImpl;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.MigrantBuildersInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.vo.HumanCountVo;
import com.artfess.yhxt.basedata.vo.MigrantBuildersInformationVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigrantBuildersInformationManagerImpl
extends BaseManagerImpl<MigrantBuildersInformationDao, MigrantBuildersInformation>
implements MigrantBuildersInformationManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private MigrantBuildersInformationManager migrantBuildersInformationManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;
    @Resource
    private OrgManager orgManager;
    @Resource
    private BizVehicleManagerImpl bizVehicleManagerImpl;

    @Override
    public PageList<MigrantBuildersInformation> queryMigrantBuildersInformation(QueryFilter<MigrantBuildersInformation> queryFilter) {
        IPage<MigrantBuildersInformation> result = ((MigrantBuildersInformationDao)this.baseMapper).queryMigrantBuildersInformation((IPage<MigrantBuildersInformation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MigrantBuildersInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public MigrantBuildersInformation getMigrantBuildersById(String id) {
        return (MigrantBuildersInformation)((Object)((MigrantBuildersInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    @Override
    public void saveVo(MigrantBuildersInformationVo migrantBuildersInformationVo) {
        MigrantBuildersInformation migrantBuildersInformation = migrantBuildersInformationVo.getMigrantBuildersInformation();
        List<Accessory> accessoryList = migrantBuildersInformationVo.getAccessoryList();
        this.create((Model)migrantBuildersInformation);
        String id = migrantBuildersInformation.getId();
        if (accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateVo(MigrantBuildersInformationVo migrantBuildersInformationVo) {
        MigrantBuildersInformation migrantBuildersInformation = migrantBuildersInformationVo.getMigrantBuildersInformation();
        List<Accessory> accessoryList = migrantBuildersInformationVo.getAccessoryList();
        this.update((Model)migrantBuildersInformation);
        String id = migrantBuildersInformation.getId();
        if (accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public MigrantBuildersInformationVo getByIdVo(String id) {
        MigrantBuildersInformationVo migrantBuildersInformationVo = new MigrantBuildersInformationVo();
        MigrantBuildersInformation migrantBuildersInformation = (MigrantBuildersInformation)((Object)((MigrantBuildersInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        migrantBuildersInformationVo.setMigrantBuildersInformation(migrantBuildersInformation);
        migrantBuildersInformationVo.setAccessoryList(accessoryList);
        return migrantBuildersInformationVo;
    }

    @Override
    public List<HumanCountVo> getCountVo() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        ArrayList<HumanCountVo> vos = new ArrayList<HumanCountVo>();
        List<Org> list = this.bizVehicleManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            HumanCountVo vo = new HumanCountVo();
            BeanUtils.copyProperties((Object)org, (Object)vo);
            vos.add(vo);
        }
        List<HumanCountVo> returnList = this.getHumanCountChild(vos, orgId);
        this.countCompanyCount(returnList);
        return returnList;
    }

    private List<HumanCountVo> getHumanCountChild(List<HumanCountVo> vos, String orgId) {
        ArrayList<HumanCountVo> returnList = new ArrayList<HumanCountVo>();
        for (HumanCountVo entity : vos) {
            if (!orgId.equals(entity.getParentId())) continue;
            entity.setChirldren(this.getHumanCountChild(vos, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    private void countCompanyCount(List<HumanCountVo> vos) {
        Iterator<HumanCountVo> it = vos.iterator();
        while (it.hasNext()) {
            HumanCountVo countVo = it.next();
            Integer grade = Integer.valueOf(countVo.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)countVo.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)countVo.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                countVo = this.newCountHuman(roadList, countVo);
            } else {
                it.remove();
            }
            if (countVo.getChirldren().size() <= 0 || Integer.valueOf(countVo.getGrade()) >= 4) continue;
            this.countCompanyCount(countVo.getChirldren());
        }
    }

    public HumanCountVo newCountHuman(List<String> ids, HumanCountVo vo) {
        QueryWrapper migrantBuildersInformationQueryWrapper = new QueryWrapper();
        String companyId = vo.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", companyId);
        Map childrenIds = this.orgManager.getChildrenIds(map);
        Set companyIds = (Set)childrenIds.get("id");
        migrantBuildersInformationQueryWrapper.in((Object)"COMPANY_ID_", (Collection)companyIds);
        List list = this.migrantBuildersInformationManager.list((Wrapper)migrantBuildersInformationQueryWrapper);
        if (list.size() > 0) {
            vo.setMigrantHumanNum(list.size());
            if ("4".equals(vo.getGrade())) {
                vo.setRoadSegmentId(((MigrantBuildersInformation)((Object)list.get(0))).getCompanyId());
            }
        } else {
            vo.setMigrantHumanNum(0);
        }
        return vo;
    }
}

