/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.yhxt.specialproject.dao.BizProjectContractDao;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractDetailsManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.vo.BizProjectContractVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizProjectContractManagerImpl
extends BaseManagerImpl<BizProjectContractDao, BizProjectContract>
implements BizProjectContractManager {
    @Autowired
    private BizProjectContractDetailsManager bizProjectContractDetailsManager;
    @Autowired
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizProjectContract> queryBizProjectContract(QueryFilter<BizProjectContract> queryFilter) {
        IPage<BizProjectContract> result = ((BizProjectContractDao)this.baseMapper).queryBizProjectContract((IPage<BizProjectContract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizProjectContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizProjectContractVo getBizProjectContractById(String id) {
        List<BizEngineeringAccessories> engineeringAccessories;
        BizProjectContract bizProjectContract = (BizProjectContract)((Object)((BizProjectContractDao)this.baseMapper).selectById((Serializable)((Object)id)));
        BizProjectContractVo bizProjectContractVo = new BizProjectContractVo();
        bizProjectContractVo.setBizProjectContract(bizProjectContract);
        if (null != bizProjectContract && StringUtils.isNotBlank((CharSequence)bizProjectContract.getId())) {
            bizProjectContractVo.setDetailList(this.bizProjectContractDetailsManager.selectListById(id));
        }
        if ((engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id)).size() > 0) {
            bizProjectContractVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        }
        return bizProjectContractVo;
    }

    @Override
    public void saveBizProjectContractVo(BizProjectContractVo vo) {
        BizProjectContract bizProjectContract = vo.getBizProjectContract();
        if (BeanUtils.isNotEmpty((Object)((Object)bizProjectContract))) {
            if (StringUtils.isEmpty((CharSequence)bizProjectContract.getId())) {
                bizProjectContract.setIsDele("0");
                this.save((Object)bizProjectContract);
            } else {
                this.update((Model)bizProjectContract);
            }
            String id = bizProjectContract.getId();
            if (vo.getDetailList() != null && vo.getDetailList().size() > 0) {
                vo.getDetailList().forEach(s -> {
                    s.setContractId(id);
                    if (StringUtils.isEmpty((CharSequence)s.getId())) {
                        s.setIsDele("0");
                        this.bizProjectContractDetailsManager.save(s);
                    } else {
                        this.bizProjectContractDetailsManager.update((Model)s);
                    }
                });
            }
            this.bizEngineeringAccessoriesManager.removeEngineeringAccessories(id);
            List<BizEngineeringAccessories> bizEngineeringAccessoriesList = vo.getBizEngineeringAccessoriesList();
            if (bizEngineeringAccessoriesList != null && bizEngineeringAccessoriesList.size() > 0) {
                bizEngineeringAccessoriesList.forEach(s -> {
                    s.setSourceId(id);
                    s.setValidFlag(1);
                });
            }
            this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
        }
    }

    @Override
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"VALID_FLAG_", (Object)flag)).in((Object)"ID_", idsList);
        this.bizProjectContractManager.update(null, (Wrapper)updateWrapper);
    }
}

