/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.dao.BizTunnelSpecialCheckDao;
import com.artfess.yhxt.specialcheck.manager.BizTunnelSpecialCheckManager;
import com.artfess.yhxt.specialcheck.model.BizTunnelSpecialCheck;
import com.artfess.yhxt.specialcheck.vo.BizTunnelSpecialCheckVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BizTunnelSpecialCheckManagerImpl
extends BaseManagerImpl<BizTunnelSpecialCheckDao, BizTunnelSpecialCheck>
implements BizTunnelSpecialCheckManager {
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    BaseContext baseContext;

    @Override
    public PageList<BizTunnelSpecialCheck> queryBizTunnelSpecialCheck(QueryFilter<BizTunnelSpecialCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<BizTunnelSpecialCheck> result = ((BizTunnelSpecialCheckDao)this.baseMapper).queryBizTunnelSpecialCheck((IPage<BizTunnelSpecialCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizTunnelSpecialCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizTunnelSpecialCheck getBizBridgeSpecialById(String id) {
        BizTunnelSpecialCheck bizTunnelSpecialCheck = (BizTunnelSpecialCheck)((Object)((BizTunnelSpecialCheckDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return bizTunnelSpecialCheck;
    }

    @Override
    public void saveVo(BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo) {
        BizTunnelSpecialCheck bizTunnelSpecialCheck = bizTunnelSpecialCheckVo.getBizTunnelSpecialCheck();
        this.create((Model)bizTunnelSpecialCheck);
        List<Accessory> accessoryList = bizTunnelSpecialCheckVo.getAccessories();
        String id = bizTunnelSpecialCheck.getId();
        if (accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateVo(BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo) {
        BizTunnelSpecialCheck bizTunnelSpecialCheck = bizTunnelSpecialCheckVo.getBizTunnelSpecialCheck();
        List<Accessory> accessoryList = bizTunnelSpecialCheckVo.getAccessories();
        this.update((Model)bizTunnelSpecialCheck);
        String id = bizTunnelSpecialCheck.getId();
        if (accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BizTunnelSpecialCheckVo getVo(String id) {
        BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo = new BizTunnelSpecialCheckVo();
        BizTunnelSpecialCheck bizTunnelSpecialCheck = (BizTunnelSpecialCheck)((Object)((BizTunnelSpecialCheckDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        bizTunnelSpecialCheckVo.setBizTunnelSpecialCheck(bizTunnelSpecialCheck);
        bizTunnelSpecialCheckVo.setAccessories(accessoryList);
        return bizTunnelSpecialCheckVo;
    }
}

