/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.RoadDao;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.statistics.vo.Org4RoadVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="RoadManager")
public class RoadManagerImpl
extends BaseManagerImpl<RoadDao, Road>
implements RoadManager {
    @Resource
    RoadDao roadDao;
    @Resource
    private BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private OrgDao orgDao;

    @Override
    public List<Org4RoadVO> getRoadCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4RoadVO> lists = new ArrayList<Org4RoadVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = RoadManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4RoadVO fvo = new Org4RoadVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = RoadManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4RoadVO> setCount(List<Org4RoadVO> list) {
        Iterator<Org4RoadVO> it = list.iterator();
        while (it.hasNext()) {
            Org4RoadVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<Road> roadList = new ArrayList<Road>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.list((Wrapper)roadQueryWrapper);
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.list((Wrapper)roadByNameQueryWrapper);
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4RoadVO newCountWorkOrder(List<Road> ids, Org4RoadVO orgVO) {
        orgVO.setRoadCount(ids.size());
        orgVO.setRoadLength(new BigDecimal(ids.stream().mapToDouble(Road::getLength).sum()));
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0).getId());
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            RoadManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4RoadVO> getChild(List<Org4RoadVO> allList, String pCode) {
        ArrayList<Org4RoadVO> returnList = new ArrayList<Org4RoadVO>();
        for (Org4RoadVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(RoadManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<Road> queryRoad(QueryFilter<Road> queryFilter) {
        PageBean pageBean = new PageBean();
        pageBean.setPageSize(50);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermissionNo(queryFilter);
        }
        IPage<Road> result = ((RoadDao)this.baseMapper).getRoad((IPage<Road>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Road>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void updateRoad(String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        updateWrapper.set((Object)"is_dele_", (Object)"1");
        this.roadDao.update(null, (Wrapper)updateWrapper);
    }
}

