/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.budget.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.vo.YearBudgetVo;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/yearBudget/v1/"})
@Api(tags={"\u5e74\u5ea6\u603b\u9884\u7b97"})
@ApiGroup(group={"group_biz"})
public class YearBudgetController
extends BaseController<YearBudgetManager, YearBudget> {
    @RequestMapping(value={"getBudgetCountVo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9884\u7b97\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u9884\u7b97\u6570\u91cf")
    public List<Org4BudgetVO> getBudgetCountVo(String year) throws Exception {
        return ((YearBudgetManager)this.baseService).getBudgetCount(year);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e74\u5ea6\u603b\u9884\u7b97", httpMethod="POST")
    public PageList<YearBudget> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<YearBudget> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList<YearBudget> pageList = ((YearBudgetManager)this.baseService).queryYearBuget(queryFilter);
        return pageList;
    }

    @RequestMapping(value={"updateYearBudget"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u5e74\u5ea6\u603b\u9884\u7b97", httpMethod="DELETE", notes="\u903b\u8f91\u5220\u9664\u5e74\u5ea6\u603b\u9884\u7b97")
    public CommonResult<String> updateYearBudget(@ApiParam(name="ids", value="\u53ef\u89c6\u5316\u5206\u7c7bID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((YearBudgetManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"get/{id}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5e74\u5ea6\u603b\u9884\u7b97", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u5e74\u5ea6\u603b\u9884\u7b97")
    public YearBudgetVo get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((YearBudgetManager)this.baseService).getYearBudgetVoById(id);
    }

    @RequestMapping(value={"saveYearBudget"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u5e74\u5ea6\u603b\u9884\u7b97\u548c\u660e\u7ec6", httpMethod="POST")
    public CommonResult<String> saveYearBudgetVo(@ApiParam(name="yearBudget", value="\u5e74\u5ea6\u603b\u9884\u7b97\u5bf9\u8c61") @RequestBody YearBudgetVo yearBudgetVo) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        ((YearBudgetManager)this.baseService).checkYear(yearBudgetVo.getYearBudget());
        if (StringUtils.isEmpty((CharSequence)yearBudgetVo.getYearBudget().getId())) {
            ((YearBudgetManager)this.baseService).saveYearBudgetVo(yearBudgetVo);
        } else {
            ((YearBudgetManager)this.baseService).updateYearBudgetVo(yearBudgetVo);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }
}

