/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BizEmergencyRescueManagementDao;
import com.artfess.yhxt.basedata.manager.BizEmergencyRescueManagementManager;
import com.artfess.yhxt.basedata.manager.BizStructureVehicleManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.BizEmergencyRescueManagement;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.vo.BizEmergencyRescueManagementVO;
import com.artfess.yhxt.statistics.vo.Org4RescueVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BizEmergencyRescueManagementManagerImpl
extends BaseManagerImpl<BizEmergencyRescueManagementDao, BizEmergencyRescueManagement>
implements BizEmergencyRescueManagementManager {
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private BizStructureVehicleManager bizStructureVehicleManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4RescueVO> getRescueCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4RescueVO> lists = new ArrayList<Org4RescueVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizEmergencyRescueManagementManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4RescueVO fvo = new Org4RescueVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizEmergencyRescueManagementManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4RescueVO> setCount(List<Org4RescueVO> list) {
        Iterator<Org4RescueVO> it = list.iterator();
        while (it.hasNext()) {
            Org4RescueVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4RescueVO newCount(List<String> ids, Org4RescueVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        List rescues = this.list((Wrapper)wrapper);
        orgVO.setCountNum(rescues.size());
        orgVO.setPeopleNum(rescues.stream().mapToInt(BizEmergencyRescueManagement::getPersonnelQuantity).sum());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BizEmergencyRescueManagementManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4RescueVO> getChild(List<Org4RescueVO> allList, String pCode) {
        ArrayList<Org4RescueVO> returnList = new ArrayList<Org4RescueVO>();
        for (Org4RescueVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizEmergencyRescueManagementManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizEmergencyRescueManagementVO> queryEmergencyRescueManagement(QueryFilter<BizEmergencyRescueManagement> queryFilter) {
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        PageList list = this.query(queryFilter);
        ArrayList<BizEmergencyRescueManagementVO> rerurnList = new ArrayList<BizEmergencyRescueManagementVO>();
        for (BizEmergencyRescueManagement model : list.getRows()) {
            BizEmergencyRescueManagementVO vo = new BizEmergencyRescueManagementVO();
            BeanUtils.copyProperties((Object)((Object)model), (Object)vo);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"STRUCTURAL_ID_", (Object)vo.getId());
            vo.setStructureVehicles(this.bizStructureVehicleManager.list((Wrapper)queryWrapper));
            rerurnList.add(vo);
        }
        PageList pageList = new PageList();
        pageList.setPage(list.getPage());
        pageList.setPageSize(list.getPageSize());
        pageList.setTotal(list.getTotal());
        pageList.setRows(rerurnList);
        return pageList;
    }
}

