/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.UserRoleDao;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.UserRole;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRoleManagerImpl
extends BaseManagerImpl<UserRoleDao, UserRole>
implements UserRoleManager {
    @Resource
    RoleManager roleService;

    @Override
    public UserRole getByRoleIdUserId(String roleId, String userId) {
        return ((UserRoleDao)this.baseMapper).getByRoleIdUserId(roleId, userId);
    }

    @Override
    public List<UserRole> getListByUserId(String userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.getParamNameValuePairs();
        if (params != null && params.size() > 0) {
            Map paramNameValuePairs = wrapper.getParamNameValuePairs();
            paramNameValuePairs.putAll(params);
        }
        return ((UserRoleDao)this.baseMapper).queryByParams((Wrapper<UserRole>)wrapper);
    }

    @Override
    public List<UserRole> getListByRoleId(String roleId) {
        return ((UserRoleDao)this.baseMapper).getListByRoleId(roleId);
    }

    @Override
    public List<UserRole> getListByAlias(String alias) {
        return ((UserRoleDao)this.baseMapper).getListByCode(alias);
    }

    @Override
    @Transactional
    public void saveUserRole(String account, String ... roleCodes) throws Exception {
        List<UserRole> userRoles = ((UserRoleDao)this.baseMapper).getByAccount(account);
        HashMap<String, UserRole> map = new HashMap<String, UserRole>();
        ArrayList<String> userRoleIds = new ArrayList<String>();
        for (UserRole userRole : userRoles) {
            userRoleIds.add(userRole.getId());
        }
        for (UserRole userRole : userRoles) {
            for (String code : roleCodes) {
                if (!code.equals(userRole.getAlias())) continue;
                map.put(code, userRole);
                userRoleIds.remove(userRole.getId());
            }
        }
        if (userRoleIds.size() > 0) {
            String[] ids = new String[userRoleIds.size()];
            userRoleIds.toArray(ids);
            this.removeByIds(ids);
        }
        Iterator keyIt = map.keySet().iterator();
        ArrayList<String> roleCodeList = new ArrayList<String>(Arrays.asList(roleCodes));
        while (keyIt.hasNext()) {
            String code = (String)keyIt.next();
            roleCodeList.remove(code);
            UserRole userRole = (UserRole)map.get(code);
            userRole.setIsDelete("0");
            this.update((Model)userRole);
        }
        for (String roleCode : roleCodeList) {
            this.roleService.saveUserRole(roleCode, account);
        }
    }

    @Override
    public PageList<UserRole> getUserRolePage(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        this.copyQuerysInParams(queryFilter);
        IPage<UserRole> query = ((UserRoleDao)this.baseMapper).queryByParams((IPage<UserRole>)this.convert2IPage(pageBean), (Wrapper<UserRole>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserRoleDao)this.baseMapper).removePhysical();
    }

    @Override
    @Transactional
    public void removeByUserId(String id, LocalDateTime now) {
        ((UserRoleDao)this.baseMapper).removeByUserId(id, now);
    }

    @Override
    @Transactional
    public void removeByRoleId(String roleId, LocalDateTime now) {
        ((UserRoleDao)this.baseMapper).removeByRoleId(roleId, now);
    }

    @Override
    public boolean insertBatch(List<UserRole> list) {
        return this.saveBatch(list);
    }
}

