/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.dao.ProjectAcceptanceDao;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.ProjectAcceptanceManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.ProjectAcceptance;
import com.artfess.yhxt.specialproject.vo.ProjectAcceptanceVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProjectAcceptanceManagerImpl
extends BaseManagerImpl<ProjectAcceptanceDao, ProjectAcceptance>
implements ProjectAcceptanceManager {
    @Resource
    private BizEngineeringAccessoriesManager engineeringAccessoriesManager;

    @Override
    public PageList<ProjectAcceptance> queryProjectAcceptance(QueryFilter<ProjectAcceptance> queryFilter) {
        IPage<ProjectAcceptance> result = ((ProjectAcceptanceDao)this.baseMapper).queryProjectAcceptance((IPage<ProjectAcceptance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectAcceptance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizEngineeringAccessories minioAcceptanceUpload(MultipartFile file, String sourceId) {
        return this.engineeringAccessoriesManager.minIoUpload(file, "acceptance", "", "yhxt", sourceId);
    }

    @Override
    public void minioAcceptanceDel(List<String> list) {
        if (list.size() > 0) {
            list.stream().forEach(s -> this.engineeringAccessoriesManager.minIoRemoveFile((String)s, "acceptance", "yhxt"));
        }
    }

    @Override
    public void minIoAcceptanceDownFile(String ids, HttpServletResponse response) throws Exception {
        this.engineeringAccessoriesManager.minIoDownFile(ids, "acceptance", "download/acceptance", "yhxt", response);
    }

    @Override
    public void saveVo(ProjectAcceptanceVo projectAcceptanceVo) {
        ProjectAcceptance projectAcceptance = projectAcceptanceVo.getProjectAcceptance();
        this.create((Model)projectAcceptance);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectAcceptanceVo.getBizEngineeringAccessoriesList();
        String sourceId = projectAcceptance.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.engineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(ProjectAcceptanceVo projectAcceptanceVo) {
        ProjectAcceptance projectAcceptance = projectAcceptanceVo.getProjectAcceptance();
        this.update((Model)projectAcceptance);
        String sourceId = projectAcceptance.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectAcceptanceVo.getBizEngineeringAccessoriesList();
        this.engineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.engineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public ProjectAcceptanceVo getVo(String id) {
        ProjectAcceptanceVo projectAcceptanceVo = new ProjectAcceptanceVo();
        ProjectAcceptance acceptance = (ProjectAcceptance)((Object)this.getById((Serializable)((Object)id)));
        projectAcceptanceVo.setProjectAcceptance(acceptance);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = this.engineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        projectAcceptanceVo.setBizEngineeringAccessoriesList(bizEngineeringAccessoriesList);
        return projectAcceptanceVo;
    }
}

