/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialproject.dao.MeasurementPaymentDao;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentDetailsManager;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.yhxt.specialproject.model.MeasurementPaymentDetails;
import com.artfess.yhxt.specialproject.params.ConstructionParamVo;
import com.artfess.yhxt.specialproject.vo.MeasurementPaymentVo;
import com.artfess.yhxt.util.ExcelToPdfUtil;
import com.artfess.yhxt.util.PoiStyleUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MeasurementPaymentManagerImpl
extends BaseManagerImpl<MeasurementPaymentDao, MeasurementPayment>
implements MeasurementPaymentManager {
    @Value(value="${pdfUrl}")
    private String pdfUrl;
    @Resource
    private MeasurementPaymentDetailsManager measurementPaymentDetailsManager;
    @Resource
    private BizEngineeringProjectManager bizEngineeringProjectManager;
    @Resource
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public MeasurementPaymentVo getVoById(String id) {
        MeasurementPaymentVo vo = new MeasurementPaymentVo();
        MeasurementPayment measurementPayment = (MeasurementPayment)((Object)this.getById((Serializable)((Object)id)));
        if (measurementPayment != null) {
            vo.setMeasurementPayment(measurementPayment);
            List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(measurementPayment.getId());
            vo.setFiles(accessories);
        }
        return vo;
    }

    @Override
    public void saveVo(MeasurementPaymentVo vo) {
        MeasurementPayment measurementPayment = vo.getMeasurementPayment();
        List<MeasurementPaymentDetails> details = vo.getDetails();
        this.create((Model)measurementPayment);
        if (CollectionUtils.isNotEmpty(details)) {
            details.forEach(s -> s.setMeasurementPaymentId(measurementPayment.getId()));
            this.measurementPaymentDetailsManager.saveBatch(details);
        }
        this.accessoryManager.delAccessoryBySourceId(measurementPayment.getId());
        List<Accessory> accessoryWorkOrderList = vo.getFiles();
        if (null != accessoryWorkOrderList && accessoryWorkOrderList.size() > 0) {
            accessoryWorkOrderList.forEach(s -> {
                s.setSourceId(measurementPayment.getId());
                s.setGroup("payment");
            });
            this.accessoryManager.saveBatch(accessoryWorkOrderList);
        }
    }

    @Override
    public void updateVo(MeasurementPaymentVo vo) {
        MeasurementPayment measurementPayment = vo.getMeasurementPayment();
        List<MeasurementPaymentDetails> details = vo.getDetails();
        this.update((Model)measurementPayment);
        boolean b = this.measurementPaymentDetailsManager.remove((Wrapper)new LambdaQueryWrapper().eq(MeasurementPaymentDetails::getMeasurementPaymentId, (Object)measurementPayment.getId()));
        if (b && CollectionUtils.isNotEmpty(details)) {
            this.measurementPaymentDetailsManager.saveBatch(details);
        }
        this.accessoryManager.delAccessoryBySourceId(measurementPayment.getId());
        List<Accessory> accessoryWorkOrderList = vo.getFiles();
        if (null != accessoryWorkOrderList && accessoryWorkOrderList.size() > 0) {
            accessoryWorkOrderList.forEach(s -> {
                s.setSourceId(measurementPayment.getId());
                s.setGroup("payment");
            });
            this.accessoryManager.saveBatch(accessoryWorkOrderList);
        }
    }

    @Override
    public boolean removeVo(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        boolean b = this.removeByIds(idList);
        if (b) {
            boolean result = this.measurementPaymentDetailsManager.remove((Wrapper)new LambdaQueryWrapper().in(MeasurementPaymentDetails::getMeasurementPaymentId, idList));
            return b;
        }
        return false;
    }

    @Override
    public HSSFWorkbook exportConstruction(ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        String projectId = param.getProjectId();
        String projectContractId = param.getProjectContractId();
        BizProjectContract bizProjectContract = new BizProjectContract();
        if (StringUtils.isNotEmpty((CharSequence)projectContractId)) {
            bizProjectContract = (BizProjectContract)((Object)this.bizProjectContractManager.getById((Serializable)((Object)projectContractId)));
        }
        BizEngineeringProject bizEngineeringProject = (BizEngineeringProject)((Object)this.bizEngineeringProjectManager.getBaseMapper().selectById((Serializable)((Object)projectId)));
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MeasurementPayment::getProjectId, (Object)projectId)).eq(MeasurementPayment::getProjectContractId, (Object)projectContractId));
        ArrayList paymentDetails = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (MeasurementPayment measurementPayment : list) {
                List details = this.measurementPaymentDetailsManager.list((Wrapper)new LambdaQueryWrapper().eq(MeasurementPaymentDetails::getMeasurementPaymentId, (Object)measurementPayment.getId()));
                paymentDetails.addAll(details);
            }
        }
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        HSSFSheet sheet = workbook.createSheet("\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09");
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        List collect = ((Stream)Stream.iterate(0, f -> f + 1).limit((paymentDetails.size() + 9) / 10).parallel()).map(a -> ((Stream)paymentDetails.stream().skip(a * 10).limit(10L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        sheet.setColumnWidth(0, 2560);
        sheet.setColumnWidth(1, 5120);
        sheet.setColumnWidth(2, 5120);
        sheet.setColumnWidth(3, 5120);
        sheet.setColumnWidth(4, 2048);
        sheet.setColumnWidth(5, 2048);
        sheet.setColumnWidth(6, 2048);
        sheet.setColumnWidth(7, 2560);
        sheet.setColumnWidth(8, 2560);
        sheet.setColumnWidth(9, 2560);
        if (StringUtils.isEmpty((CharSequence)projectContractId)) {
            this.defaultExportConstruction(cellStyleTitle, cellStyle1, cellStyle2, cellStyle3, cellStyle4, sheet, bizEngineeringProject);
        } else if (CollectionUtils.isEmpty(paymentDetails)) {
            this.exportPayMentDetails(bizProjectContract, bizEngineeringProject, list, cellStyleTitle, cellStyle1, cellStyle2, cellStyle3, cellStyle4, sheet);
        } else {
            int num = 0;
            for (List measurementPaymentDetails : collect) {
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, num, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\n\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09");
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 9));
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, ++num, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a" + bizEngineeringProject.getProjectName());
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, num, 6, "\u8868\u683c\u7f16\uff1a" + (CollectionUtils.isNotEmpty((Collection)list) ? ((MeasurementPayment)((Object)list.get(0))).getRecordNumber() : ""));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 0, 6));
                sheet.addMergedRegion(new CellRangeAddress(num, num, 6, 9));
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, ++num, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, num, 6, "\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a" + bizProjectContract.getContractNumber());
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, ++num, 0, "\u5e8f\u53f7");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 1, "\u6e05\u5355\u540d\u79f0");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 2, "\u65bd\u5de5/\u6536\u65b9\u65e5\u671f");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 3, "\u5de5\u7a0b\u90e8\u4f4d\u53ca\u6869\u53f7");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 4, "\u6536\u65b9\u793a\u610f\u56fe/\u8ba1\u7b97\u5f0f");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 7, "\u5355\u4f4d");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 8, "\u6570\u91cf");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num, 9, "\u5907\u6ce8");
                for (int i = 0; i < measurementPaymentDetails.size(); ++i) {
                    MeasurementPaymentDetails paymentDetail = (MeasurementPaymentDetails)((Object)measurementPaymentDetails.get(i));
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 0, String.valueOf(i + 1));
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 1, paymentDetail.getSubjectName());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 2, paymentDetail.getCommencementDate() == null ? "" : paymentDetail.getCommencementDate().toString());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 3, paymentDetail.getCalculaMethod());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 4, paymentDetail.getCalculaMethod());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 7, paymentDetail.getSubjectUnit());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 8, paymentDetail.getSubjectAmount() == null ? "" : paymentDetail.getSubjectAmount().toString());
                    PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, num + i, 9, paymentDetail.getRemark());
                    ++num;
                }
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a              \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a          \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a           \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u7ecf\u529e\u4eba\uff1a");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, num, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a                                \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a           \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a");
                ++num;
            }
        }
        return workbook;
    }

    @Override
    public HashMap onlinePreviewConstruction(ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = this.exportConstruction(param, response);
        String path = "./download/" + param.getProjectId();
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        String outUrl = path + "/\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868-\u65bd\u5de5\u7c7b.xls";
        String outUrlPdf = path + "/\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868-\u65bd\u5de5\u7c7b.pdf";
        FileOutputStream out = new FileOutputStream(outUrl);
        workbook.write((OutputStream)out);
        ExcelToPdfUtil.excelToPdf(outUrl, outUrlPdf);
        String url = this.pdfUrl + param.getProjectId() + "/\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868-\u65bd\u5de5\u7c7b.pdf";
        System.out.println(url);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", url);
        return map;
    }

    @Override
    public HSSFWorkbook exportCollect(ConstructionParamVo param, HttpServletResponse response) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        String projectId = param.getProjectId();
        String projectContractId = param.getProjectContractId();
        BizProjectContract bizProjectContract = new BizProjectContract();
        if (StringUtils.isNotEmpty((CharSequence)projectContractId)) {
            bizProjectContract = (BizProjectContract)((Object)this.bizProjectContractManager.getById((Serializable)((Object)projectContractId)));
        }
        BizEngineeringProject bizEngineeringProject = (BizEngineeringProject)((Object)this.bizEngineeringProjectManager.getBaseMapper().selectById((Serializable)((Object)projectId)));
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MeasurementPayment::getProjectId, (Object)projectId)).eq(MeasurementPayment::getProjectContractId, (Object)projectContractId));
        ArrayList paymentDetails = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (MeasurementPayment measurementPayment : list) {
                List details = this.measurementPaymentDetailsManager.list((Wrapper)new LambdaQueryWrapper().eq(MeasurementPaymentDetails::getMeasurementPaymentId, (Object)measurementPayment.getId()));
                paymentDetails.addAll(details);
            }
        }
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        HSSFCellStyle cellStyle4 = workbook.createCellStyle();
        PoiStyleUtil.setWorkOrderStyleTitle(cellStyleTitle, workbook);
        PoiStyleUtil.setWorkOrderCellStyle1(cellStyle1, workbook);
        PoiStyleUtil.setWorkOrderCellStyle2(cellStyle2, workbook);
        PoiStyleUtil.setWorkOrderCellStyle3(cellStyle3, workbook);
        PoiStyleUtil.setWorkOrderCellStyle4(cellStyle4, workbook);
        HSSFSheet sheet = workbook.createSheet("\u5de5\u7a0b\u91cf\u6c47\u603b\u8868");
        sheet.getPrintSetup().setPaperSize((short)9);
        sheet.getPrintSetup().setLandscape(true);
        List collect = ((Stream)Stream.iterate(0, f -> f + 1).limit((paymentDetails.size() + 9) / 10).parallel()).map(a -> ((Stream)paymentDetails.stream().skip(a * 10).limit(10L).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        sheet.setColumnWidth(0, 2560);
        sheet.setColumnWidth(1, 5120);
        sheet.setColumnWidth(2, 5120);
        sheet.setColumnWidth(3, 5120);
        sheet.setColumnWidth(4, 3840);
        sheet.setColumnWidth(5, 3840);
        sheet.setColumnWidth(6, 3840);
        if (StringUtils.isEmpty((CharSequence)projectContractId)) {
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, 0, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\n\u5de5\u7a0b\u91cf\u6c47\u603b\u8868");
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
            PoiStyleUtil.sheetSetHight(sheet, 0, 50);
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 0, "\u8ba1\u91cf\u671f\u6570\uff1a\u7b2c\uff08 \uff09\u671f");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 6, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle1, 1, 5, "");
            PoiStyleUtil.sheetSetHight(sheet, 1, 20);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 6));
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a" + bizEngineeringProject.getProjectName());
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 5, "\u8868\u683c\u7f16\u53f7\uff1a");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 6, "");
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 4));
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 5, 6));
            PoiStyleUtil.sheetSetHight(sheet, 2, 20);
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a\uff1a");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 5, "\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 3, 6, "");
            sheet.addMergedRegion(new CellRangeAddress(3, 3, 0, 4));
            sheet.addMergedRegion(new CellRangeAddress(3, 3, 5, 6));
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 0, "\u5e8f\u53f7");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 1, "\u6e05\u5355\u540d\u79f0");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 2, "\u5355\u4f4d");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 3, "\u6570\u91cf");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 4, "\u2026\u2026");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 5, "\u6536\u65b9\u8bb0\u5f55\u8868\u7f16\u53f7");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4, 6, "\u5907\u6ce8");
            PoiStyleUtil.sheetSetHight(sheet, 4, 20);
            for (int i = 0; i < 10; ++i) {
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 0, String.valueOf(i + 1));
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 1, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 2, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 3, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 4, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 5, "");
                PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 5 + i, 6, "");
                PoiStyleUtil.sheetSetHight(sheet, 5 + i, 30);
            }
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 15, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a                                 \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                           \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a              \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u7ecf\u529e\u4eba\uff1a");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 16, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a                             \u603b\u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                          \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a              \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a");
            PoiStyleUtil.sheetSetHight(sheet, 15, 20);
            PoiStyleUtil.sheetSetHight(sheet, 16, 20);
            sheet.addMergedRegion(new CellRangeAddress(15, 15, 0, 6));
            sheet.addMergedRegion(new CellRangeAddress(16, 16, 0, 6));
        } else if (CollectionUtils.isEmpty(paymentDetails)) {
            // empty if block
        }
        return workbook;
    }

    @Override
    public HashMap onlinePreviewCollect(ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = this.exportCollect(param, response);
        String path = "./download/" + param.getProjectId();
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        String outUrl = path + "/\u5de5\u7a0b\u6536\u65b9\u6c47\u603b\u8868.xls";
        String outUrlPdf = path + "/\u5de5\u7a0b\u6536\u65b9\u6c47\u603b\u8868.pdf";
        FileOutputStream out = new FileOutputStream(outUrl);
        workbook.write((OutputStream)out);
        ExcelToPdfUtil.excelToPdf(outUrl, outUrlPdf);
        String url = this.pdfUrl + param.getProjectId() + "/\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868-\u65bd\u5de5\u7c7b.pdf";
        System.out.println(url);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", url);
        return map;
    }

    private void exportPayMentDetails(BizProjectContract bizProjectContract, BizEngineeringProject bizEngineeringProject, List<MeasurementPayment> list, HSSFCellStyle cellStyleTitle, HSSFCellStyle cellStyle1, HSSFCellStyle cellStyle2, HSSFCellStyle cellStyle3, HSSFCellStyle cellStyle4, HSSFSheet sheet) {
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, 0, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\n\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09");
        PoiStyleUtil.sheetSetHight(sheet, 0, 50);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a" + bizEngineeringProject.getProjectName());
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 6, "\u8868\u683c\u7f16\uff1a" + (CollectionUtils.isNotEmpty(list) ? list.get(0).getRecordNumber() : ""));
        PoiStyleUtil.sheetSetHight(sheet, 1, 20);
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 6, "\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a" + bizProjectContract.getContractNumber());
        PoiStyleUtil.sheetSetHight(sheet, 2, 20);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 0, "\u5e8f\u53f7");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 1, "\u6e05\u5355\u540d\u79f0");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 2, "\u65bd\u5de5/\u6536\u65b9\u65e5\u671f");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 3, "\u5de5\u7a0b\u90e8\u4f4d\u53ca\u6869\u53f7");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 4, "\u6536\u65b9\u793a\u610f\u56fe/\u8ba1\u7b97\u5f0f");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 5, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 6, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 7, "\u5355\u4f4d");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 8, "\u6570\u91cf");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 9, "\u5907\u6ce8");
        PoiStyleUtil.sheetSetHight(sheet, 3, 20);
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 6));
        for (int i = 0; i < 10; ++i) {
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 0, String.valueOf(i + 1));
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 5, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 6, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 7, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 8, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 9, "");
            PoiStyleUtil.sheetSetHight(sheet, 4 + i, 30);
            sheet.addMergedRegion(new CellRangeAddress(4 + i, 4 + i, 4, 6));
        }
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 14, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a                            \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                            \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a                    \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u7ecf\u529e\u4eba\uff1a");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 15, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a                                                                \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a           \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a");
        PoiStyleUtil.sheetSetHight(sheet, 14, 20);
        PoiStyleUtil.sheetSetHight(sheet, 15, 20);
        sheet.addMergedRegion(new CellRangeAddress(14, 14, 0, 9));
        sheet.addMergedRegion(new CellRangeAddress(15, 15, 0, 9));
    }

    private void defaultExportConstruction(HSSFCellStyle cellStyleTitle, HSSFCellStyle cellStyle1, HSSFCellStyle cellStyle2, HSSFCellStyle cellStyle3, HSSFCellStyle cellStyle4, HSSFSheet sheet, BizEngineeringProject bizEngineeringProject) {
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyleTitle, 0, 0, "\u4e2d\u56fd\u94c1\u5efa\u6606\u4ed1\u96c6\u56e2\u91cd\u5e86\u8fd0\u8425\u603b\u90e8\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868\uff08\u65bd\u5de5\u7c7b\uff09");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
        PoiStyleUtil.sheetSetHight(sheet, 0, 50);
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 0, "\u5de5\u7a0b\u540d\u79f0\uff08\u627f\u5305\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff09\uff1a" + bizEngineeringProject.getProjectName());
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 6, "\u8868\u683c\u7f16\uff1a");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 1, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 2, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 3, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 4, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 5, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 7, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 8, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 1, 9, "");
        PoiStyleUtil.sheetSetHight(sheet, 1, 20);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 0, "\u5bf9\u65b9\u5355\u4f4d\uff1a");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 6, "\u5408\u540c\u53f7/\u9879\u76ee\u7f16\u53f7\uff1a");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 1, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 2, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 3, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 4, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 5, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 7, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 8, "");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle2, 2, 9, "");
        PoiStyleUtil.sheetSetHight(sheet, 2, 20);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 6, 9));
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 0, "\u5e8f\u53f7");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 1, "\u6e05\u5355\u540d\u79f0");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 2, "\u65bd\u5de5/\u6536\u65b9\u65e5\u671f");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 3, "\u5de5\u7a0b\u90e8\u4f4d\u53ca\u6869\u53f7");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 4, "\u6536\u65b9\u793a\u610f\u56fe/\u8ba1\u7b97\u5f0f");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 5, "\u6536\u65b9\u793a\u610f\u56fe/\u8ba1\u7b97\u5f0f");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 6, "\u6536\u65b9\u793a\u610f\u56fe/\u8ba1\u7b97\u5f0f");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 7, "\u5355\u4f4d");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 8, "\u6570\u91cf");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 3, 9, "\u5907\u6ce8");
        PoiStyleUtil.sheetSetHight(sheet, 3, 20);
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 6));
        for (int i = 0; i < 10; ++i) {
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 0, String.valueOf(i + 1));
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 1, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 2, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 3, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 4, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 5, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 6, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 7, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 8, "");
            PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle3, 4 + i, 9, "");
            PoiStyleUtil.sheetSetHight(sheet, 4 + i, 30);
            sheet.addMergedRegion(new CellRangeAddress(4 + i, 4 + i, 4, 6));
        }
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 14, 0, "\u65bd\u5de5\u5355\u4f4d\u7ecf\u529e\u4eba\uff1a                            \u76d1\u7406\u5de5\u7a0b\u5e08\uff1a                            \u7ba1\u7406\u4e2d\u5fc3\u7ecf\u529e\u4eba\uff1a                    \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u7ecf\u529e\u4eba\uff1a");
        PoiStyleUtil.sheetStyleAndValue(sheet, cellStyle4, 15, 0, "\u65bd\u5de5\u5355\u4f4d\u9879\u76ee\u8d1f\u8d23\u4eba\uff1a                                                                \u7ba1\u7406\u4e2d\u5fc3\u8d1f\u8d23\u4eba\uff1a           \u603b\u90e8\u4e1a\u52a1\u90e8\u95e8\u8d1f\u8d23\u4eba\uff1a");
        PoiStyleUtil.sheetSetHight(sheet, 14, 20);
        PoiStyleUtil.sheetSetHight(sheet, 15, 20);
        sheet.addMergedRegion(new CellRangeAddress(14, 14, 0, 9));
        sheet.addMergedRegion(new CellRangeAddress(15, 15, 0, 9));
    }
}

