/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.schedule;

import com.artfess.base.util.DateUtils;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.yhxt.specialcheck.dao.InspectionTaskConfigDao;
import com.artfess.yhxt.specialcheck.manager.SiteInspectionManager;
import com.artfess.yhxt.specialcheck.model.InspectionTaskConfig;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@EnableScheduling
public class ScheduledInspectionTask {
    @Resource
    private SiteInspectionManager siteInspectionManager;
    @Resource
    private InspectionTaskConfigDao inspectionTaskConfigDao;
    @Resource
    private IProcessManager iProcessManager;

    @Scheduled(cron="0 30 1 * * ?")
    @Transactional(rollbackFor={Exception.class})
    public void scheduledInspectionTask() throws Exception {
        System.out.println("\u5b9a\u65f6\u5668\u5f00\u59cb\u6267\u884c");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)0);
        queryWrapper.eq((Object)"STATUS_", (Object)"0");
        List taskConfigs = this.inspectionTaskConfigDao.selectList((Wrapper)queryWrapper);
        for (InspectionTaskConfig taskConfig : taskConfigs) {
            if (taskConfig.getTaskType() == 1) {
                this.inspectionTaskStartMouth(taskConfig);
            }
            if (taskConfig.getTaskType() != 2 || !LocalDate.now().isAfter(taskConfig.getPatrolDate()) && !LocalDate.now().equals(taskConfig.getPatrolDate())) continue;
            this.inspectionTaskStart(taskConfig);
        }
        System.out.println("\u5b9a\u65f6\u5668\u7ed3\u675f\u6267\u884c");
    }

    private void inspectionTaskStartMouth(InspectionTaskConfig taskConfig) throws Exception {
        LocalDate patrolDate = taskConfig.getPatrolDate();
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        if (LocalDate.now().isAfter(patrolDate) && ca.get(5) == 1) {
            Calendar calendar = DateUtils.getCalendar();
            calendar.set(5, 1);
            calendar.roll(5, -1);
            int maxDate = calendar.get(5);
            int count = maxDate / taskConfig.getFrequency();
            Calendar cal = DateUtils.getCalendar();
            cal.add(2, 0);
            cal.set(5, 1);
            Integer i = 0;
            while (i < taskConfig.getFrequency()) {
                Comparable<Integer> time;
                Object siteInspection;
                if (i > 0) {
                    cal.add(5, count);
                }
                if (LocalDate.now().equals(cal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
                    siteInspection = new SiteInspection();
                    ((SiteInspection)((Object)siteInspection)).setRouteId(taskConfig.getRouteId());
                    ((SiteInspection)((Object)siteInspection)).setRouteName(taskConfig.getRouteName());
                    ((SiteInspection)((Object)siteInspection)).setRoadSegmentId(taskConfig.getRoadSegmentId());
                    ((SiteInspection)((Object)siteInspection)).setRoadSegmentName(taskConfig.getRoadSegmentName());
                    ((SiteInspection)((Object)siteInspection)).setCompanyId(taskConfig.getCompanyId());
                    ((SiteInspection)((Object)siteInspection)).setCompanyName(taskConfig.getCompanyName());
                    ((SiteInspection)((Object)siteInspection)).setManageUnitId(taskConfig.getManageUnitId());
                    ((SiteInspection)((Object)siteInspection)).setManageUnitName(taskConfig.getManageUnitName());
                    ((SiteInspection)((Object)siteInspection)).setRummagerId(taskConfig.getRummagerId());
                    ((SiteInspection)((Object)siteInspection)).setRummagerAccount(taskConfig.getRummagerAccount());
                    ((SiteInspection)((Object)siteInspection)).setType(taskConfig.getType());
                    ((SiteInspection)((Object)siteInspection)).setContent(taskConfig.getContent());
                    time = cal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    ((SiteInspection)((Object)siteInspection)).setPatrolDate((LocalDate)time);
                    siteInspection.setCreateBy(taskConfig.getCreateBy());
                    siteInspection.setCreateCompanyName(taskConfig.getCreateCompanyName());
                    siteInspection.setCreateCompanyId(taskConfig.getCreateCompanyId());
                    siteInspection.setCreateOrgId(taskConfig.getCreateCompanyId());
                    this.siteInspectionManager.saveSite((SiteInspection)((Object)siteInspection));
                }
                siteInspection = i;
                time = i = Integer.valueOf(i + 1);
            }
        }
        if (LocalDate.now().equals(patrolDate)) {
            LocalDate localDate = LocalDate.now();
            LocalDate lastDate = localDate.with(TemporalAdjusters.lastDayOfMonth());
            int days = Period.between(localDate, lastDate).getDays();
            int count = days / taskConfig.getFrequency();
            Calendar cal = DateUtils.getCalendar();
            Integer i = 0;
            while (i < taskConfig.getFrequency()) {
                if (i > 0) {
                    cal.add(5, count);
                }
                if (LocalDate.now().equals(cal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
                    SiteInspection siteInspection = new SiteInspection();
                    siteInspection.setRouteId(taskConfig.getRouteId());
                    siteInspection.setRouteName(taskConfig.getRouteName());
                    siteInspection.setRoadSegmentId(taskConfig.getRoadSegmentId());
                    siteInspection.setRoadSegmentName(taskConfig.getRoadSegmentName());
                    siteInspection.setCompanyId(taskConfig.getCompanyId());
                    siteInspection.setCompanyName(taskConfig.getCompanyName());
                    siteInspection.setManageUnitId(taskConfig.getManageUnitId());
                    siteInspection.setManageUnitName(taskConfig.getManageUnitName());
                    siteInspection.setRummagerId(taskConfig.getRummagerId());
                    siteInspection.setRummagerAccount(taskConfig.getRummagerAccount());
                    siteInspection.setType(taskConfig.getType());
                    siteInspection.setContent(taskConfig.getContent());
                    siteInspection.setPatrolDate(LocalDate.now());
                    siteInspection.setCreateOrgId(taskConfig.getCreateOrgId());
                    siteInspection.setCreateName(taskConfig.getCreateName());
                    System.out.println((Object)siteInspection);
                    this.siteInspectionManager.saveSite(siteInspection);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    private void inspectionTaskStart(InspectionTaskConfig taskConfig) throws Exception {
        Integer i = 0;
        while (i < taskConfig.getFrequency()) {
            SiteInspection siteInspection = new SiteInspection();
            siteInspection.setRouteId(taskConfig.getRouteId());
            siteInspection.setRouteName(taskConfig.getRouteName());
            siteInspection.setRoadSegmentId(taskConfig.getRoadSegmentId());
            siteInspection.setRoadSegmentName(taskConfig.getRoadSegmentName());
            siteInspection.setCompanyId(taskConfig.getCompanyId());
            siteInspection.setCompanyName(taskConfig.getCompanyName());
            siteInspection.setManageUnitId(taskConfig.getManageUnitId());
            siteInspection.setManageUnitName(taskConfig.getManageUnitName());
            siteInspection.setRummagerId(taskConfig.getRummagerId());
            siteInspection.setRummagerAccount(taskConfig.getRummagerAccount());
            siteInspection.setType(taskConfig.getType());
            siteInspection.setContent(taskConfig.getContent());
            siteInspection.setPatrolDate(LocalDate.now());
            siteInspection.setCreateBy(taskConfig.getCreateBy());
            siteInspection.setCreateName(taskConfig.getCreateName());
            siteInspection.setCreateCompanyName(taskConfig.getCreateCompanyName());
            siteInspection.setCreateCompanyId(taskConfig.getCreateCompanyId());
            siteInspection.setCreateOrgId(taskConfig.getCreateCompanyId());
            siteInspection.setCreateOrgId(taskConfig.getCreateOrgId());
            siteInspection.setCreateName(taskConfig.getCreateName());
            this.siteInspectionManager.saveSite(siteInspection);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }
}

